# nis.tcl
#
# Copyright (C) 1994 Matthew R. Wette -- All rights reserved.
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appears in all copies.  Matthew R. Wette
# makes no representations about the suitability of this software for any
# purpose.  It is provided "as is" without express or implied warranty.
#
# history -
#	03Feb94	M.Wette: created.
#
# version -
#	$Id: nis.tcl,v 1.2 1994/04/19 17:29:07 mwette Exp $

# global variables -
#	nis_library	library directory
#	nis_cwd		current working directory (default: org_dir.domain)
#	nis_prn		NIS principal
#	nis_grp		NIS group
#
# procedures -
#	nis_key		hmmmm... should be [nis_result $res key]
#	nis_match	match an item from a table
#	nis_cat 	return list of entries from table

set nis_cwd org_dir.[nis_local_directory]
set nis_prn [nis_local_principal]
set nis_grp [nis_local_group]

proc nis_key {res} {
  set obj [nis_result $res object]
  set str [nis_object $obj expand]
  set key [lindex $str 0]
  return $key
}

proc nis_match {item table} {
  global nis_cwd
  set res [nis_first_entry $table]
  while {1} {
    if [catch {nis_next_entry $table $res} next_res] { break }
    set res $next_res
    if {[nis_key $res]==$item} { break; }
  }
  return [nis_result $res expand]
}

proc nis_cat {table} {
  global nis_cwd
  set res [nis_first_entry $table]
  while {1} {
    lappend list [nis_result $res expand]
    if [catch {nis_next_entry $table $res} next_res] { break }
    set res $next_res
  }
  return $list
}


