# updatelist.tcl
#----------------------------------------------------------------------------
# Copyright 1994 Siemens KWU Erlangen
# Permission to use, copy, modify, and distribute this documentation
# is hereby granted, provided that this copyright notice appears
# in all copies. This software is provided without any warranty, express
# or implied. Siemens KWU Erlangen makes no representations about the
# suitability of this software for any purpose.
#
# Author: Johan Lindbladh (tet90jl@tintin.hik.se)
#----------------------------------------------------------------------------
# This script updates the sendlist when a new item is included
#----------------------------------------------------------------------------
######## Variables: 
# widgetname( )  array which contains the name of the current part 
# contenttype( ) array which contains the contentype of the current part
# body()         array which contains the body of the current part
# description(() array which contains the description of the current part
# currentwidgetnumber() array which contains the number of a widget and 
#                       uses the the index widgetname

#----------------------------------------------------------------------------
#### proc updatesendlist ####
#----------------------------------------------------------------------------
proc updatesendlist {startnumber sumofwin} {
global widgetname
global contenttype
global body
global description
global currentwidgetnumber

#----------------------------------------------------------------------------
# updates the currentwidgetnumber() after the insertion
#----------------------------------------------------------------------------
for {set i $sumofwin} {$i > $startnumber} {incr i -1} {
	set currentwidgetnumber($widgetname([expr $i-1])) $i
	}

#----------------------------------------------------------------------------
# updates the sendlist from sumofwin downto insertnumber
#----------------------------------------------------------------------------
for {set i $sumofwin} {$i > $startnumber} {incr i -1} {
	set widgetname($i)  $widgetname([expr $i-1])
	set contenttype($i) $contenttype([expr $i-1])
	set body($i) $body([expr $i-1])
        set description($i) $description([expr $i-1])
	}
}
