#!/usr/local/bin/wish -f
#

proc Exmh_Focus {} {
}

proc nn_send {draft t} {
    global aux_dir aux_prog aux_POST sedit aux_MAILER

    set id [SeditId $draft]

    if {$sedit(autoSign) && ($sedit($t,sigfile) != "") && 
	![info exists exmh($id,mhannodist)]} {
	set b .sedit${id}.but
	eval [option get $b.sign command {}] $sedit($t,sigfile)
    }

    SeditSave "$aux_dir/$draft" $t
    if {$aux_prog == "post" || $aux_prog == "follow"} {
	eval "exec $aux_POST $aux_dir/$draft"
    } elseif {$aux_prog == "mail" || $aux_prog == "reply" \
	    || $aux_prog == "forward"} {
	eval "exec $aux_MAILER <$aux_dir/$draft"
    }
    SeditQuit "$aux_dir/$draft" $t
}


proc ExwinFixupFtextLines { args } {
    puts ExwinFixupFtextLines 
}

proc exmh_bind_e {} {
    global sedit

    case $sedit(scrollButton) {
	Right {bind Entry <B3-Motion> {%W scan dragto %x}}
	Middle {bind Entry <B2-Motion> {%W scan dragto %x}}
	ShiftMiddle {bind Entry <Shift-B2-Motion> {%W scan dragto %x}}
	None {}
    }
}

proc nn_PreferencesSave {} {
    global pref
#   I think this was required by an earlier exmh version
    if {[info procs PreferencesSaveEntries] != ""} {
	PreferencesSaveEntries
    }
    set newstuff {}
    foreach id $pref(panes) {
        foreach item $pref($id,prefs) {
            set varName [PrefVar $item]
            set xresName [PrefXres $item]
            set value [PrefValue $varName $xresName]
            lappend newstuff [format "%s\t%s" *${xresName}: $value]
        }
    }
    Preferences_RewriteSection "Lines below here automatically added" \
	    "End Preferences State" $newstuff
    PreferencesReset
}

proc nn_Sedit_BindInit {} {
    global sedit

    set sedit(key,selpaste) {<Control-y> <Button-2>}
    set sedit(key,seldelete) {<Control-w> <Key-Delete>}
    set sedit(key,backspace) {<Control-h> <Key-BackSpace>}
    set sedit(key,openline) <Control-o>
    set sedit(key,deleol) <Control-k>
    set sedit(key,delbol) <Control-x><Key-Delete>
    set sedit(key,delwordforw) <Meta-d>
    set sedit(key,delwordback) <Meta-h>
    set sedit(key,delchar) <Control-d>
    set sedit(key,transpose) <Control-t>
    set sedit(key,transword) <Meta-t>

    set sedit(key,bof)	<Meta-less>
    set sedit(key,eof)	<Meta-greater>
    set sedit(key,linestart) <Control-a>
    set sedit(key,lineend) <Control-e>
    set sedit(key,up1line) {<Control-p> <Key-Up>}
    set sedit(key,down1line) {<Control-n> <Key-Down>}
    set sedit(key,backword) <Meta-b>
    set sedit(key,forwword) <Meta-f>
    set sedit(key,backchar) {<Control-b> <Key-Left>}
    set sedit(key,forwchar) {<Control-f> <Key-Right>}
    set sedit(key,up1page) <Meta-v>
    set sedit(key,down1page) <Control-v>

    set sedit(dotfile) ~/.exmhsedit

    set sedit(typeKillsSel) 1
    set sedit(scrollButton) ShiftMiddle

    SeditReadPref
    Sedit_ClassBindings
    exmh_bind_e
}

proc exmh_init {} {
    global nn_directory  nn_x_dir
    global mime widgetText exmh msg mhProfile
    global widgetText env pref sedit

    if {! [info exists env(USER)]} {
	set env(USER) dummy
    }


    if [info exists env(MH)] {
        set mhProfile(profile) $env(MH)
    } else {
        set mhProfile(profile) $env(HOME)/.mh_profile
    }

    set mime(dir) /usr/local/bin

    set exmh(version) nn-tk.7
    set exmh(library) $nn_x_dir/tcl/exmh
    set exmh(folder)  $nn_directory

    set mhProfile(draft-folder) $nn_directory
    set mhProfile(header-suppress) {}
    set mhProfile(header-display) {}

    set msg(id) 1
    set sedit(sigfileDefault) .signature

    set pref(uid) 0
    set pref(panes) {}

    set pref(appDefaults) $nn_x_dir/tcl/exmh/app-defaults
    set pref(userDefaults) $nn_directory/tk-config

    PreferencesReadFile $nn_x_dir/tcl/exmh/app-defaults startup

    Mime_Init
    Widget_TextInit
    Exwin_Init
    Busy_Init

    nn_Sedit_BindInit

    Mh_Preferences

    set pref(panes) {MIME "Busy Indicator"}
}

proc start_mime {t} {
    .more.t configure -wrap word
    MsgShowInText .more.t $t
}

proc clear_mime {} {
    Mime_Cleanup .more.t
    .more.t configure -state normal
    more_tags
    .more.t configure -wrap none
}

proc do_send {prog tmp} {
    global  aux_WORK sedit
    global aux_dir aux_prog
    upvar mhProfile mhProfile

    set aux_prog $prog
    set n [string last "/" $aux_WORK]
    set aux_dir [string range $aux_WORK 0 [expr $n-1]]
    set t_file  [string range $aux_WORK  [expr $n+1] end]
    set mhProfile(path) $aux_dir

    set cur_dir [pwd]
    cd $aux_dir

    if {$aux_prog == "post" || $aux_prog == "follow"} {
	set sn [nn_get_var append-signature-post]
    } elseif {$aux_prog == "mail" || $aux_prog == "reply" || $aux_prog == "forward" } {
	set sn [nn_get_var append-signature-mail]	
    }
    if {$sn == "on"} {
	set sedit(autoSign) 1
    } else {
	set sedit(autoSign) 0
    }

    Sedit_Start $t_file
    cd $cur_dir
}

