#
# Code for doing query or global replacements in Misc widgets
#

proc th_Misc_replace_setup {w} {
  set rf [th_show_entry $w replace]
  set sf "[winfo parent $rf].search"
  $rf.l configure -text "Change to:"
  global TH auto_index
  set TH(Replace,Width,$w) [lindex [$sf.e configure -width] 4]
  if {[set width [string length [$sf.e get]]] > 10} {set width 10}
  $sf.e configure -width $width
  set TH(Replace,Count,$w) 0
  foreach binding {OK Cancel Search_Forward Search_Backward
		Toggle_Incremental_Search Toggle_Case_Sensitivity} {
    th_bind $rf.e $binding [th_bind $sf.e $binding]
  }
  if {[winfo class $w] == "Text"} {
    th_bind $rf.e Highlight_Searches [th_bind $sf.e Highlight_Searches]
  }
  th_bind $rf.e Replace_One "th_Misc_replace_one $w"
  th_bind $rf.e Replace_All "th_Misc_replace_all $w"

  set class [winfo class $w]
  if {([info procs th_[set class]_replace_setup] != "") || \
     ([lsearch [array names auto_index] th_[set class]_replace_setup] >= 0)} {
    th_[set class]_replace_setup $w
}}

proc th_Misc_replace_one {w} {
  th_[winfo class $w]_replace_one $w
  th_Misc_find $w [[th_frame $w].search.e get] 1
}

proc th_Misc_replace_all {w} {
  th_[winfo class $w]_replace_one $w
  set se "[th_frame $w].search.e"
  set re "[th_frame $w].replace.e"
  set old_string [$se get]
  while {[th_Misc_find $w $old_string 1]} { th_[winfo class $w]_replace_one $w }
  th_Misc_search_exit $w
  $se delete 0 end
  $se insert 0 [$re get]
}

proc th_Misc_replace_exit {w} {
  th_hide_entry $w replace
  global TH auto_index
  th_flash_label $w -text "Replaced $TH(Replace,Count,$w) occurrences."
  set f [th_frame $w]
  $f.search.e configure -width $TH(Replace,Width,$w)

  set class [winfo class $w]
  if {([info procs th_[set class]_replace_exit] != "") || \
     ([lsearch [array names auto_index] th_[set class]_replace_exit] >= 0)} {
    th_[set class]_replace_exit $w
}}


