#
# Module for balancing parens in Text widgets
#


# Returns index of closesst previous lone left partner, or "" if unsuccessful.
proc th_Text_left_exp {w index exp_type {out_flag 0}} {
  set left [lindex $exp_type 0]
  set right [lindex $exp_type 1]
  set close_trace [$w index $index]
  if $out_flag {set close_trace [$w index "$index -1c"]}
  set open_trace $close_trace
  while (1) {
    if {[set open_trace [th_Text_string_last $w $left $open_trace]] \
        == ""} {return ""}
    if {[set close_trace [th_Text_string_last $w $right $close_trace \
        $open_trace]] == ""} {return "$open_trace +1c"}
}}

# Returns index of closest next lone right partner, or "" if unsuccessful.
proc th_Text_right_exp {w index exp_type} {
  set left [lindex $exp_type 0]
  set right [lindex $exp_type 1]
  set close_trace [$w index "$index -1c"]
  set open_trace $close_trace
  while (1) {
    if {[set close_trace [th_Text_string_first $w $right \
        "$close_trace +1c"]] == ""} {return ""}
    if {[set open_trace [th_Text_string_first $w $left \
        "$open_trace +1c" $close_trace]] == ""} {
      return $close_trace}
}}

proc th_Text_left_exp_out {w index exp_type} {
  set new [th_Text_left_exp $w $index $exp_type]
  if {$new == ""} {return} else {return "$new -1c"}
}

proc th_Text_right_exp_out {w index exp_type} {
  set new [th_Text_right_exp $w $index $exp_type]
  if {$new == ""} {return} else {return "$new +1c"}
}


# Returns a message for match being found (of exp_type). Match may be empty;
# in which case nothing is returned.
proc th_Text_report_exp {w match} {
  global TH
  catch {$w tag remove $TH(Paren,Select,Text) 1.0 end}
  if {($match == "")} {return ""}

# Not used, this just forces the frame module to autoload so we can have
# TH(Label,Flash).
  set f [th_frame $w]

  $w tag add $TH(Paren,Select,Text) "$match -1c" $match
  after $TH(Label,Flash) $w tag remove $TH(Paren,Select,Text) 1.0 end
  return [$w get "$match linestart" $match]
}

# Counts instances of $c between $start and $end in $w
proc th_Text_char_count {w c start end} {
  set offset 0 ; set count 0
  set c [string trimleft $c \\]
  while {([set trace [th_Text_string_first $w $c $start $end]] != "")} {
    incr count
    set start [$w index "$trace +1c"]
  }
  return $count
}


