#
# Module for balancing parens in Misc widgets
#

set TH(Paren,Paren) [list \( \) <parenleft> <parenright>]
set TH(Paren,Bracket) [list \[ \] <bracketleft> <bracketright>]
set TH(Paren,Brace) [list \{ \} <braceleft> <braceright>]
set TH(Paren,Angle) [list \< \> <less> <greater>]

proc th_Misc_paren_reeval {w} {
  if {![winfo exists $w]} {return}
  global TH
  if {([winfo class $w] == "Text") && ($TH(Paren,Select,Text) != "sel")} {
    eval $w tag configure $TH(Paren,Select,Text) $TH(Paren,Text,Tag)
  }
  set TH(Paren,List,$w) ""
  foreach exp {Paren Bracket Brace Angle} {
    set right_key [lindex $TH(Paren,$exp) 1]
    set right_keysym [lindex $TH(Paren,$exp) 3]
    if {[catch "set TH(Exp,$exp,$w)"]} {set TH(Exp,$exp,$w) $TH(Exp,$exp)}
    if $TH(Exp,$exp,$w) {
      lappend TH(Paren,List,$w) $TH(Paren,$exp)
      bind $w $right_keysym "th_[winfo class $w]_self_insert $w \\$right_key ; th_Misc_check_exp $w \{$TH(Paren,$exp)\} 1"
    } else {bind $w $right_keysym "th_[winfo class $w]_self_insert $w \\$right_key"
}}}

proc th_Misc_paren_prompt {w args} {
  global TH
  if {[catch "set TH(Paren,List,$w)"]} {th_Misc_paren_reeval $w}
  if {[llength $TH(Paren,List,$w)] == 1} {
    if {[catch "$args [lrange $TH(Paren,List,$w) 0 0]" error]} {th_beep}
  } else {
    set f [th_frame $w]
    label $f.bal -text "Which delimiter?"
    pack $f.bal -side right
    set old_focus [focus]
    focus $f.bal
    bind $f.bal <Any-Key> "th_Misc_paren_prompt_aux $w \{$args\} $old_focus %A"
}}

proc th_Misc_paren_prompt_aux {w cmd focus c} {
  if {(![regexp . $c])} {return}
  destroy "[th_frame $w].bal"
  focus $focus
  global TH
  foreach item $TH(Paren,List,$w) {foreach index {0 1} {
    if {$c == [lindex $item $index]} {
      if {[catch "$cmd \{$item\}" error]} {th_beep}
      return
  }}}
  th_beep ; return
}


proc th_Misc_goto_left_exp {w exp_type} {
  if {[set l [th_[winfo class $w]_left_exp $w insert $exp_type]] == ""} {
    th_beep ; return}
  th_[winfo class $w]_goto $w $l
}

proc th_Misc_goto_right_exp {w exp_type} {
  if {[set r [th_[winfo class $w]_right_exp $w insert $exp_type]] == ""} {
    th_beep ; return}
  th_[winfo class $w]_goto $w $r
}

proc th_Misc_select_exp {w exp_type} {
  if {[set l [th_[winfo class $w]_left_exp_out $w insert $exp_type]] == ""} {
    th_beep ; return}
  if {[set r [th_[winfo class $w]_right_exp_out $w insert $exp_type]] == ""} {
    th_beep ; return}
  th_[winfo class $w]_select_range $w $l $r
}

proc th_Misc_delete_left_exp {w exp_type} {
  if {[set l [th_[winfo class $w]_left_exp $w insert $exp_type]] == ""} {
    th_beep ; return}
  th_[winfo class $w]_delete_range $w $l insert
}

proc th_Misc_delete_right_exp {w exp_type} {
  if {[set r [th_[winfo class $w]_right_exp $w insert $exp_type]] == ""} {
    th_beep ; return}
  th_[winfo class $w]_delete_range $w insert $r
}

proc th_Misc_kill_exp {w exp_type} {
  if {[set l [th_[winfo class $w]_left_exp_out $w insert $exp_type]] == ""} {
    th_beep ; return}
  if {[set r [th_[winfo class $w]_right_exp_out $w insert $exp_type]] == ""} {
    th_beep ; return}
  th_[winfo class $w]_kill_range $w $l $r
}


proc th_Misc_check_exp {w exp_type {insert_flag 0}} {
  global TH
  if {[catch "set TH(Paren,List,$w)"]} {th_Misc_paren_reeval $w}
  set left [lindex $exp_type 0] ; set right [lindex $exp_type 1]
  set result [th_[winfo class $w]_left_exp $w insert $exp_type $insert_flag]
  set msg [th_[winfo class $w]_report_exp $w $result]
  if {($result == "")} {
    set msg "No [string trimleft $left \\] found!!!" ; th_beep
  } else {
    foreach exp $TH(Paren,List,$w) {if {($left != [lindex $exp 0])} {
      set char [th_Misc_balance_count $w [lindex $exp 0] \
        [lindex $exp 1] $result insert]
      if {($char != "")} {set msg "Excess $char" ; th_beep ; break
  }}}}
  if {([string length $msg] < $TH(Paren,Length))} {
    set width [string length $msg]} else {set width $TH(Paren,Length)}
  if $TH(Paren,Show,[winfo class $w]) {
    th_flash_label $w -text $msg -relief raised -width $width -anchor e
}}

# Checks if $left and $right occur the same # of times in [$start $end] of $w
proc th_Misc_balance_count {w left right start end} {
  set class [winfo class $w]
  set c1 [th_[set class]_char_count $w $left $start $end]
  set c2 [th_[set class]_char_count $w $right $start $end]
  if {($c1 > $c2)} {return "[string trimleft $left \\] [expr $c1-$c2]"}
  if {($c2 > $c1)} {return "[string trimleft $right \\] [expr $c2-$c1]"}
  return ""
}


