#
# Module for balancing parens in Entry widgets
#


# Returns index of closesst previous lone left partner, or "" if unsuccessful.
proc th_Entry_left_exp {w index exp_type {out_flag 0}} {
  set left [lindex $exp_type 0]
  set right [lindex $exp_type 1]
  set close_trace [$w index $index]
  if $out_flag {incr close_trace -1}
  set open_trace $close_trace
  while (1) {
    if {[set open_trace [string last $left [string range [$w get] \
	0 [expr $open_trace - 1]]]] == -1} {return ""}
    if {[set close_trace [string last $right [string range [$w get] \
	$open_trace [expr $close_trace - 1]]]] == -1} {return [expr $open_trace +1]}
    incr close_trace $open_trace
}}

# Returns index of closest next lone right partner, or "" if unsuccessful.
proc th_Entry_right_exp {w index exp_type} {
  set left [lindex $exp_type 0]
  set right [lindex $exp_type 1]
  set close_trace [expr [$w index $index] -1]
  set open_trace $close_trace
  while {1} {
    if {[set tmp [string first $right [string range [$w get] \
	[expr $close_trace +1] end]]] == -1} {return ""}
    set close_trace [expr $tmp + $close_trace + 1]
    if {[set tmp [string first $left [string range [$w get] \
        [expr $open_trace +1] $close_trace]]] == -1} {
      return $close_trace}
    set open_trace [expr $open_trace + $tmp + 1]
}}

proc th_Entry_left_exp_out {w index exp_type} {
  set new [th_Entry_left_exp $w $index $exp_type]
  if {$new == ""} {return} else {return [expr $new -1]}
}

proc th_Entry_right_exp_out {w index exp_type} {
  set new [th_Entry_right_exp $w $index $exp_type]
  if {$new == ""} {return} else {return [expr $new +1]}
}


# Returns a message for match being found (of exp_type). Match may be empty;
# in which case nothing is returned.
proc th_Entry_report_exp {w match} {
  global TH
  if {$TH(Paren,Select,Entry) == "sel"} {$w select clear}
  if {($match == "")} {return ""}
  incr match -1

  if {$TH(Paren,Select,Entry) == "sel"} {
    $w select from $match
    $w select to $match

# Not used, this just forces the frame module to autoload so we can have
# TH(Label,Flash).
    set f [th_frame $w]
    after $TH(Label,Flash) $w select clear
  }
  return [string range [$w get] 0 $match]
}

# Counts instances of $c between $start and $end in $w
proc th_Entry_char_count {w c start end} {
  set s [$w index $start] ; set e [$w index $end]
  set offset 0 ; set count 0
  set c [string trimleft $c \\]
  while {([set trace [string first $c [string range [$w get] $s $e]]] \
	!= -1)} {
    incr trace $s
    incr count
    set s [expr $trace +1]
  }
  return $count
}


