#
# Operations for paragraph manipulation in Text widgets.
#

# Returns the beginning of the current paragraph
proc th_para_begin {w index} {
  scan [$w index $index] "%d.%d" i dummy
  for {incr i -1} {$i > 0} {incr i -1} {
    if {([$w get "$i.0"] == "\n") && ([$w get "$i.0 +1 char"] != "\n")} {
      incr i
      return "$i.0"
  }}
  if {[$w get 1.0] != "\n"} {return 1.0} else {return ""}
}

# Returns the end of the current paragraph
proc th_para_end {w index} {
  scan [$w index $index] "%d.%d" i dummy
  scan [$w index end] "%d.%d" e dummy
  for {incr i} {$i < $e} {incr i} {
    if {([$w get "$i.0"] == "\n")} {return "$i.0 -1c"}}
  if {[$w get "$e.0"] == "\n"} {return "$e.0 -1c"} else {return end}
}

# Returns the beginning of the next paragraph
proc th_para_next {w index} {
  scan [$w index $index] "%d.%d" i dummy
  scan [$w index end] "%d.%d" e dummy
  for {} {$i < $e} {incr i} {
    if {([$w get "$i.0"] == "\n") &&
      ([$w get "$i.0 +1c"] != "\n")} {return "$i.0 +1c"}}
  return ""
}

# Returns the beginning of the previous paragraph, or the beginning of this one.
proc th_para_prev {w index} {
  if {[$w compare [set begin [th_para_begin $w $index]] != $index]} {
    return $begin 
  } else {return [th_para_begin $w "$index -1c"]
}}

proc th_para_select {w} {
  set s [th_para_begin $w insert] ; set e [th_para_end $w insert]
  if {($s == "") || ($e == "")} {th_beep ; return}
  th_Text_select_range $w $s $e
  th_Text_add_tag_range $w paragraph $s $e
}


# Adjusts range of text to fit in length columns, so that no lines wrap
# If unspecified, length defaults to window width.
proc th_para_format {w start end {length ""}} {
  set s [$w index $start] ; set e [$w index $end]
  if {($length == "")} {set length [lindex [$w configure -width] 4]}
  set chars [$w get $s $e]
  set m1 [th_gensym] ; set m2 [th_gensym]
  $w mark set $m1 $s ; $w mark set $m2 $e
  th_Text_register_undoable_cmd $w [list th_Text_undo_filter $w $m1 $m2 \
		 $chars] "Adjust $chars" "$m1 $m2"
  th_Text_format $w $start $end $length
  th_Text_add_tag_range $w paragraph $start $end
}

proc th_Text_indent_add_para {w} {
  set prefix ["[th_frame $w].indent.e" get]
  th_hide_entry $w indent

  if {([catch {$w index sel.first}])} {th_beep ; return}
  if {($prefix == "")} {th_beep ; return}
  set mark1 [$w index sel.first]
  set mark2 [$w index sel.last]

  set chars [$w get sel.first sel.last]
  set m1 [th_gensym] ; set m2 [th_gensym]
  th_Text_register_undoable_cmd $w [list th_Text_undo_filter $w $m1 $m2 $chars] "Indent $chars" "$m1 $m2"

  th_Text_format $w sel.first sel.last [expr [lindex [$w configure -width] 4] - [string length $prefix]]
  th_Text_add_prefix $w sel.first sel.last $prefix
  $w mark set $m1 "sel.first linestart"; $w mark set $m2 sel.last
  $w tag remove sel 1.0 end
  $w tag add sel $m1 $m2
  th_Text_add_tag_range $w paragraph $m1 $m2
}

proc th_Text_indent_delete_para {w} {
  set prefix ["[th_frame $w].indent.e" get]
  th_hide_entry $w indent

  if {([catch {$w index sel.first}])} {th_beep ; return}
  if {($prefix == "")} {th_beep ; return}
  set mark1 [$w index sel.first]
  set mark2 [$w index sel.last]

  set chars [$w get sel.first sel.last]
  set m1 [th_gensym] ; set m2 [th_gensym]
  th_Text_register_undoable_cmd $w [list th_Text_undo_filter $w $m1 $m2 $chars] "Indent $chars" "$m1 $m2"
  th_Text_delete_prefix $w sel.first sel.last $prefix
  th_para_format $w sel.first sel.last
  $w mark set $m1 "sel.first linestart"; $w mark set $m2 sel.last
  $w tag remove sel 1.0 end
  $w tag add sel $m1 $m2
  th_Text_add_tag_range $w paragraph $m1 $m2
}


