#
# This file contains general stuff used by the text, C, Tcl, and Lisp modules
#


# graces each region (with fns given here) with a tag so it can be indexed.
proc th_Text_tag_regions {w tag begin_fn end_fn next_fn} {
  $w tag remove $tag 1.0 end
  if {[$begin_fn $w 1.0] != ""} {
    set start 1.0
  } else {
    set start [$next_fn $w 1.0]
  }
  while {$start != ""} {
    if {[set end [$end_fn $w $start]] != ""} {
      $w tag add $tag $start $end
    }
    set start [$next_fn $w $start]
}}

proc th_Text_add_tag_range {w tag start end} {
  if {($start == "") || ($end == "")} {return}
  $w tag remove $tag "$start -1c" "$end +1c"
  $w tag add $tag $start $end
}


# Splits line if it is longer than length. Returns number of extra lines
# produced (0 is if line was not broken). Index is on line to break, length
# is desired length, string is contents of line.
# Returns the number of breaks added.
proc th_Text_split {w {index insert} {length ""} {string ""}} {
  if {($string == "")} {
    set string [$w get "$index linestart" "$index lineend"]
  }
  if {($length == "")} {set length [lindex [$w configure -width] 4]}
  if {([string length $string] < $length)} {return 0}

  set offset [string last " " [string range $string 0 $length]]
  if {($offset < 0)} {return 0}
  set break [$w index "$index linestart +$offset chars"]
  $w delete $break
  $w insert $break \n
  set breaks [th_Text_split $w "$break +1 chars" $length]
  return [incr breaks]
}

# Adjusts range of text to fit in length columns, so that no lines wrap
# If unspecified, length defaults to window width.
proc th_Text_format {w start end {length ""}} {
  set s [$w index $start] ; set e [$w index $end]
  if {($length == "")} {set length [lindex [$w configure -width] 4]}
  set chars [$w get $s $e]

  set trace $s ; $w mark set endtrace $e
  while {([set offset [string first \n [$w get $trace endtrace]]] >= 0)} {
    set trace [$w index "$trace +$offset chars"]
    $w delete $trace ;  $w insert $trace " "
  }
  $w mark unset endtrace
  th_Text_split $w $s $length
}


# Tags region before cursor, if it really is a well-defined region.
proc th_Text_check_add_tag_range {w tag begin_fn end_fn} {
  if {[set begin [$begin_fn $w "insert -2c"]] == ""} {return}
  if {[set end [$end_fn $w $begin]] == ""} {return}
  if {[$w compare $end == "insert -1c"]} {
    th_Text_add_tag_range $w $tag $begin $end
}}

# Tags region before cursor, if it really is a well-defined region.
proc th_Text_balance_add_tag_range {w tag begin_fn exp_list} {
  if {[set begin [$begin_fn $w "insert -2c"]] == ""} {return}

  if {[th_Text_char_count $w [lindex $exp_list 0] $begin insert] !=
	[th_Text_char_count $w [lindex $exp_list 1] $begin insert]} {return}
  th_Text_add_tag_range $w $tag $begin "insert -1c"
}


