#
# Module for managing grids in Listbox widgets
#

# Called by a Listbox widget to tell w what to view
proc th_Listbox_xview {w dummy1 dummy2 y dummy4} {$w view $y}

# Turns on or off the horizontal grid on w
# Args are packing info for the grid.
proc th_Listbox_toggle_grid_x {w args} {
  set g $w ; append g "gridx"
  global TH
  if {[winfo exists $g]} {
# turn grid off
    set TH(Grid_X,$w) 0

# Reset w's xscrollcommand to its scrollbar or nothing if it didn't have one.
    if {[scan [lindex [$g configure -scrollcommand] 4] "%s set" sc] >= 0} {
      $w configure -xscrollcommand "$sc set"
    } else {$w configure -xscrollcommand {}}
    destroy $g
  } else {
    set TH(Grid_X,$w) 1
# turn grid on
    scan [lindex [$w configure -geometry] 4] "%dx%d" width height
    entry $g -relief ridge -font [lindex [$w configure -font] 4] \
      -width $width -borderwidth 2
    eval pack $g -before $w -fill x $args

# Disable scanning on g.
    foreach binding {<2> <B2-Motion>} { bind $g $binding {info tclversion} }

# Fill g with column numbers
    set s [$w size]
    for {set c 0} {$c < $s} {incr c} {
      set l [string length [$w get $c]]
      if {$l > $width} {set width $l}
    }
    incr width -1
    $g delete 0 end
    for {set column 0} {$column <= $width} {incr column} {
      set char [string index $column [expr [string length $column] - 1]]
      if {$char == 0} {$g insert end "_"
      } else {$g insert end $char}}
    $g configure -state disabled

# Tie w's xscrollcommand over to g.
    $w xview 0 ; $g view 0
# Listboxes won't tell you how far along the x line they're scrolled.
    if {[scan [lindex [$w configure -xscrollcommand] 4] "%s set" sc] >= 0} {
# Give g the responsibility of moving w's scrollbar.
      $g configure -scrollcommand "$sc set"
    }
    $w configure -xscrollcommand "th_Listbox_xview $g"
}}


# Called by a Listbox widget to tell w what to view
proc th_Listbox_yview {w dummy1 dummy2 y dummy4} {$w yview $y}

# Turns on or off the horizontal grid on w
# Args are packing info for the grid.
proc th_Listbox_toggle_grid_y {w width args} {
  set g $w ; append g "gridy"
  global TH
  if {[winfo exists $g]} {
# turn grid off
    set TH(Grid_Y,$w) 0

# Reset w's yscrollcommand to its scrollbar or nothing if it didn't have one.
    if {[scan [lindex [$g configure -yscrollcommand] 4] "%s set" sc] >= 0} {
      $w configure -yscrollcommand "$sc set"
    } else {$w configure -yscrollcommand {}}
    destroy $g
  } else {
    set TH(Grid_Y,$w) 1
# turn grid on
    scan [lindex [$w configure -geometry] 4] "%dx%d" dummy height
    set geom $width ; append geom "x$height"
    listbox $g -relief ridge -font [lindex [$w configure -font] 4] \
      -geometry $geom -borderwidth 2
    eval pack $g -before $w -side left $args

# Disable scanning on g.
    foreach binding {<2> <B2-Motion>} { bind $g $binding {info tclversion} }

# Fill g with column numbers
    set lines [$w size]
    for {set line 0} {$line < $lines} {incr line} {
      $g insert end $line}

# Tie w's yscrollcommand over to g.
    $g yview [$w nearest 0]
    if {[scan [lindex [$w configure -yscrollcommand] 4] "%s set" sc] >= 0} {
# Give g the responsibility of moving w's scrollbar.
      $g configure -yscrollcommand "$sc set"
    }
    $w configure -yscrollcommand "th_Listbox_yview $g"
}}
