#
# Code for focus hypertool
#

# Searches the window hierarchy for a widget of appropriate class that
# follows w. If class is unspecified, it becomes w's class.
proc th_next_widget {{w "."} {class ""}} {
  if {$class == ""} {set class [winfo class $w]
  } elseif {[winfo class $w] == $class} {
# Widget must be packed and not sidabled.
    if {([catch "$w configure -state" result] || \
        ([lindex $result 4] != "disabled")) && [winfo ismapped $w]} {
           return $w}}

  set children [winfo children $w]
  if {$children != ""} { return [th_next_widget [lindex $children 0] $class]}

  while {$w != "."} {
    set parent [winfo parent $w]
    set children [winfo children $parent]
    set i [lsearch $children $w] ; incr i
    set l [llength $children]
    while {$i != $l} {
      set child [lindex $children $i]
      if {([winfo class $child] == "Toplevel") ||
          ([lsearch [pack slaves $parent] $child] >= 0)} {
        return [th_next_widget [lindex $children $i] $class]
      }
      incr i
    }
    set w $parent
  }
  return
}

# Searches the window hierarchy for a widget of appropriate class that
# precedes w. If class is unspecified, it becomes w's class.
proc th_previous_widget {{w "."} {class ""}} {
 if {$class == ""} {set class [winfo class $w]
  } elseif {[winfo class $w] == $class} {
# Widget must be packed and not sidabled.
    if {([catch "$w configure -state" result] || \
        ([lindex $result 4] != "disabled")) && [winfo ismapped $w]} {
           return $w}}

  set children [winfo children $w]
  if {$children != ""} { return [th_previous_widget [lindex $children \
                                   [expr [llength $children] - 1]] $class]}

  while {$w != "."} {
    set parent [winfo parent $w]
    set children [winfo children $parent]
    set i [lsearch $children $w] ; incr i -1
    while {$i != -1} {
      set child [lindex $children $i]
      if {([winfo class $child] == "Toplevel") ||
          ([lsearch [pack slaves $parent] $child] >= 0)} {
        return [th_previous_widget [lindex $children $i] $class]
      }
      incr i -1
    }
    set w $parent
  }
  return
}

