#
# Module for file browsing
#


# Some useful variables:
set TH(File,Browse,Shortcommand) [lindex [string trim $TH(File,Browse,Command) "| "] 0]
set TH(File,Browse,Dir) ""
set TH(File,Browse,Listing) ""
set TH(File,Browse,Length) 0
set TH(File,Browse,Index) 0

# Finds instance of file in w (which contains directory listing)
proc th_file_find {w file} {
  set index 1.0
  while {[set index [th_Text_string_first $w $file "$index+1c"]] != ""} {
    if {[th_file_parse [$w get "$index linestart" "$index lineend"]] == $file} {
      return $index
}}}

# Attempts to parse the filename from a line of text (usually output of ls
# with some switches.
proc th_file_parse {string} {
  set list [split $string]
  set l [llength $list]
  if {[lindex $list [expr $l - 2]] == "->"} {
# File is a symlink.
    set namex [lindex $list [expr $l - 3]]
  } else {set namex [lindex $list [expr $l - 1]]}

# Might file have a char at the end (generated by ls -F)?
  if {[file exists $namex]} {set name [string trimright $namex "/"]
  } else {set name [string range $namex 0 [expr [string length $namex] -2]]}

  return $name  
}

proc th_file_raise {w} {
  global TH ; if {[catch "set TH(File,$w)"]} {set TH(File,$w) "[pwd]/a"}
  set dir [file dirname $TH(File,$w)]
  if {[string match "*/$TH(File,Browse,Command)" $TH(File,$w)]} {
    set dir [file dirname $dir]
    set oldfile [file tail [file dirname $TH(File,$w)]]
  } else {set oldfile [file tail $TH(File,$w)]}
  set TH(File,$w) "$dir/$TH(File,Browse,Command)"
  return $oldfile
}

proc th_file_up {w} {
  set oldfile [th_file_raise $w]
  th_load_file $w
  th_Text_goto $w [th_file_find $w $oldfile]
}

proc th_file_down {w} {
  global TH ; if {[catch "set TH(File,$w)"]} {set TH(File,$w) "[pwd]/a"}
  if {![string match "*/$TH(File,Browse,Command)" $TH(File,$w)]} {th_beep ; return}
  set string [$w get "insert linestart" "insert lineend"]
  set file [th_file_parse $string]
  if {![file exists $file] || ![file readable $file]} {th_beep ; return}
  set dir [file dirname $TH(File,$w)]
  if {[file isdirectory $file]} {
    set TH(File,$w) "$dir/$file/$TH(File,Browse,Command)"
  } else {set TH(File,$w) "$dir/$file"}
  th_load_file $w
}

proc th_file_move {w inc} {
  global TH
  set of $TH(File,$w)
  set oldfile [th_file_raise $w]
  set dir [file dirname $TH(File,$w)]
  if {$dir != $TH(File,Browse,Dir)} {
    set TH(File,Browse,Dir) $dir
    set TH(File,Browse,Listing) [exec $TH(File,Browse,Shortcommand) $dir]
    set TH(File,Browse,Length) [llength $TH(File,Browse,Listing)]
    set TH(File,Browse,Index) [lsearch $TH(File,Browse,Listing) $oldfile]
  }
  incr TH(File,Browse,Index) $inc
  if {($TH(File,Browse,Index) < 0) || 
	($TH(File,Browse,Index) >= $TH(File,Browse,Length))} {
    set TH(File,$w) $of
    if {$TH(File,Browse,Index) < 0} {set TH(File,Browse,Index) 0
    } else {set TH(File,Browse,Index) [expr $TH(File,Browse,Length) -1]}
    th_beep ; return}
  set file [lindex $TH(File,Browse,Listing) $TH(File,Browse,Index)]
  if {[file isdirectory $dir/$file]} {
    set TH(File,$w) "$dir/$file/$TH(File,Browse,Command)"
  } else {set TH(File,$w) "$dir/$file"}
  th_load_file $w
}


