#
# Module for file I/O for Text widgets
#

# Writes contents of w out to descriptor f.
proc th_Text_write_file {w f} {
  if {([$w get {end -1 chars}] != "\n")} {$w insert end "\n"}
  puts $f [$w get 1.0 end] nonewline
}

# Changes w to contain contents of file descriptor f.
proc th_Text_read_file {w f {grad 0}} {
  $w delete 1.0 end
  if $grad { th_busy $w th_Text_gradual_read $w $f [$w index insert]
  } else {$w insert 1.0 [read $f]}
  $w mark set insert 1.0
  $w yview 1.0
}

# Inserts contents of f at insert in w.
proc th_Text_insert_file {w f {grad 0}} {
  $w mark set file_start insert
  set i [$w index insert]

  if $grad { th_busy $w th_Text_gradual_read $w $f [$w index insert]
  } else {  $w insert insert [read $f]}

  if {[info procs th_Text_figure_out_undo_insert] != ""} {
    th_Text_figure_out_undo_insert $w [$w get file_start $i]}
  $w mark set insert $i
  $w yview -pickplace insert
  $w mark unset file_start
}


set TH(Busy) 0

proc th_busy {w args} {
  global TH ; set TH(Busy) 1
  set cursor [lindex [$w config -cursor] 4]
  set parent [winfo toplevel $w]
  set title [wm title $parent] ; set iconname [wm iconname $parent]

  # Indicate process is busy
  $w config -cursor watch
  wm iconname $parent "* $iconname" ; wm title $parent "*BUSY* $title"
  update

  set error [catch {uplevel #0 $args} result]

  # Free up program now.
  $w config -cursor $cursor
   wm iconname $parent $iconname ; wm title $parent $title
  update

  set TH(Busy) 0
  if $error {  error $result} else {  return $result
}}

# fills text widget w with contents from "$file", which must be opened for
# reading. Does not clear text widget.
proc th_Text_gradual_read {w file index} {
  # Enable user to interrupt with a Cancel binding.
  global TH;  set TH(Interrupt) 0

  set binding [th_bind $w Cancel]
  th_bind $w Cancel "set TH(Interrupt) 1 ; th_beep"
  $w mark set new_stuff $index
  # Use addinput extension, if possible
  if {[info commands addinput] == ""} {
    th_Text_read_file_graduated $w "$file"
  } else {set TH(Gradual,Done) 0
    addinput "$file" "th_Text_addinput_read $w %F %E"
    tkwait variable TH(Gradual,Done)
  }
  $w mark unset new_stuff
  th_bind $w Cancel $binding
}

# Reads file a line at a time, and updates t per line.
# Since Tk can only handle events immediately after a line is read, this
# causes many problems, besides being a pain if the command is slow.
proc th_Text_read_file_graduated {w file} {
  set v [lindex [$w configure -height] 4] ; incr v -1
  while {![eof "$file"]} {
    $w insert new_stuff [gets "$file"]
    $w insert new_stuff \n
    th_Text_update_display $w
    global TH ; if $TH(Interrupt) break
}}

# The 'better' way to handle background file reading.
proc th_Text_addinput_read {w f events} {
  global TH
  set result [gets $f line]
  if {$TH(Interrupt) || ($result < 0)} { removeinput $f
    set TH(Gradual,Done) 1
    return
  }
  $w insert new_stuff "$line\n"
  th_Text_update_display $w
}

# Updates the display iff it is not getting choked with data.
proc th_Text_update_display {w} {
  after 100 "if {[$w index insert] == \[$w index insert\]} {
      if {[$w compare insert == new_stuff]} {
        $w yview -pickplace insert}
      update idletasks ; update}"
}


