#
# Module for file I/O for Entry widgets
#

# Writes contents of w out to descriptor f.
proc th_Entry_write_file {w f} { puts $f [$w get] }

# Changes w to contain contents of file descriptor f.
proc th_Entry_read_file {w f {grad 0}} {
  $w delete 0 end
  $w insert 0 [read -nonewline $f]
  $w icursor 0
  $w view 0
}

# Inserts contents of f at insert in w.
proc th_Entry_insert_file {w f {grad 0}} {
  set text [read -nonewline $f]
  set i [$w index insert]
  global auto_index
  if {([info procs th_Entry_register_undoable_cmd] != "") \
     ([lsearch [array names auto_index] th_Entry_register_undoable_cmd] >= 0)} {
    th_Entry_register_undoable_cmd $w "Insert $text"}
  $w insert insert $text
  $w icursor $i
  $w view [expr $i - 1]
}


