#
# Operations for error reporting in Text widgets.
#


# Checks to see if index begins a line with a compiler error on it.
proc th_check_error {w index} {
  set list [split [$w get $index "$index lineend"] ":, "]

# The line number is the first number in the string. IF none exist, return "".
  set prelims ""
  set line -1
  foreach item $list {
    if {($item != "") && ([scan $item "%d.%d" line column] != 0)} {
      break
    } else {lappend prelims $item}
  }
  if {$line == -1} {return ""}

# Now prelims contains the stuff before the line#. Last item in prelim is
# either 'line' or the filename. (possibly in quotes).
  set file_no [llength $prelims]  ; incr file_no -1
  while {([string toupper [lindex $prelims $file_no]] == "LINE") ||
    ([lindex $prelims $file_no] == "")} {incr file_no -1}

# Now file_no points to file in prelims. If nonexistant, return ""
  global TH
  set file [file dirname $TH(File,$w)] ; append file "/"
  append file [string trim [lindex $prelims $file_no] {"}]
  if {![file exists $file]} {return ""}
  return [list $file $line]
}

# Returns the beginning of the current error
proc th_error_begin {w index} {
  scan [$w index $index] "%d.%d" i dummy
  for {} {$i > 0} {incr i -1} {
    if {[th_check_error $w "$i.0"] != ""} {
      th_Text_add_tag_range $w error "$i.0" "$i.0 lineend"
      return "$i.0"
}}}

# Returns the end of the current error
proc th_error_end {w index} {
  set begin [th_error_begin $w $index]
  if {$begin == ""} {return ""} else {return "$begin lineend"}
}

# Returns the beginning of the next error
proc th_error_next {w index} {
  scan [$w index $index] "%d.%d" i dummy
  scan [$w index end] "%d.%d" e dummy
  for {incr i} {$i < $e} {incr i} {
    if {[th_check_error $w "$i.0"] != ""} {
      th_Text_add_tag_range $w error "$i.0" "$i.0 lineend"
      return "$i.0"
}}}

# Returns the beginning of the previous error, or the beginning of this one.
proc th_error_prev {w index} {
  if {[$w compare [set begin [th_error_begin $w $index]] != $index]} {
    return $begin 
  } else {return [th_error_begin $w "$index -1c"]
}}

proc th_error_select {w} {
  set s [th_error_begin $w insert] ; set e [th_error_end $w insert]
  if {($s == "") || ($e == "")} {th_beep ; return}
  th_Text_select_range $w $s $e
  th_Text_add_tag_range $w error $s $e
}

proc th_error_visit {w} {
  set b [th_error_next $w insert]
  th_Text_goto $w $b
  set info [th_check_error $w $b]
  set file [lindex $info 0] ; set line [lindex $info 1]
  global auto_index
  if {([info procs elsbeth_goto_file] != "") || \
     ([lsearch [array names auto_index] elsbeth_goto_file] >= 0)} {
    elsbeth_goto_file $w $file
    th_Text_goto [focus] "$line.0"
}}


