#
# Provides functions necessary for elsbeth's functions, but not necessary upon
# startup.
#


# Adding Modules

# User wants to add tool to widget w. If not given, w is the last text window
# opened.
proc elsbeth_add_module {tool {w ""}} {
  if {$w == ""} {
    set list [winfo children .]
    for {set l [llength $list]} {$l >= 0} {incr l -1} {
      if {[string match ".sym*" [lindex $list $l]]} {
        set w "[lindex $list $l].t"
  }}}
  global Optional_Code
  regsub -all %W $Optional_Code($tool) $w code
  uplevel #0 $code
  th_flash_label $w -text "$tool loaded"
}


# Switch-buffer command

# Goes to a new buffer
proc elsbeth_switch_buffer {w} {
  global Els_Titles
  set all_titles ""
  foreach name [array names Els_Titles] {
    lappend all_titles $Els_Titles($name)
  }

  set f [th_show_entry $w buffer]
  $f.l configure -text "Which:"
  global App_Name
  $f.e delete 0 end
  $f.e insert 0 "$App_Name:"
  th_bind $f.e Complete_Word [list th_Entry_complete_multiple %W [list [list \
	th_line_complete [list th_list_completions $all_titles] none]]]
  th_bind $f.e OK "th_hide_entry $w buffer ; elsbeth_switch_aux \"\[$f.e get\]\""
}

proc elsbeth_switch_aux {title} {
  global Els_Titles
  foreach name [array names Els_Titles] {
    if {($title == $Els_Titles($name))} {elsbeth_focus $name ; return
}}}

proc elsbeth_focus {tl} {th_raise_window $tl.t ; update ; focus $tl.t}


# Visit-file command

# Brings up a window on a new file, or revisits an old one.
proc elsbeth_visit_file {w {default ""} {msg "File to Visit:"}} {
  global TH
  if {!([catch "set TH(File,$w)"] || ($TH(File,$w) == ""))} {
    set TH(File,Old,$w) $TH(File,$w)}
  set f [th_file_prompt $w "elsbeth_visit_file_aux $w" $msg]
  $f.e delete insert end
  set i [$f.e index insert]
  $f.e insert insert $default  
  $f.e icursor $i
}

proc elsbeth_visit_file_aux {w} {
  global TH
  set file $TH(File,$w)
  if {![catch "set TH(File,Old,$w)"]} {set TH(File,$w) $TH(File,Old,$w)}
  return [elsbeth_goto_file $w $file]
}

# Returns 1 if a new window was started
proc elsbeth_goto_file {w file} {
  global TH

# See if we're already visiting this file.
  foreach tl [winfo children .] {
    if {[lsearch "Toplevel Frame" [winfo class $tl]] >= 0} {
      if {![catch "set TH(File,$tl.t)" other_file]} {
      if {$other_file == $file} { elsbeth_focus $tl ; return 0
  }}}}

# Oh well, gotta bring up a new window.
  if {[winfo class [winfo parent $w]] == "Toplevel"} {set pile 0
  } else {set pile 1}
  if $TH(Busy) {
    set TH(Busy) 0
    els_process_option $file $pile
    set TH(Busy) 1
  } else {    els_process_option $file $pile }
  set l [llength [winfo children .]] ; incr l -1
  elsbeth_focus [lindex [winfo children .] $l]
  return 1
}

proc elsbeth_help {w} {
  global Elsbeth_Help_File TH
  if {[elsbeth_goto_file $w $Elsbeth_Help_File]} {
    elsbeth_add_module paragrath [focus]
  }
  set wh [focus]
  set Elsbeth_Help_File $TH(File,$wh)
  set index 1.0
  while {[set index [th_Text_string_first $wh "Functions" "$index +1c"]] != ""} {
    $wh tag add header "$index linestart" "$index lineend"
  }
  $wh delete 1.0 3.0
  $wh tag add header "1.0" "1.0 lineend"
  $wh tag configure header -underline 1
}

proc elsbeth_make {w} {
  global Make_Cmd TH
  set f [th_frame $w]
  if {[winfo exists $f.file.e]} {
    set value [$f.file.e get]
    if {[string match "*|*make*" $value]} {
      set Make_Cmd [string range $value [string first "|" $value] end]
  }}
  if {[catch "set Make_Cmd"]} {set Make_Cmd "| make |& cat &"}

  if {!([catch "set TH(File,$w)"] || ($TH(File,$w) == ""))} {
    set TH(File,Old,$w) $TH(File,$w)}
  set fm [th_file_prompt $w "if \{!\[elsbeth_visit_file_aux $w\]\} \{th_read_file \[focus\]\}" "Make command:"]
  $fm.e delete insert end
  set i [$fm.e index insert]
  $fm.e insert insert $Make_Cmd
  $fm.e icursor $i
}


# Moving below last (shown) window

proc elsbeth_move_below_last {w} {
  set tl [winfo parent $w]
  if {[winfo class $tl] == "Frame"} {
    set children [pack slaves .]
    set i [lsearch $children $tl] ; incr i ; set s [lindex $children $i]
    if {$s == ""} {th_beep} else {pack $tl -after $s}
  } else {
    set children [winfo children .]
    set i [lsearch $children $tl] ; incr i -1
    while 1 {
      if {[winfo ismapped [lindex $children $i]]} {
        scan [winfo geometry [lindex $children $i]] {%dx%d+%d+%d} \
  	his_width his_height his_x his_y
        wm geometry $tl "+$his_x\+[expr $his_y + $his_height]"
        return
      }
    incr i -1
    if {$i < 0} {set i [llength $children] ; incr i -1}
    if {[lindex $children $i] == $tl} {return}
}}}


# Focusing in all (shown) windows

proc elsbeth_focus_all {w {i 0}} {
  if $i {set all "All"} else {set all "All Shown"}
  global TH
  set TH(All,Focus) [join [lrange [split [focus] .] 2 end] "."]
  set TH(All,Status) temporary
  set f [th_show_entry $w all]
  pack forget $f.l
  pack $f.e -expand no -fill none
  $f.e delete 0 end
  $f.e insert 0 $all
  $f.e configure -width [string length $all]

  foreach binding [bind $f.e] {bind $f.e $binding ""}
  th_bind $f.e All_Shown "elsbeth_toggle_all $w"
  th_bind $f.e All_Windows "elsbeth_toggle_all $w"
  bind $f.e <Key> "elsbeth_allbinding $w $i %K \"%A\""
  bind $f.e <Control-Key> "elsbeth_allbinding $w $i Control-%K \"%A\""
  bind $f.e <Meta-Key>    "elsbeth_allbinding $w $i Meta-%K \"%A\""
  bind $f.e <Control-Meta-Key>    "elsbeth_allbinding $w $i Control-Meta-%K \"%A\""
}

proc elsbeth_toggle_all {w} {
  global TH
  set f [th_frame $w].all
  if {($TH(All,Status) == "temporary")} {
    set TH(All,Status) "permanent"
    set all [$f.e get]
    $f.e delete 0 end
    $f.e insert 0 "$all Permanent"
    $f.e configure -width [string length "$all Permanent"]
    focus $f.e
  } else {th_hide_entry $w all
}}


# Performs function associated with keybinding in all windows, indluding this
# one (last).  c and events are as in th_return_binding. i if 1 sends to all
# windows, otherwise, just to mapped ones.
proc elsbeth_allbinding {w i b c} {
  if {![regexp . $c]} {return}
  if {$b == ""} {set b $c}
  set e "[th_frame $w].all.e"
  global TH
  if {($TH(All,Status) != "permanent")} {th_hide_entry $w all}

  foreach tl [winfo children .] {
    if {("$tl.t" == $w)} {continue}
    if {![string match ".sym*" $tl]} {continue}
    if {![winfo ismapped $tl] && !$i} {continue}
    th_hide_entry $tl.t all
    if {[catch "focus $tl.$TH(All,Focus)"]} {focus $tl.t}
    if {[set cmd [th_return_binding [focus] $b $c]] != ""} {
      eval $cmd
  }}
  if {[catch "focus [winfo parent $w].$TH(All,Focus)"]} {focus $w}
# Dont execute the keybinding on the all entry, that would make an infinite loop
  if {$TH(All,Focus) == $e} {focus $w}
  if {[set cmd [th_return_binding [focus] $b $c]] != ""} {eval $cmd}

  if {[catch "winfo ismapped $w" result]} {return}
# Window must have been destroyed.
  if {!$result} {th_hide_entry $w all ; return}
# Window still exists, but was unmapped.

# Save focus here, in case it changed.
  set TH(All,Focus) [join [lrange [split [focus] .] 2 end] "."]
  if {($TH(All,Status) == "permanent")} {  focus $e}
}


