#
# Operations for C function/comment manipulation in Text widgets.
#


# Function boundary routines

# Returns 1 if index points to a function's beginning.
proc th_fn_check {w index} {
# First char must be legit in a type definition
  if {![regexp {[A-Z_a-z\*\(\)]} [$w get $index]]} {return 0}

# Last char before newline must be brace or whitespace or / (as in */)
  if {![regexp {[/\{\}\ \t\n]} [$w get "$index -2c"]] &&
    !([$w get "$index -2c"] == "\n")} {return 0}

# Must not be in a comment
  set comstart [th_Text_string_first $w "/*" $index]
  set comend [th_Text_string_first $w "*/" $index]
  if {($comstart == "") && ($comend != "")} {return 0}
  if {($comstart != "") && ($comend != "") &&
    [$w compare $comend < $comstart]} {return 0}

# Must have paren before brace
  set ob "\{"  ; set cb "\}"
  set op "\("  ; set cp "\)"
  set nextparen [th_Text_string_first $w $op $index]
  set nextbrace [th_Text_string_first $w $ob $index]
  if {($nextparen == "") || ($nextbrace == "")} {return 0}
  if {[$w compare $nextparen > $nextbrace]} {return 0}

# May not have semicolon before the first paren
  set nextsemi [th_Text_string_first $w ";" $index]
  if {($nextsemi != "") && [$w compare $nextsemi < $nextparen]} {return 0}

  return 1
}

proc th_fn_begin {w index} {
  scan [$w index $index] "%dx%d" i dummy
  while {$i != 1} {
    if {[th_fn_check $w "$i.0"]} {  return "$i.0"  }
    incr i -1
  }
  return ""
}

proc th_fn_end {w index} {
  if {[set begin [th_fn_begin $w $index]] == ""} {return ""}
  set ob "\{"  ; set cb "\}"
  set body_start [th_Text_string_first $w $ob $begin]
  if {[set e [th_Text_right_exp $w "$body_start +1 chars" [list $ob $cb]]] == ""} {return ""}
  set end "$e +1c"
  th_Text_add_tag_range $w function $begin $end
  return $end
}

proc th_fn_next {w index} {
  set index "$index linestart +1 lines"
  while {![$w compare $index == end]} {
    if {[th_fn_check $w $index]} {  return $index  }
    set index [$w index "$index +1 lines"]
  }
  return ""
}

proc th_fn_prev {w index} {
  if {[$w compare [set begin [th_fn_begin $w $index]] != $index]} {
    return $begin
  } else {return [th_fn_begin $w "$index -1c"]
}}

proc th_fn_select {w} {
  set s [th_fn_begin $w insert] ; set e [th_fn_end $w insert]
  if {($s == "") || ($e == "")} {th_beep ; return}
  th_Text_select_range $w $s $e
  th_Text_add_tag_range $w function $s $e
}


# Comment boundary routines

proc th_ccomment_begin {w index} {
  set i [th_Text_string_last $w "/*" "$index +2c"]
  return $i
}

proc th_ccomment_end {w index} {
  set i [th_Text_string_first $w "*/" "$index -2c"]
  if {$i == ""} {return ""} else {return "$i +2c"}
}

proc th_ccomment_next {w index} {
  return [th_Text_string_first $w "/*" "$index +1c"]
}

proc th_ccomment_prev {w index} {
  if {[$w compare [set begin [th_ccomment_begin $w $index]] != $index]} {
    return $begin 
  } else {return [th_ccomment_begin $w "$index -1c"]
}}


# Adjusts selected region to fit in length columns, so that no lines wrap
# If unspecified, length defaults to window width.
proc th_ccomment_format {w start end {length ""}} {
  if {$start == ""} {th_beep ; return}
  set s [$w index $start] ; set e [$w index $end]
  if {($length == "")} {set length [lindex [$w configure -width] 4]}
  set chars [$w get $s $e]
  set m1 [th_gensym] ; set m2 [th_gensym]
  $w mark set $m1 $s ; $w mark set $m2 $e
  th_Text_register_undoable_cmd $w [list th_Text_undo_filter $w $m1 $m2 \
		 $chars] "Adjust $chars" "$m1 $m2"
  $w delete "$m2 -2c" $m2
  for {set i [$w index "$s linestart"]} {[$w compare $i < $e]} {set i [$w index "$i +1l"]} {
    while {[string first [$w get $i] "/* "] >= 0} {$w delete $i}}
  th_Text_format $w $m1 $m2 [expr $length - 3]
  th_Text_add_prefix $w "$m1 +1l" $m2 "   "
  $w insert "$m1 linestart" "/* "
  $w mark set $m1 "$m1 linestart"
  if {[string length [$w get "$m2 linestart" $m2]] > [expr $length - 3]} {
    $w insert $m2 "\n*/"} else {$w insert $m2 "*/"}
  th_Text_add_tag_range $w comment $m1 $m2
}


proc th_c_mark {w} {
  th_Text_insert $w "\n"
  if {[$w get "insert -2c"] == "\}"} {
    th_Text_balance_add_tag_range $w function th_fn_begin [list "\{" "\}"]
  } elseif {[$w get "insert -2c"] == "/"} {
    th_Text_check_add_tag_range $w comment th_ccomment_begin th_ccomment_end
}}


