#
# Module for browsing around in Listbox widgets
#

# Where is index of row (starting from 0)
proc th_Listbox_goto {w where} {
  if {[$w nearest 0] == $where} {th_beep ; return 0}
  $w yview $where
  return 1
}

# Selects next unselected line, if selection includes top visible item.
# Otherwise, clears selection and selects top visible item.
proc th_Listbox_select_next_line {w} {
  set cur [$w curselection]
  set index [$w nearest 0]
  if {[lsearch $cur $index] < 0} {
    $w select clear
    $w select from $index
    $w select to $index
  } else {
    set l [llength $cur] ; incr l -1; set item [lindex $cur $l] ; incr item
    $w select adjust $item
}}

proc th_Listbox_select_range {w start end} { 
  $w select from $start ; $w select to $end
}

# Selects all items between top visible item and mark.
proc th_Listbox_select_region {w} {
  global TH
  if {[catch "set TH(Mark,$w)"]} {th_beep ; return}
  if {[$w nearest 0] > $TH(Mark,$w)} {
    th_Listbox_select_range $w $TH(Mark,$w) [expr [$w nearest 0] -1]
  } else {th_Listbox_select_range $w [$w nearest 0] [expr $TH(Mark,$w) -1]
}}

# Exchanges mark with top visible item.
proc th_Listbox_exchange_mark {w} {
  global TH
  if {[catch "set TH(Mark,$w)"]} {th_beep ; return}
  set i [$w nearest 0]
  $w yview $TH(Mark,$w)
  set TH(Mark,$w) $i
}


