# Basic routimes for Teacher Hypertools

set TH_Copyright {Teacher Hypertools: Copyright (c) 1994  David Svoboda}


# Returns value of variable, looking up env_var as an environment variable,
# using default if var and env(env_var) don't exist.
proc setenv {var env_var {default ""}} {
  if {[info globals $var] == ""} {
    global $var env
    if {[catch {set $var $env($env_var)}]} {
      set $var $default
  }}
  return $var
}

proc source_local_files {} {
  global env
  set name [lindex [wm title .] 0]
  if {[file exists $env(HOME)/.th/$name]} {
    source $env(HOME)/.th/$name
  }
  if {[file exists ".$name"]} {
    source ".$name"
}}

# The location of TH's library. (You could instead set your TH_DIR
# environment variable)
setenv TH_Dir TH_DIR "[file dirname [info script]]/.."

source_local_files

# The location of XF (for some of its template procedures)
setenv XF_Dir XF_DIR "/afs/ece/usr/tcl/xf2.3"

# Which set of bindings to use?
setenv TH_Bindings_Set TH_BINDINGS "th"

if {[info procs update_arguments] == ""} {source $TH_Dir/aux/teach_widgets.tcl}


# Help text.
set TH_Help "" ; append TH_Help {
Source Menu

This menu simply provides three ways to transmit code to remote programs; unless
you are interested in somehow adding said code to the program, you need not
worry about this menu. On some hypertools, which don't teach code (such as
configureth), this menu may not exist. It has three options:

  Include file

This merely teaches the program the code necessary to do this hypertool's
functions; it teaches the program nothing about where this code came from. This
is the default.

  Source Command

Instead of giving the remote program the co  de, give the prgram the necessary
'source' commands needed to load the code itself.

  Add to auto_path

Instead of giving the remote program some files to load or some code, add the
directory of the code to the program's auto_path variable. This will
automatically load the procedures the program needs whenever it invokes them.


Misc Menu

  Help

Wlll, you're seeing what it does. :) The menubutton was created using taggeth;
it is useful for going to any header in the help file. Or you can go to the
selected text, if any is selected. Hit the OK button above this widget to exit
Help.

  Quit

Quits the program. Can be used anytime, even while you are teaching things to
other widgets.


The output Text

This space is filled with either:
1. Error message from invalid command.
2. Informative output from query-type command, like "pack info"
3. Complete command executed if successful. (This is the command that was
   executed in the remote interpreter.)


Configuration Files

Before starting up, this program calls the local file of the same name as this
program itself, preceded by a '.', if this file exists. (In other words, if this
program were called 'foo', it would source '.foo'.) It then looks for a file in
$HOME/.th by the same name as the program. (So in our aforementioned example, it
would search for $HOME/.th/foo). This way you can customize any aspect of these
programs you so choose.


Command-line Arguments

This hypertool fills its widgets with the command-line arguments, generally in
order of top-to-bottom, and left-to-right. So if the top widget is an entry, the
first argument to the program will override the default value for that entry.
Generally entries accept strings for arguments, scales prefer numbers, and
checkbuttons prefer values of 1 (for on) and 0 (for off).


} $TH_Copyright {

Permission to use, copy, modify, and distribute this software is hereby granted,
provided that the above copyright line appears at least once in source code
taught by Teacher Hypertools, and in documentation relating to said code.
However, permission is not granted to modify the copyright insertion code.

This basically means: if a Teacher Hypertool sticks a copyright message in code
it teaches, and you copy that code to a file, leave the copyright message in.
And include it in your documentation. If it doesn't stick a copyright in code,
don't worry about it. Go ahead and fiddle around with the Teacher Hypertool
source code, and improve it (and drop me a line if you do, I'd be interested),
but don't change the code that inserts copyright notices.


Disclaimer

I don't see how its possible, but if this software crashes your system, destroys
your hard disk, posts to alt.flame asking for mail-bombs, etc. etc, I didn't do
it, man. :)


Author

David Svoboda
(svoboda@ece.cmu.edu)
}


# Given x and y (mouse coordinates), fills the global variables App and Widget
# with the application and widget with those absolute coordinates.
# Class also gets the widget's class.
# If illegetimate button was pressed, erases App and Widget.
proc which_widget {x y} {
  global App Widget Class X Y
  set Widget ""
  foreach App [winfo interps] {
    if {[catch {send $App winfo containing $x $y} Widget]} {continue}
    if {($Widget != "") && [send $App winfo ismapped $Widget]} { break }
    set Widget ""
  }
  if {($Widget == "") || ($App == "") || ([string index $Widget 0] != ".")} {
    set App "" ; set Widget "" ; set Class ""
    return 0
  } else {
    set Class [send $App winfo class $Widget]
    set X $x ; set Y $y
    return 1
}}

# Gets user to press the button in a remote widget, then calls what_widget
# on his mouse coordinates.
proc get_widget {} {
  global Getting_Widget ; set Getting_Widget 1
  grab -global .
  . config -cursor cross
  bind all <Any-Button> "which_widget %X %Y ; set Getting_Widget 0"
  tkwait variable Getting_Widget
  grab release .
  . config -cursor ""
  bind all <Any-Button> ""
  global Widget ; if {$Widget == ""} {return 0} else {return 1}
}

# Execute cmd in application, puts output or error in Output text widget. If no
# output, puts cmd in Output.
proc do_cmd {cmd {clear_text 1}} {
  global Output App
  if {![catch {send $App $cmd} Output]} {
    if {($Output == "") || ([lindex $cmd 0] == "set")} {
      set Output $cmd
  }}
  show_output $clear_text
}

proc show_output {{clear_text 1}} {
   global Output
  .output configure -state normal
  if $clear_text {.output delete 1.0 end}
  .output insert end $Output
  .output configure -state disabled
}

proc clear_output {} {
  .output configure -state normal
  .output delete 1.0 end
  .output configure -state disabled
}  

# Returns the contents of file
proc return_source {file} {
  set f [open $file "r"]
  set result [read $f]
  close $f
  return $result
}

# Returns code app needs to know, code is the contents of file.
# If proc is nonempty, and app knows proc, it is assumed app knows code.
proc code_to_teach_app {file {proc ""}} {
  global TH_Dir App
  if {$proc != ""} {
    if {[send $App info proc $proc] != ""} {return ""}}
  if {[send $App lsearch \$auto_path "/*th/lib"] >= 0} {return ""}

  global TH_Copyright
  set result ""
  if {[catch {send $App set TH(Copyright)}]} {
    set result "set TH(Copyright) \{$TH_Copyright\}\n"
  }

  global Source_Type
  switch $Source_Type {
    "Include" {return [append result [return_source $file]]
    } "Source" {return "source $file\n"
    } "Autopath" {return "set auto_path \"$TH_Dir/lib \$auto_path\"\n"
}}}

# Teaches app these files of Tcl code (or whichever files app doesn't know)
proc include_files {args} {
  global TH_Dir
  foreach arg $args {
    do_cmd [code_to_teach_app "$TH_Dir/lib/[lindex $arg 0]" [lindex $arg 1]] 0
}}

proc get_th_fullpath {} {
  global TH_Dir
  set pwd [pwd]
  cd $TH_Dir
  set TH_Dir [pwd]
  cd $pwd
  return
}

# Set up main window.
wm minsize . 1 1
set iconname [lindex [wm title .] 0]
get_th_fullpath
set title [string toupper [string index $iconname 0]]
append title [string range $iconname 1 end]
wm title . $title
wm iconname . $iconname
set auto_path "$TH_Dir/lib $auto_path"

if {![catch "frame .buttons"]} {
  pack .buttons -side top -in . -fill x -expand no
  menubutton .buttons.teach -text "Teach" -menu .buttons.teach.m
  menu .buttons.teach.m
  pack .buttons.teach -side left
  menubutton .buttons.misc -text "Misc" -menu .buttons.misc.m
  pack .buttons.misc -side left
  menu .buttons.misc.m
  .buttons.misc.m add command -label "Help" -command show_help
  .buttons.misc.m add command -label "Quit" -command exit
  text .output -state disabled -height 3 -width 40 -wrap char
  pack .output -side top -expand yes -fill both
}

if {![catch "menubutton .buttons.source"]} {
  .buttons.source configure -menu .buttons.source.m -text "Source"
  menu .buttons.source.m
  pack .buttons.source -side left -after .buttons.teach
  set Source_Type "Include"
  .buttons.source.m add radiobutton -label "Include file" \
    -variable Source_Type -value Include
  .buttons.source.m add radiobutton -label "Source Command" \
    -variable Source_Type -value Source
  .buttons.source.m add radiobutton -label "Add to auto_path" \
    -variable Source_Type -value Autopath
  tk_menuBar .buttons .buttons.teach .buttons.misc .buttons.source
}


