#
# Code to generate the frame used to hold entries, messages, etc.
#

set TH_Change_Help {
  Frame

This option allows you to state where the new frame gets placed when you enter
some operation that requires a frame for a widget. After selecting this option,
click anywhere in a remote application, and the frame (or toplevel) widget
containing the one you clicked in will be shown in the "Default Frame" entry.
From then on, any widgets that get taught operations requiring frames will place
them in that widget, no matter which hypertool teaches them.

Alternatively you can click outside any Tk application, in which case the
"Default Frame" entry will turn blank. In this case, a frame will be created
below any taught widget and it will hold all auxiliary widgets for that widget.
}

source "[file dirname [info script]]/../aux/teach_bind.tcl"

if {[info globals Frame_Loaded] == ""} {
set Frame_Loaded 1


# Help text.
set TH_Frame_Help $TH_Teach_Bind_Help ; append TH_Frame_Help {
The frame for entries and messages doesn't become visible until it is needed.
This program tries to pack it right underneath the widget it applies to. You can
move it somewhere else using packeth. One frame gets created for every toplevel
window; if a widget has commands that require a frame (such as Goto Index), and
a frame doesn't exist for that widget (such as if class bindings were applied to
that widget's class), the last frame created in the widget's window will be
used. So if you choose to teach all Text widgets, the Text widget you click on
will get the frame underneath it, and all Text widgets will use that frame,
unless you manually give each of them their own.
}

proc teach_binding_code {binding} {
  global All_Bindings App
  if {[catch "send \{$App\} set TH(Binding,$binding)"]} {
    do_cmd "set TH(Binding,$binding) \{[lindex $All_Bindings($binding) 0]\}\n" 0
}}

# Gives app all the code necessary to create a frame.
proc teach_frame_code {} {
  global App Widget Aux_Frame_App Aux_Frame Widget
  include_files {common.tcl th_beep} {frame.tcl th_show_entry}
  foreach binding {OK Cancel} {teach_binding_code $binding}

  if {![catch {send $App set TH(Frame,$Widget)} result]} {return $result}
  if {($Aux_Frame_App == $App) && ($Aux_Frame != "")} {
    do_cmd "set TH(Frame,$Widget) $Aux_Frame\n" ; return $Aux_Frame}

  set f $Widget ; append f "_fm"
  if {![send $App winfo exists $f]} {
    do_cmd "frame $f\npack $f -fill x [pack_side_parms $Widget bottom "send \{$App\}"]\n" 0
  }
  return $f
}

# For a widget, returns the appropriate bindings. (Calls widget_frame_bindings
# and adds keys to manipulate the entries.)
proc widget_frame_bindings {bindings} {
  return [lappend bindings [list Cancel th_beep]]
}

proc get_frame_widget {} {
  get_widget
  global Widget Class App Aux_Frame Aux_Frame_App
  set Aux_Frame_App $App
  if {($Class != "Frame") && ($Class != "Toplevel")} {
    set Aux_Frame [send $App winfo parent $Widget]
  } else {set Aux_Frame $Widget
}}

if {![catch {label .aux.fl -text "Default Frame:" ; pack .aux.fl -side left}]} {
  entry .aux.fe -state disabled -textvariable Aux_Frame -width 5
  pack .aux.fe -side left -fill x -expand yes
  set Aux_Frame "" ; set Aux_Frame_App "" ; set App ""
  .buttons.change.m add command -label "Frame" -command {get_frame_widget}
}
}


