#
# Bindings for Errorth
#


set Bindings(Error) {
  {Begin_Error 		{th_Text_goto %W [th_error_begin %W insert]}}
  {End_Error		{th_Text_goto %W [th_error_end %W insert]}}
  {Next_Error		{th_Text_goto %W [th_error_next %W insert]}}
  {Prev_Error		{th_Text_goto %W [th_error_prev %W insert]}}
  {Select_Error		{th_error_select %W}}
  {Update_Error		{th_Text_tag_regions %W error th_error_begin th_error_end th_error_next}}
  {Visit_Error 		{th_error_visit %W}}
}


# th_bind.tcl needs this to set up the Function menu and Key label.
set Local_Bindings {Begin_Error End_Error Next_Error Prev_Error Select_Error
  Update_Error Visit_Error}



set TH_Bindings_Help {
Error Functions

This module is useful for checking the output of Makefiles for warnings and
errors in C programs. This module introduces the concept of errors, in the
following manners: One can traverse between errors with Control-N and Control-P.
Control-N puts the cursor at the beginning of the next error, and Control-P puts
the cursor at the beginning of the previous error (or current one if it is not
already there). One can select the current error with Control-J. And Control-A
moves to the beginning of the current error, while Control-E goes to the end.

				Control-
				   P
Error:		Traversal:	 A + E
				   N
		Select:		   J

Errorth also works with taggeth to provide an index of errors. If taggeth is
included, it adds a menu option called "Update Errors" to the Index menu. This
option adds an 'error' tag to each error. This does not visibly alter the text,
but one can then go to any error quickly using the Tags submenu off the Index
menu.

There is one last function errorth teaches, that of visiting a C file that a
compiler complains about. Once this module is loaded, pressing Meta-e brings up
the first compiler error message after the insert cursor. If the C file in the
message is not already being viewed by elsbeth, elsbeth opens up a new window on
the file. Otherwise, the window editing the file is brought up and its cursor is
brought to the line where the error occured.
Error:	Next:			Meta-e
}


