generate_pdt, genpdt

	Interprets a PDT declaration and generates C statements that
	declare and initialize a PDT.  The command line	parser routine
        evaluate_parameters uses the PDT to scan a command line for
        parameters and to display help information about the command.

          Examples:

            genpdt -i pdt_in -o pdt_out

            genpdt <pdt_in >pdt_out

	In the last example note that since the genpdt input and
	output files default to stdin and stdout, respectively,
	normal I/O redirection can be used.
.input
	Specifies the name of the input file containing a
	command's Parameter Description Table.  The PDT describes
	the names, aliases, types and default values of all the
	command's command line parameters, as well as the path
	name of the ar message module archive file containing
	help text for the command and its parameters.  
.output
	Specifies the name of the generate_pdt output file.  This
	file contains C language statements that are typically
	included in the source of your C application.  You then
	call the procedure evaluate_parameters, passing the PDT
	and the user's command line string; the command line is
	parsed and the results of the evaluation stored in the
	PDT.
.qualifier
	Specifies a qualifying string that uniquely identifies
	this PDT.  By default the C statements created by
	generate_pdt define the symbols pdt and pvt to be used
	by your application, which point to the results of the
	evaluation of the user's command line input.  Some C
	applications support 'multiple entry points'; that is,
	the same C module acts as more than one user program.
	And typically these 'multiple programs' accept different
	command line arguments.  So, there is a requirement that
	multiple instances of the pdt/pvt symbols be defined.

	Another reason to qualify the pdt/pvt symbols is when
	embedding evaluate_parameters into an application.  Each
	application command processor requires its own instance
	of these variables to keep parameter names and values
	distinct.

	The value of the qualifier parameter is thus prepended
	to the names pdt/pvt, as well as the `P_' ordinals that
	index into the pvt.  Therefore if -quailier = "OQ_" the
	symbols OQ_pdt and OQ_pvt would be defined.
