/*
 * keyCodes.h (CTk) --
 *
 *	This file defines the mapping from curses key codes to
 *	to X11 keysyms and modifier masks.
 *
 * Copyright (c) 1995 Cleveland Clinic Foundation
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * @(#) $Header: /usrs/cvs/root/ctk/keyCodes.h,v 1.1.1.1 1995/03/12 16:28:04 andrewm Exp $
 */

    { 0001, 0x0061, ControlMask },	/* Control-A */
    { 0002, 0x0062, ControlMask },	/* Control-B */
    { 0003, 0x0063, ControlMask },	/* Control-C */
    { 0004, 0x0064, ControlMask },	/* Control-D */
    { 0005, 0x0065, ControlMask },	/* Control-E */
    { 0006, 0x0066, ControlMask },	/* Control-F */
    { 0007, 0x0067, ControlMask },	/* Control-G */
    { 0010, 0xFF08, 0 },		/* Backspace (Control-H) */
    { 0011, 0xFF09, 0 },		/* Tab (Control-I) */
    { 0012, 0x006A, ControlMask },	/* Control-J */
    { 0013, 0x006B, ControlMask },	/* Control-K */
    { 0014, 0x006C, ControlMask },	/* Control-L */
    { 0015, 0xFF0D, 0 },		/* Carriage Return (Control-M) */
    { 0016, 0x006E, ControlMask },	/* Control-N */
    { 0017, 0x006F, ControlMask },	/* Control-O */
    { 0020, 0x0070, ControlMask },	/* Control-P */
    { 0021, 0x0071, ControlMask },	/* Control-Q */
    { 0022, 0x0072, ControlMask },	/* Control-R */
    { 0023, 0x0073, ControlMask },	/* Control-S */
    { 0024, 0x0074, ControlMask },	/* Control-T */
    { 0025, 0x0075, ControlMask },	/* Control-U */
    { 0026, 0x0076, ControlMask },	/* Control-V */
    { 0027, 0x0077, ControlMask },	/* Control-W */
    { 0030, 0x0078, ControlMask },	/* Control-X */
    { 0031, 0x0079, ControlMask },	/* Control-Y */
    { 0032, 0x007A, ControlMask },	/* Control-Z */
    { 0033, 0xFF1B, 0 },		/* Escape (deprecated) */
    { 0401, 0xFF6B, 0 },		/* Break key (unreliable) */
    { 0402, 0xFF54, 0 },		/* Down */
    { 0403, 0xFF52, 0 },		/* Up */
    { 0404, 0xFF51, 0 },		/* Left */
    { 0405, 0xFF53, 0 },		/* Right */
    { 0406, 0xFF50, 0 },		/* Home key (upward+left arrow) */
    { 0407, 0xFF08, 0 },		/* backspace (unreliable) */
    { 0411, 0xFFBE, 0 },		/* F1 */
    { 0412, 0xFFBF, 0 },		/* F2 */
    { 0413, 0xFFC0, 0 },		/* F3 */
    { 0414, 0xFFC1, 0 },		/* F4 */
    { 0415, 0xFFC2, 0 },		/* F5 */
    { 0416, 0xFFC3, 0 },		/* F6 */
    { 0417, 0xFFC4, 0 },		/* F7 */
    { 0420, 0xFFC5, 0 },		/* F8 */
    { 0421, 0xFFC6, 0 },		/* F9 */
    { 0422, 0xFFC7, 0 },		/* F10 */
    { 0510, 0xFFFF, ShiftMask },	/* Delete line */
    { 0511, 0xFF63, ShiftMask },	/* Insert line */
    { 0512, 0xFFFF, 0 },		/* Delete character */
    { 0513, 0xFF63, 0 },		/* Insert character/mode */
    { 0514, 0xFF63, 0 },		/* Exit insert mode */
    { 0515, 0xFF0B, 0 },		/* Clear screen */
    { 0522, 0xFF56, 0 },		/* Next page */
    { 0523, 0xFF55, 0 },		/* Previous page */
    { 0527, 0xFF0D, 0 },		/* Enter or send (unreliable) */
    { 0532, 0xFF61, 0 },		/* Print or copy */
    { 0533, 0xFF57, ControlMask },	/* home down or bottom (lower left) */
    { 0541, 0xFF09, ShiftMask },	/* Back tab */
    { 0542, 0xFF58, 0 },		/* beg(inning) key */
    { 0543, 0xFF69, 0 },		/* cancel key */
    { 0545, 0xFF62, 0 },		/* cmd (command) key */
    { 0546, 0xFF57, 0 },		/* End key */
    { 0552, 0xFF68, 0 },		/* Find key */
    { 0553, 0xFF6A, 0 },		/* Help key */
    { 0557, 0xFF09, 0 },		/* Next object key */
    { 0561, 0xFF67, 0 },		/* Options key */
    { 0557, 0xFF09, ShiftMask },	/* Previous object key */
    { 0563, 0xFF66, 0 },		/* Redo key */
    { 0601, 0xFF60, 0 },		/* Select key */
    { 0627, 0xFF13, 0 },		/* Suspend key */
    { 0630, 0xFF65, 0 },		/* Undo key */
