/* 
 * tmBasic.c --
 *
 *	Provides the support functions used by Tm_AppInit
 *
 * Copyright (c) 1993 J.D. Newmarch
 *
 * Copyright (c) 1993 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

#ifndef lint
static char rcsid[] = "$Header";
#endif /* not lint */

#include <tclXtSend.h>
#include "tmFuncs.h"

#include <X11/IntrinsicP.h>
#include <X11/CoreP.h>  /* for access to class_name in Core class rec */
#include <ctype.h>

#ifndef MOTIF11
#include <Xm/RepType.h>
#endif


#ifndef MOTIF11
#include <Xm/XmAll.h>
#else
#include <Xm/ArrowB.h>
#include <Xm/BulletinB.h>
#include <Xm/CascadeB.h>
#include <Xm/Command.h>
#include <Xm/DialogS.h>
#include <Xm/DrawingA.h>
#include <Xm/DrawnB.h>
#include <Xm/FileSB.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>
#include <Xm/List.h>
#include <Xm/MainW.h>
#include <Xm/MessageB.h>
#include <Xm/PanedW.h>
#include <Xm/PushB.h>
#include <Xm/RowColumn.h>
#include <Xm/Scale.h>
#include <Xm/ScrollBar.h>
#include <Xm/ScrolledW.h>
#include <Xm/SelectioB.h>
#include <Xm/Separator.h>
#include <Xm/Text.h>
#include <Xm/TextF.h>
#include <Xm/ToggleB.h>
#endif  /* MOTIF11 */

#if USE_UIL
#include <Mrm/MrmPublic.h>

extern void
Tm_UILCallbackHandler _ANSI_ARGS_((Widget,
	XtPointer, XtPointer));

static MrmRegisterArg
uil_callbacks[] = {
    {"tcl", (XtPointer) Tm_UILCallbackHandler}
};
#endif

#include <X11/Shell.h>

extern Tm_CommandToClassType Tm_CommToClass[];

/*
 *----------------------------------------------------------------------
 * Tm_Class -
 *	The tcl source filename is used to construct the class name as
 *	follows: a leading 'x' is capitalised and so is the following
 *	character, else the leading char is capitalised
 *
 * Result
 *	the class name as a new string
 *
 * Side effects
 *	None
 *----------------------------------------------------------------------
 */

char *
Tm_Class(interp)
    Tcl_Interp *interp;
{
    char *path;
    char *Class;

    path = Tcl_GetVar(interp, "argv0", TCL_GLOBAL_ONLY);

    Class = strrchr(path, '/');
    if (Class == NULL)
	Class = path;
    else
        Class++;

    Class = XtNewString(Class);
    if (Class[0] == 'x') {
	Class[0] = 'X';
	if (Class[0] != '\0')
	    Class[1] = toupper(Class[1]);
    } else
	Class[0] = toupper(Class[0]);

    return Class;
}

/*
 *--------------------------------------------------------------
 *
 * Tm_RegisterSendCmd --
 *	install the "send" command using the TclXtSend package
 *	from yours truly
 *
 * Results:
 *	none
 *
 * Side effects:
 *	"send" and "interps" command added to interpreter
 *	app name changed to <old-name> #N for some N if there 
 *	is a clash with an existing interpreter
 *--------------------------------------------------------------
 */

void
Tm_RegisterSendCmd(interp, argv0, toplevel)
    Tcl_Interp *interp;
    String argv0;
    Widget toplevel;
{
    String name, orig_name;
    int n = 1;

    XtVaGetValues(toplevel, XmNtitle, &orig_name, NULL);
    name = XtMalloc(strlen(orig_name) + 5);

    strcpy(name, orig_name);
    while (TclXtSend_RegisterInterp(interp, name, toplevel) == TCL_ERROR) {
	if (n > 99) {
	    XtAppErrorMsg(XtWidgetToApplicationContext(toplevel),
		"Tm error", "can't register send", "TmError",
		"can't register send command", NULL, 0);
	    XtFree(name);
	    return;;
	}
	n++;
	sprintf(name, "%s #%d", orig_name, n);
    }
    XtVaSetValues(toplevel, XmNtitle, name, NULL);
    XtFree(name);
}

/*
 *--------------------------------------------------------------
 *
 * Tm_SetOptions --
 *
 * Results:
 *	builds an array of options.
 *
 * Side effects:
 *	allocates memory for options array
 *
 *--------------------------------------------------------------
 */

int
Tm_SetOptions(interp, orig_opt, num_options, options)
    Tcl_Interp *interp;
    String orig_opt;
    int *num_options;
    XrmOptionDescRec **options;
{
    int n;
    char **options_str;
    int n_opt;
    char **opt_str;

    Tcl_SplitList(interp, orig_opt, num_options, &options_str);
    *options = (XrmOptionDescRec *) XtMalloc(*num_options * 
					sizeof(XrmOptionDescRec));
    for (n = 0; n < *num_options; n++) {
	Tcl_SplitList(interp, options_str[n], &n_opt, &opt_str);
	if (n_opt != 3) {
		sprintf(interp->result, "wrong options \"%50s\"", 
				options_str[n]);
		return TCL_ERROR;
	}
	(*options)[n].option = opt_str[0];
	(*options)[n].specifier = opt_str[1];
	(*options)[n].value = NULL;
	if (strcmp(opt_str[2], "noArg") == 0) {
	    (*options)[n].argKind = XrmoptionNoArg;
	    continue;
	} else
        if (strcmp(opt_str[2], "noArg") == 0) {
            (*options)[n].argKind = XrmoptionNoArg;
            continue;
        } else
        if (strcmp(opt_str[2], "isArg") == 0) {
            (*options)[n].argKind = XrmoptionIsArg;
            continue;
        } else
        if (strcmp(opt_str[2], "stickyArg") == 0) {
            (*options)[n].argKind = XrmoptionStickyArg;
            continue;
        } else
        if (strcmp(opt_str[2], "sepArg") == 0) {
            (*options)[n].argKind = XrmoptionSepArg;
            continue;
        } else
        if (strcmp(opt_str[2], "resArg") == 0) {
            (*options)[n].argKind = XrmoptionResArg;
            continue;
        } else
        if (strcmp(opt_str[2], "skipArg") == 0) {
            (*options)[n].argKind = XrmoptionSkipArg;
            continue;
        } else
        if (strcmp(opt_str[2], "skipNArgs") == 0) {
            (*options)[n].argKind = XrmoptionSkipNArgs;
            continue;
        } else
        if (strcmp(opt_str[2], "skipLine") == 0) {
            (*options)[n].argKind = XrmoptionSkipLine;
            continue;
        } else {
	    sprintf(interp->result, "unknown option kind \"%.50s\"", opt_str[2]);
	    return TCL_ERROR;
	}
    }
    return TCL_OK;
}

  
#define TMNUMDISPLAYS 256
static Tm_Display *tm_display_list = NULL;
static XtAppContext appContext = NULL;
static String applicationname = NULL;
static String applicationclass = NULL;

void Tm_SetAppContextInfo(c, appname, appclass)
    XtAppContext c;
    String appname;
    String appclass;
{
    appContext = c;
    applicationname = appname;
    applicationclass = appclass;
}

Tm_Display *Tm_AllocateDisplay()
{
    int i;
    Tm_Display *d = (Tm_Display*)XtMalloc(sizeof(Tm_Display));
    
    d->display = NULL;
    d->toplevel = NULL;
    d->registryProperty = 0;
    d->commProperty = 0;
#if USE_UIL
    d->hierarchy = NULL;
#endif
    d->numshellwidgets = 32;
    d->shellwidgets = NULL;
    d->shellwidgets = (Tm_Widget**)XtRealloc((char*)d->shellwidgets,
                                           d->numshellwidgets*sizeof(Tm_Widget*));
    for(i=0;i<d->numshellwidgets;++i)
      d->shellwidgets[i] = NULL;
    d->next = tm_display_list;
    tm_display_list = d;
    return d;
}

static Tm_Display *Tm_FindDisplayByName(name)
    char *name;
{
    Tm_Display *d;
    
    for(d = tm_display_list; NULL!=d; d = d->next)
      if(0 == strcmp(name,XDisplayString(d->display)))
          return d;
    return NULL;
}

Tm_Display *Tm_OpenDisplay(dispname)
    char *dispname;
{
    Tm_Display *displayInfo = NULL;

    displayInfo = Tm_FindDisplayByName(dispname);
    if(NULL==displayInfo) {
      Display *display;
      Widget w;
      
      int numargs = 0;
      
      display = XtOpenDisplay(appContext,dispname,applicationname,
                              applicationclass,NULL,0,
                              &numargs,NULL);
      if(NULL==display)
          return NULL;
      w = XtVaAppCreateShell(applicationname,applicationclass,
                             applicationShellWidgetClass,
                             display,XmNgeometry,"10x10+0+0",
                             XmNbaseWidth,0,XmNbaseHeight,0,
                             XmNmappedWhenManaged,False,
                             False,NULL );
      if(NULL == w) {
          XtCloseDisplay(display);
          return NULL;
      }
      displayInfo = Tm_AllocateDisplay();
      displayInfo->display = display;
      displayInfo->toplevel = w;
    }
    return displayInfo;
}

void Tm_DisplayAddShell(d, p)
    Tm_Display *d;
    Tm_Widget *p;
{
    int i;

#if 0
    fprintf(stderr,"adding shell %p to display %s\n",
	    p->widget,XDisplayString(d->display));
#endif
    for(i=0; i<d->numshellwidgets; ++i) {
      if(NULL==d->shellwidgets[i]) {
          d->shellwidgets[i] = p;
          return;
      }
    }
    d->shellwidgets = (Tm_Widget**)
      XtRealloc((char*)d->shellwidgets,d->numshellwidgets+32);
    for(i=d->numshellwidgets+32-1; i > d->numshellwidgets; --i)
      d->shellwidgets[i] = NULL;
    d->shellwidgets[d->numshellwidgets] = p;
    d->numshellwidgets += 32;
}

void Tm_DisplayRemoveShell(d, p)
    Tm_Display *d;
    Tm_Widget *p;
{
    int i;
    int cnt = 0;

#if 0
    fprintf(stderr,"removing shell %p from display %s\n",
	    p->widget,XDisplayString(d->display));
#endif
    for(i=0; i<d->numshellwidgets; ++i) {
      if(p==d->shellwidgets[i]) {
          d->shellwidgets[i] = NULL;
          if(cnt)
              return;
      } else
          if(NULL!=d->shellwidgets[i])
              ++cnt;
    }
    if(!cnt) {
	Tm_Display *p = tm_display_list;
	Tm_Display **prev = &tm_display_list;
    
	for(p = tm_display_list; NULL != p; prev = &(p->next), p = p->next) {
	    if(p == d) {
		*prev = p->next;
		d->next = NULL;
		if(NULL!=d->toplevel) {
		    Widget w = d->toplevel;
		    d->toplevel = NULL;
		    XtDestroyWidget(w);
		}
		XSync(d->display,True);
		XtCloseDisplay(d->display);
		XtFree((char*)d->shellwidgets);
		XtFree((char*)d);
	    }
	}
    }
    return;
}


/*
 *----------------------------------------------------------------------
 * Tm_AppInitialize -
 *	start the Xt world
 *
 * Result
 *	succeed or fail
 *
 * Side effects
 *	The Xt world is started
 *----------------------------------------------------------------------
 */

static int
Tm_AppInitialize(clientData, interp, argc, argv)
    ClientData clientData;
    Tcl_Interp *interp;
    int argc;
    char *argv[];
{
    char *Class = NULL;
    Tm_Widget *wPtr;
    Tm_Display *displayInfo;
    XtActionsRec actions[2];
    char *app_argv_str;
    char **app_argv;
    int app_argc = 0;
    int old_app_argc;
    XrmOptionDescRec *options = NULL;
    int num_options = 0;
    char **fallback_resources = NULL;
    int num_fallback_resources;
    char buf[128];
    int n;
    Widget toplevel;
    Bool makeAppContextCmd = False;
    char *appContextCmd = NULL;

    /* only allow this to start once */
    if (Tcl_GetVar(interp, "_Tm_WorldInited", TCL_GLOBAL_ONLY) != NULL)
	 return TCL_OK;
    Tcl_SetVar(interp, "_Tm_WorldInited", "1", TCL_GLOBAL_ONLY);

    /* restore the argv/arc pair - note that we have to bring argv0 in
       or we don't get a suitable app name in app_argv[0]. We have to
       copy the string from static as Tcl_Parse (tcl7.1, line 1214) writes
       to it, crashing a Sun
     */
    strcpy(buf, "set _Tm_AllArgs [concat $argv0 $argv]");
    Tcl_GlobalEval(interp, buf);
    app_argv_str = Tcl_GetVar(interp, "_Tm_AllArgs", TCL_GLOBAL_ONLY);
    Tcl_SplitList(interp, app_argv_str, &app_argc, &app_argv);
    old_app_argc = app_argc;

#if 0
    /* don't copy - we don't free this after all! */
    /* bug workaround */
    for (n = 0; n < app_argc; n++) {
	if (app_argv[n][0] == '-') {
	    if (strcmp(app_argv[n], "-geometry") == 0) {
		/* the Intrinsics don't copy this resource (do they?)
		   so make our own copy, 'cos it gets freed later, trashing
		   the value
		 */
		n++;
		app_argv[n] = XtNewString(app_argv[n]);
	    }
	}
    }
#endif


    for (n = 1; n < argc; n++) {
	if (argv[n][0] == '-') {
	    if (strcmp(argv[n], "-appContext") == 0) {
		/* set info to create an appContext cmd after XtAppInit() */
		n++;
		makeAppContextCmd = True;
		appContextCmd = XtNewString(argv[n]);
	    } else

	    if (strcmp(argv[n], "-class") == 0) {
		Class = XtNewString(argv[n+1]);
		n++;
		continue;
	    } else

	    if (strcmp(argv[n], "-options") == 0) {
		n++;
		if (Tm_SetOptions(interp, argv[n], &num_options, &options) ==
				TCL_ERROR)
		    return TCL_ERROR;
		continue;
	    } else

	    if (strcmp(argv[n], "-fallbackResources") == 0) {

		Tcl_SplitList(interp, argv[n+1], &num_fallback_resources,
				&fallback_resources);
		n++;
		continue;
	    }
	}
    }

#   ifndef MOTIF11
        XtSetLanguageProc(NULL, NULL, NULL);
#   endif

#   if USE_UIL
	MrmInitialize();
	MrmRegisterNames(uil_callbacks, XtNumber(uil_callbacks));
        Tcl_SetVar(interp, "_Tm_UIL", "1", TCL_GLOBAL_ONLY);
#else
        Tcl_SetVar(interp, "_Tm_UIL", "0", TCL_GLOBAL_ONLY);
#   endif

    /* class set, or derive it from argv0? */
    if (Class == NULL) 
	Class = Tm_Class(interp);

    toplevel = XtAppInitialize (&appContext, Class, options, num_options,
				&app_argc, app_argv,
				fallback_resources, 
				NULL, 0);

    if (makeAppContextCmd) {
	Tcl_CreateCommand(interp, appContextCmd, Tm_RootCmd,
			(ClientData) appContext, (void (*) ()) NULL);
    }

    XtFree(Class);

    /* did AppInit consume any args? If so, reset argv, argc */
    if (app_argc != old_app_argc) {
	char buffer[32], *args;

        args = Tcl_Merge(app_argc-1, app_argv+1);
        Tcl_SetVar(interp, "argv", args, TCL_GLOBAL_ONLY);
        ckfree(args);
        sprintf(buffer, "%d", app_argc-1);
        Tcl_SetVar(interp, "argc", buffer, TCL_GLOBAL_ONLY);
    }

    /* register the actions handler */
    actions[0].string = "exec";		/* for backward compatability */
    actions[0].proc = Tm_ActionsHandler;

    actions[1].string = "action";
    actions[1].proc = Tm_ActionsHandler;

    XtAppAddActions(appContext, actions, 2);

    displayInfo = Tm_AllocateDisplay();
    displayInfo->toplevel = toplevel;
    displayInfo->display = XtDisplay(toplevel);
    XtGetApplicationNameAndClass(XtDisplay(toplevel),
                               &applicationname,&applicationclass);


    wPtr = (Tm_Widget *) XtMalloc (sizeof (Tm_Widget));
    wPtr -> interp = interp;
    wPtr -> widget = toplevel;
    wPtr -> pathName = XtNewString(".");
    wPtr -> parent = ".";	/* kludge to stop later breakages */
    wPtr -> displayInfo = displayInfo;

    Tm_StoreWidgetInfo(".", wPtr, interp);

    Tcl_CreateCommand (interp, ".", Tm_RootCmd,
                 (ClientData) wPtr, (void (*) ()) NULL);

    XtAddCallback(toplevel, XmNdestroyCallback, Tm_DestroyWidgetHandler, wPtr);

    Tm_RegisterConverters(interp, appContext);

    /* now try to create the "send" command */
    Tm_RegisterSendCmd(interp, app_argv[0], toplevel);

    /* don't free this - the AppShell resource XmNargv points to the
       set of strings contained in app_argv!
    free((char *) app_argv);
    */

    /* register the tear-off menu converter */
#   ifndef MOTIF11
	XmRepTypeInstallTearOffModelConverter();
#   endif

#   ifdef MALLOC_TRACE
	mal_leaktrace(1);
#   endif

    /* perform any startup stuff for any extension widgets */
    Tm_ExternWidgetsInitialise(interp);

    return TCL_OK;
}

/*
 *----------------------------------------------------------------------
 *
 * Tm_Init --
 *
 *	This procedure performs initialization for the Tm extension.
 *	Applications that wish to use tclMotif with other extensions
 *	should include this procedure in TclAppInit along with the
 *	other extensions.
 *
 * Results:
 *	Returns a standard Tcl completion code, and leaves an error
 *	message in interp->result if an error occurs.
 *
 * Side effects:
 *	Creates the tclMotif commands in the interpreter.
 *
 *----------------------------------------------------------------------
 */
int
Tm_Init (interp)
    Tcl_Interp *interp;
{
    static char initCmd[] =
#if defined TMUSEINITFILE
        "if [file exists $tm_library/init_tclMotif.tcl] {\n\
            source  $tm_library/init_tclMotif.tcl\n\
        }";
#else
	"global tclMotif_unknown\n\
	\n\
	set tclMotif_unknown \"unknown\"\n\
	\n\
	while {[info commands $tclMotif_unknown] != \"\"} {\n\
	    set tclMotif_unknown $tclMotif_unknown.old\n\
	}\n\
	\n\
	rename unknown $tclMotif_unknown\n\
	\n\
	proc unknown {name args} {\n\
	    global tclMotif_unknown\n\
	\n\
	    set cmds [info commands $name]\n\
	    set len [llength $cmds]\n\
	    if {$len == 0} {\n\
		# no match, pass to old unknown\n\
		set cmd \"uplevel 1 $tclMotif_unknown $name $args\"\n\
		eval $cmd\n\
	    }\n\
	    if {$len > 1} {\n\
		error \"non-unique command \\\"$name\\\" matches \\\"$cmds\\\"\"\n\
	    }\n\
	\n\
	    # unique abbreviation:\n\
	    return [uplevel $cmds $args]\n\
	}\n\
";
#endif /* 0 */
    char *libDir;
    char buf[32];

    /*
     * Bind in Tm's commands.
     */

    Tm_LoadWidgetCommands (interp);

    /* load the Xt commands */
    Tcl_CreateCommand(interp, "xtAppInitialize", Tm_AppInitialize,
			NULL, NULL);

    /*
     * Set variables for the intepreter.
     */

    libDir = getenv("TM_LIBRARY");
    if (libDir == NULL) {
	libDir = TM_LIBRARY;
    }
    Tcl_SetVar(interp, "tm_library", libDir, TCL_GLOBAL_ONLY);
    Tcl_SetVar(interp, "tm_version", TM_VERSION, TCL_GLOBAL_ONLY);
    Tcl_SetVar(interp, "tmVersion", TM_VERSION, TCL_GLOBAL_ONLY);

    /* Set Motif version info */
    sprintf(buf, "%d", XmVERSION);
    Tcl_SetVar(interp, "XmVERSION", buf, TCL_GLOBAL_ONLY);
    sprintf(buf, "%d", XmVersion);
    Tcl_SetVar(interp, "XmVersion", buf, TCL_GLOBAL_ONLY);
    sprintf(buf, "%d", XmREVISION);
    Tcl_SetVar(interp, "XmREVISION", buf, TCL_GLOBAL_ONLY);

    /* create the command to extract info from an X event */
    Tcl_CreateCommand(interp, "xEvent", Tm_XEvent,
                        NULL, NULL);

    /* load library */
    return Tcl_Eval(interp, initCmd);
}
