.TH TmRoot 3 "24 July 1993"
.SH NAME
.B TmRoot
- the toplevel widget ``.''
.SH SYNOPSIS
xtAppInitialize
.br
.SH DESCRIPTION
This is the command that creates the root widget ``.''

.SH OPTIONS
The function xtAppInitialize has these options
.RS 5
-appContext
.I appContext
.RS 5
This allows the application context to be made into a separate command
.I appContext
as well as accesible through `.'.
This may be useful if you wish to have multiple application contexts
or use multiple displays.
.RE
-class 
.I class
.br
-fallbackResources
.I resources
.br
.RS 5
These are in a tcl list, as in
.br
.nf
.na
	{
                {*list.visibleItemCount: 10}
                {*quit.labelString: Quit}
	}
.fi
.ad
.RE
-options
.I options
.br
.RS 5
These set the application options. The
.I options
is a list of option values. Each option value consists of the command line
option (such as -helpFile), the resource name (such as helpFile) and
the type of command line argument supported. Possible values for this are
.RS 5
noArg
.br
sepArg
.br
stickyArg
.br
resArg
.br
skipArg
.br
skipLine
.RE
For example,
.RS 5
.nf
.na
-options {
	{-helpFile helpFile sepArg} 
	{-showHelp showHelp isArg}
    }
.ad
.fi
.RE
.RE

.SH METHODS
The methods supported for this widget include all the commands for
the TmCore and TmTopLevelShell widget.
In addition, these methods are also available to the ``.'' widget
.RS 5
addInput
.br
removeInput
.br
addTimer
.br
removeTimer
.br
addWMProtocolCallback
.br
getAppResources
.br
mainLoop
.br
pending
.br
processEvent
.RE

.B addInput 
.I "file mode command
.RS 5
This method adds the tcl command as an input handler for the file,
according to the mode specified. This can be `r' for read, `w' for
write or `x' for exception. 
Whenever the file is ready for the requested operation the tcl function
is called to handle it.
The command returns an XID which is an identifier for the input handler.
.RE

.B removeInput
.I inputID
.RS 5
This method removes the file handler added by addInput. It takes as argument
the identifier returned from ``addInput''.
.RE

.B addTimer
.I "interval command
.RS 5
This method adds the tcl command to an Xt timer.
The interval is in milliseconds.
The command returns an XID which is an identifier for the input handler.
.RE

.B removeTimer
.I timerID
.RS 5
This method removes the timer added by addTimer. It takes as argument
the identifier returned from ``addTimer''.
Note that if an attempt is made to remove a timer that has gone off,
Xt has unspecified behaviour.
.RE

.B addWMProtocolCallback
.I "atom command...
.RS 5
This adds the command as a callback when the window manager sends a message
given by the atom. Atoms defined by ICCCM are WM_TAKE_FOCUS, WM_DELETE_WINDOW
(normally sent when the Close button from the Window manager menu is selected)
and WM_SAVE_YOURSELF.
.RE

.B mainLoop
.RS 5
This starts the Xt event processing loop
.RE

.B pending
.RS 5
The checks the Xt even t queue without processing any events.
It returns a list of event types currently queued. The elements of
the list can be "XEvent", "Timer" or "AlternateInput".
If no events are pending, the list will be empty.
.RE

.B processEvent
.RS 5
This processes the next event, along with any timers and input handlers.
It is supplied here for use in modal dialogs.
.RE

.SH "CALLBACK SUBSTITUTIONS
No additional substitutions are supported for this class.
.SH BUGS
None known.
.SH AUTHOR
.LP
Jan Newmarch, University of Canberra
