.TH TmCore 3 "24 July 1993"
.SH NAME
.B TmCore
- the Core widget class
.SH SYNOPSIS
No command exists to create this widget - it is for inheritance
purposes only.
.br
.SH DESCRIPTION
This is the
.I tcl
binding to the Xt Core widget.
.SH RESOURCES
The new resources are
.IP
background
.br
backgroundPixmap
.br
borderColor
.br
borderPixmap
.br
borderWidth
.br
destroyCallback
.br
height
.br
mappedWhenManaged
.br
sensitive
.br
width
.br
x
.br
y
.LP
.TP 5 5
.B background
The value for this resource is the name of a color.
.TP 5 5
.B height
The value for this resource is an integer number of pixels.
.TP 5 5
.B sensitive
The values for this resource are
.RS 10
.br
true
.br
false
.RE 10
.SH METHODS
The methods supported for this widget and all its descendants are
.RS 5
getValues
.br
setValues
.br
manageChild
.br
unmanageChild
.br
beep
.br
getGC
.br
callActionProc
.br
defineCursor
.br
destroyWidget
.br
displayInfo
.br
dragStart
.br
dropSiteRegister
.br
getAppResources
.br
getSelectionValue
.br
isComposite
.br
isConstraint
.br
isManaged
.br
isMapped
.br
isSensitive
.br
isShell
.br
lowerWindow
.br
mapWidget
.br
processTraversal
.br
raiseWindow
.br
realizeWidget
.br
removeCallback
.br
resources
.br
setCommand
.br
setSensistive
.br
unmapWidget
.br
windowId
.br
augmentTranslations
.br
overrideTranslations
.br
uninstallTranslations
.br
warpPointer
.RE

.LP
.TP 5 5
\fBgetValues\fP \fI-resource vbl ...\fP
.B getValues
takes a list of resource/variable pairs and stores the value of each
resource in the corresponding variable.

.TP 5 5
\fBsetValues\fP \fI-resource value ...\fP
.B setValues
takes a list of resource/value pairs and sets each resource to the
corresponding value.

.TP 5 5
.B manageChild
This manages the child and brings it under the geometry management of
the parent.

.TP 5 5
.B unmanageChild
This removes the child from the geometry management of the parent.
.TP 5 5
\fBgetGC\fP [-background \fIbg\fP] [-foreground \fIfg\fP] [-font \fI font\fP]
This method creates a graphics context with the specified foreground,
background and font values, and returns an XID that can be used in drawing
commands requiring a graphics context.

.TP 5 5
\fBcallActionProc\fP \fIaction\fP [options]
This calls the widget action specified.
The action must be in the form it would appear in an action table,
The event included given to the action is by default of type
ClientMessage.
Options include
.br
-type ButtonRelease | ButtonPress | KeyRelease | KeyPress
.br
.RS 10
This sets the event type.
.RE
.br
-x
.I x
.RS 10
This sets the 
.I x
value in the event.
.RE
-y
.I y
.RS 10
This sets the
.I y
value in the event.
.RE
.br
-keysysm
.I keysym
.RS 10
This sets the keysym for a KeyRelease or KeyPress event. A
.I keysym
is the Xt abstraction for keys.
.RE
For example the arrow widget has an action Activate() which requires
x and y values of the pointer:
.ti +5
callActionproc Activate() -type ButtonPress -x 0 -y 0

.TP 5 5 
\fB defineCursor \fP \fI cursor \fP
This sets the cursor for a widget. Possible values are the X Font Cursors
with the leading XC_ omitted. Note that it is an error to attempt to
set a cursor on a widget that has not been realized. For example,
.ti +5
.btn defineCursor coffee_mug
sets the coffe mug cursor.
A null cursor value of "" resets the cursor for the window to the default.

.TP 5 5
.B destroyWidget
The destroys the widget and the
.I tcl
command associated to it.
Note that destruction of widgets is a 2-phase process, and the widget may
not actually be destroyed till later. The command is deleted immediately.
This may result in inconsistent state between Xt and tcl, where the widget
still exists but there is no tcl command for it anymore. The alternative
of deleting the command only when the widget is destroyed
is no better because then there is no way of knowing when the command
has been deleted.

.TP 5 5
.B displayInfo
This returns a list of {display name, display width (pixels), 
display height (pixels), display width (mm), display height (mm),
default screen, default depth, default root window}

.TP 5 5
.B dragStart
This is used in drag and drop. See TmDrag.man.

.TP 5 5
.B dropSiteRegister
This is used in drag and drop. See TmDrag.man.

.TP 5 5
\fB getAppResources \fP \fI resources \fP
.RS 5
This extracts the application resources as set in the resource database.
The
.I resources
argument is a list of resource sets. Each one consists of the resource
name, its class, the default value and the name of a tcl variable to store
the value in.
For example,
.RS 5
.nf
.na
{
    {helpFile HelpFile "" tcl_helpFile }
    {showHelp ShowHelp 0 tcl_show}
}
.ad
.fi
.RE
.RE

.TP 5 5
\fBgetSelectionValue\fP \fIselection command\fP
.B getSelectionValue
attempts to get the selection
.I selection
which can be e.g. ``PRIMARY'', ``CLIPBOARD''
If it succeeds, it executes the tcl command.
Before executing the command it will substitute any string
%selection with the value of the selection.

.TP 5 5
.B mapWidget
This maps the widget, causing it to become visible if unmapped.

.TP 5 5
\fB processTraversal \fP\fI direction \fP
This sets the widget that receives the next keyboard events. The possible
values are 
.RS 10
current
.br
down
.br
home
.br
left
.br
next
.br
next_tab_group
.br
prev
.br
prev_tab_group
.br
right
.br
up
.RE

.TP 5 5
\fB removeCallback \fP \fI callback command \fP
Removes the callback that matches the callback and the
tcl command.

.TP 5 5
.B realizeWidget
This realizes the widget and all its children, which creates windows
for the widget and its children. 
Generally this would only be used on `.', but may be used on other
widgets if it is neccessary that they have an X window.

.TP 5 5
.B resources
This returns a list of resources that the widget has.
Each element of the list consists of a list of five values:
the resource name as used in get/setValues,
the resource name as used in resource files,
the resource class as used in resource files,
the resource type as known to Motif
and the resource value.
in cases where the resource value makes no sense (as in
a C pointer), it is replaced by an empty string.

.TP 5 5
\fB setCommand \fP [command arguments]
This sets the command and arguments used to invoke the application,
and may be used by an X11R5 session manager. With no arguments,
the command line of the application at startup time is used.
This method should only be used on toplevel shells, typically `.'.
This command is obsolete for X11R6, where session manager resources
should be used.

.TP 5 5
\fB setSensitive \fP true | false
Sets the sensitivity of the widget to input events to either
true or false.

.TP 5 5
.B unmapWidget
This unmaps the widget, removing it from the display.
It does not remove it from the geometry management of the parent.

.TP 5 5
\fB augmentTranslations \fP \fI translations \fP
.TP 5 5
\fB overrideTranslations \fP \fI translations \fP
.TP 5 5
\fB uninstallTranslations \fP
Manipulate the translations for a widget.

.SH "CALLBACK SUBSTITUTIONS
The callback substitutions for %x and %y (the x and y coordinates of the
event) are supported for those events for which these fields are
meaningfull (ButtonEvent, KeyEvent, MotionEvent).

.SH BUGS
None known.
.SH AUTHOR
.LP
Jan Newmarch, University of Canberra
