# tkIconPaneInt.tcl
#
# Copyright (c) 1993 by Sven Delmas
# All rights reserved.
# See the file COPYRIGHT for the copyright notes.

if {![string compare "" [info commands tkiconpane_create]]} {

global ip_priv DragDrop
set ip_priv(mega) mega
set ip_priv(menuBar) ""
set ip_priv(toolBar) ""
set DragDrop(iconInterpreter) ""
set DragDrop(iconPath) ""
set DragDrop(iconDragMode) ""
set DragDrop(iconIds) ""

##################################
# the following procs are "global"
##################################

proc tkiconpane {pathName args} {# xf ignore me 7
  global auto_path env ip_priv DragDrop

  # can we use mega widgets
  catch "megawidget" result
  if {![string match "wrong # args:*" $result]} {
    error "the megawidget widget is not available!"
  }

  # raise iconpane if it already exists and is a toplevel
  if {[string compare "" [info commands $pathName]]} {
    if {![string compare "toplevel" [winfo class $pathName]]} {
      raise $pathName
    }
    return
  }

  # find the library file for tkiconpane
  set initMegaName ""
  set initIconName ""
  set searchList ""
  if {[info exists env(XF_LOAD_PATH)]} {
    foreach dirName [split $env(XF_LOAD_PATH) :] {
      lappend searchList $dirName
    }
  }
  foreach dirName $auto_path {
    lappend searchList $dirName
  }
  lappend searchList "."

  foreach dirName $searchList {
    if {[file exists $dirName/tkMegaWidget.tcl]} {
      set initMegaName $dirName/tkMegaWidget.tcl
    } {
      if {[file exists $dirName/TkMegaWidget/tkMegaWidget.tcl]} {
        set initMegaName $dirName/TkMegaWidget/tkMegaWidget.tcl
      } {
        if {[file exists [file dirname $dirName]/TkMegaWidget/tkMegaWidget.tcl]} {
          set initMegaName [file dirname $dirName]/TkMegaWidget/tkMegaWidget.tcl
        }
      }
    }
    if {[file exists $dirName/tkIconPaneInt.tcl]} {
      set initIconName $dirName/tkIconPaneInt.tcl
    } {
      if {[file exists $dirName/TkIcon/tkIconPaneInt.tcl]} {
        set initIconName $dirName/TkIcon/tkIconPaneInt.tcl
      } {
        if {[file exists [file dirname $dirName]/TkIcon/tkIconPaneInt.tcl]} {
          set initIconName [file dirname $dirName]/TkIcon/tkIconPaneInt.tcl
        }
      }
    }
  }
  if {![string compare "" $initMegaName]} {
    error "Cannot locate internal tkMegaWidget.tcl file"
  }
  if {![string compare "" $initIconName]} {
    error "Cannot locate internal tkIconPaneInt.tcl file"
  }

  # initialize the data
  set ip_priv(clickCounter) 0
  set ip_priv(currentPane) $pathName 
  set DragDrop(iconInterpreter) ""
  set DragDrop(iconPath) ""
  set DragDrop(iconDragMode) ""
  set DragDrop(iconIds) ""

  # create the widget
  if {![string compare "-toplevel" [lindex $args 0]] &&
      ![string compare "1" [lindex $args 1]]} {
    if {[catch "topmegawidget $pathName -class TkIconPane -interpreter TkIconPane -crypting 0 -createcommand tkiconpane_create -libfile $initMegaName -userfile $initIconName" result]} {
      error $result
    }
    wm minsize $pathName 10 10
    wm maxsize $pathName 2000 2000
    raise $pathName
  } {
    if {[catch "megawidget $pathName -class TkIconPane -interpreter TkIconPane -crypting 0 -createcommand tkiconpane_create -libfile $initMegaName -userfile $initIconName" result]} {
      error $result
    }
  }
  eval $pathName config $args
}

proc tkiconpane_info {{type "path"} args} {
  global ip_priv

  set pathName $ip_priv(currentPane)
  case $type {
    {tkiconpanename} {
      return [lindex [$pathName config -name] 4]
    }
    {canvaspath} {
      return [lindex [$pathName config -canvaspath] 4]
    }
    {edgeinfo} {
      return [eval $pathName edgeinfo $args]
    }
    {iconinfo} {
      return [eval $pathName iconinfo $args]
    }
    {default} {
      return $pathName
    }
  }
  return ""
}

proc tkiconpane_updateMenu {{menuPath ""}} {
  if {[string compare "" $menuPath]} {
    set pathName [tkiconpane_info tkiconpane]
    $menuPath conf -activebackground \
      [lindex [$pathName config -activebackground] 4]
    $menuPath conf -activeforeground \
      [lindex [$pathName config -activeforeground] 4]
    $menuPath conf -background \
      [lindex [$pathName config -background] 4]
    $menuPath conf -foreground \
      [lindex [$pathName config -foreground] 4]
    $menuPath conf -font [lindex \
      [$pathName config -font] 4]
  }
}

proc tkiconpane_createEdgeMenu {name} {
  menu .emenu-$name \
    -postcommand "tkiconpane_updateMenu .emenu-$name"
}

proc tkiconpane_createIconMenu {name} {
  menu .imenu-$name \
    -postcommand "tkiconpane_updateMenu .imenu-$name"
}

proc tkiconpane_dropPosition {pathName} {
  global ip_priv

  if {![$pathName confvalue -dragdrop]} {
    return ""
  }
  set canvasPath $pathName.xfcanvas.xfcanvas.xfcanvas
  set tmpPosition [blt_drag&drop location]
  set tmpX [$canvasPath canvasx [expr [lindex $tmpPosition 0]-[winfo rootx $canvasPath]]]
  set tmpY [$canvasPath canvasy [expr [lindex $tmpPosition 1]-[winfo rooty $canvasPath]]]
  return [list $tmpX $tmpY]
}

#################################
# here begins the "local" section
#################################

proc tkiconpane_create {pathName args} {# xf ignore me 7
  global ip_priv

  # internal options
  $ip_priv(mega)$pathName optionadd \
    -clickeval clickEval ClickEval 0 0 hidden {}
  $ip_priv(mega)$pathName optionadd \
     -currentid currentId CurrentId {} {} hidden {}
  $ip_priv(mega)$pathName optionadd \
    -dragdrophideicon dragDropHideIcon DragDropHideIcon "" "" hidden {}
  $ip_priv(mega)$pathName optionadd \
    -dragdropicon dragDropIcon DragDropIcon "" "" hidden {}
  $ip_priv(mega)$pathName optionadd \
    -edgefont edgeFont Font -*-Courier-Medium-R-Normal--12-120-* \
    -*-Courier-Medium-R-Normal--12-120-* hidden {}
  $ip_priv(mega)$pathName optionadd \
    -eventtype eventType EventType -1 -1 hidden {}
  $ip_priv(mega)$pathName optionadd \
    -focus focus Focus {} {} hidden {}
  $ip_priv(mega)$pathName optionadd \
    -grab grab Grab {} {} hidden {}
  $ip_priv(mega)$pathName optionadd \
    -iconfont iconFont Font -*-Courier-Medium-R-Normal--12-120-* \
    -*-Courier-Medium-R-Normal--12-120-* hidden {}
  $ip_priv(mega)$pathName optionadd \
    -iconsmoved iconsMoved IconsMoved 0 0 hidden {}
  $ip_priv(mega)$pathName optionadd \
    -initialized initialized Initialized 0 0 hidden {}
  $ip_priv(mega)$pathName optionadd \
    -moveitems moveItems MoveItems {} {} hidden {}
  $ip_priv(mega)$pathName optionadd \
    -selectededge selectedEdge SelectedEdge {} {} hidden {}
  $ip_priv(mega)$pathName optionadd \
    -selectededgelist selectedEdgeList SelectedEdgeList {} {} hidden {}
  $ip_priv(mega)$pathName optionadd \
    -selectedicon selectedIcon SelectedIcon {} {} hidden {}
  $ip_priv(mega)$pathName optionadd \
    -selectediconlist selectedIconList SelectedIconList {} {} hidden {}
  $ip_priv(mega)$pathName optionadd \
    -selectedid selectedId SelectedId {} {} hidden {}
  $ip_priv(mega)$pathName optionadd \
    -startx startX X {} {} hidden {}
  $ip_priv(mega)$pathName optionadd \
    -starty startY Y {} {} hidden {}
  $ip_priv(mega)$pathName optionadd \
    -stretch stretch Stretch {} {} hidden {}
  $ip_priv(mega)$pathName optionadd \
    -stretchxroot stretchXRoot StretchXRoot {} {} hidden {}
  $ip_priv(mega)$pathName optionadd \
    -stretchyroot stretchYRoot StretchYRoot {} {} hidden {}
  $ip_priv(mega)$pathName optionadd \
    -stretchx stretchX StretchX {} {} hidden {}
  $ip_priv(mega)$pathName optionadd \
    -stretchy stretchY StretchY {} {} hidden {}
  $ip_priv(mega)$pathName optionadd \
    -x x X {} {} hidden {}
  $ip_priv(mega)$pathName optionadd \
    -y y Y {} {} hidden {}

  # standard options
  $ip_priv(mega)$pathName optionadd \
    -activebackground activeBackground Foreground #eed5b7 #eed5b7 \
    normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd \
    -activeforeground activeForeground Background black black \
    normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd \
    -background background Background #ffe4c4 #ffe4c4 \
    normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd \
    -cursor cursor Cursor xterm xterm \
    normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd \
    -font font Font -Adobe-Helvetica-Bold-R-Normal--*-120-* \
    -Adobe-Helvetica-Bold-R-Normal--*-120-* \
    normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd \
    -foreground foreground Foreground black black \
    normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd \
    -geometry geometry Geometry {} {} \
    normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd \
    -padx padX PadX 2 2 \
    normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd \
    -pady padY PadY 2 2 \
    normal {tkiconpane_internalConf}

  # special options
  $ip_priv(mega)$pathName optionadd \
    -bindtype bindType BindType 0 0 \
    normal {}
  $ip_priv(mega)$pathName optionadd \
    -canvasboxtag canvasBoxTag Tag {} {} \
    normal {}
  $ip_priv(mega)$pathName optionadd \
    -canvaspath canvasPath Path {} {} \
    normal {}
  $ip_priv(mega)$pathName optionadd \
    -canvasstatustag canvasstatustag Tag {} {} \
    normal {}
  $ip_priv(mega)$pathName optionadd \
    -changed changed Changed 0 0 \
    normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd \
    -clickinterval clickInterval ClickInterval 300 300 \
    normal {}
  $ip_priv(mega)$pathName optionadd \
    -compressiconconf compressIconConf CompressIconConf 0 0 \
    normal {}
  $ip_priv(mega)$pathName optionadd \
    -computeiconsize computeIconSize ComputeIconSize 1 1 \
    normal {}
  $ip_priv(mega)$pathName optionadd \
    -dragdrop dragDrop DragDrop 0 0 \
    normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd \
    -dropcommand dropCommand Command {} {} \
    normal {}
  $ip_priv(mega)$pathName optionadd \
    -edgeorder edgeOrder EdgeOrder 0 0 \
    normal {}
  $ip_priv(mega)$pathName optionadd \
    -edgefont1 edgeFont1 Font -*-Courier-Medium-R-Normal--8-80-* \
    -*-Courier-Medium-R-Normal--8-80-* \
    normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd \
    -edgefont2 edgeFont2 Font -*-Courier-Medium-R-Normal--10-100-* \
    -*-Courier-Medium-R-Normal--10-100-* \
    normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd \
    -edgefont3 edgeFont3 Font -*-Courier-Medium-R-Normal--12-120-* \
    -*-Courier-Medium-R-Normal--12-120-* \
    normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd \
    -edgefont4 edgeFont4 Font -*-Courier-Medium-R-Normal--17-120-* \
    -*-Courier-Medium-R-Normal--17-120-* \
    normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd \
    -edgefont5 edgeFont5 Font -*-Courier-Medium-R-Normal--24-240-* \
    -*-Courier-Medium-R-Normal--24-240-* \
    normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd \
    -graphorder graphOrder graphOrder 0 0 \
    normal {}
  $ip_priv(mega)$pathName optionadd \
    -iconfont1 iconFont1 Font -*-Courier-Medium-R-Normal--8-80-* \
    -*-Courier-Medium-R-Normal--8-80-* \
    normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd \
    -iconfont2 iconFont2 Font -*-Courier-Medium-R-Normal--10-100-* \
    -*-Courier-Medium-R-Normal--10-100-* \
    normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd \
    -iconfont3 iconFont3 Font -*-Courier-Medium-R-Normal--12-120-* \
    -*-Courier-Medium-R-Normal--12-120-* normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd \
    -iconfont4 iconFont4 Font -*-Courier-Medium-R-Normal--17-120-* \
    -*-Courier-Medium-R-Normal--17-120-* normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd \
    -iconfont5 iconFont5 Font -*-Courier-Medium-R-Normal--24-240-* \
    -*-Courier-Medium-R-Normal--24-240-* normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd \
    -iconheight iconHeight IconHeight 40 40 \
    normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd \
    -iconspaceh iconSpaceH IconSpace 4 4 \
    normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd \
    -iconspacev iconSpaceV IconSpace 4 4 \
    normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd \
    -iconwidth iconWidth IconWidth 40 40 \
    normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd \
    -layout layout Layout 1 1 \
    normal {}
  $ip_priv(mega)$pathName optionadd \
    -layoutcommand layoutCommand Command {} {} \
    normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd \
    -layoutupdate layoutUpdate LayoutUpdate 0 0 \
    normal {}
  $ip_priv(mega)$pathName optionadd \
    -menu1 menu1 Menu {} {} \
    normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd \
    -menu2 menu2 Menu {} {} \
    normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd \
    -menu3 menu3 Menu {} {} \
    normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd \
    -menubar menuBar Menu {} {} \
    normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd \
    -menupath menuPath MenuPath {} {} \
    normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd \
    -movefuzzy moveFuzzy MoveFuzzy 0 0 \
    normal {}
  $ip_priv(mega)$pathName optionadd \
    -name name Name {} {} \
    normal {}
  $ip_priv(mega)$pathName optionadd \
    -placing placing Placing 1 1 \
    normal {}
  $ip_priv(mega)$pathName optionadd \
    -scale scale Scale 1 1 \
    normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd \
    -scrollactiveforeground activeForeground Background #ffaeb9 #ffaeb9 \
    normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd \
    -scrollbackground scrollBackground Background #cdb79e #cdb79e \
    normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd \
    -scrollforeground scrollForeground Foreground #ffe4c4 #ffe4c4 \
    normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd \
    -scrollside scrollSide ScrollSide right right \
    normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd \
    -selectcommand selectCommand Command {} {} \
    normal {}
  $ip_priv(mega)$pathName optionadd \
    -sortcommand sortCommand Command {} {} \
    normal {}
  $ip_priv(mega)$pathName optionadd \
    -statusafter statusAfter StatusAfter 0 0 \
    normal {}
  $ip_priv(mega)$pathName optionadd \
    -statusvariable statusVariable StatusVariable {} {} \
    normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd \
    -title title Title {} {} \
    normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd \
    -tkiconlib tkIconLib TkIconLib {} {} \
    normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd \
    -toolbarbottom toolbarBottom Toolbar {} {} \
    normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd \
    -toolbarleft toolbarLeft Toolbar {} {} \
    normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd \
    -toolbarright toolbarRight Toolbar {} {} \
    normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd \
    -toolbartop toolbarTop Toolbar {} {} \
    normal {tkiconpane_internalConf}
  $ip_priv(mega)$pathName optionadd \
    -toplevel toplevel Toplevel 0 0 \
    normal {}
  $ip_priv(mega)$pathName optionadd \
    -updateedges updateEdges UpdateEdges 1 1 normal {}

  # global commands
  $ip_priv(mega)$pathName minoradd \
    edgeconf {tkiconpane_minorEdgeConfig}
  $ip_priv(mega)$pathName minoradd \
    edgeconfig {tkiconpane_minorEdgeConfig}
  $ip_priv(mega)$pathName minoradd \
    edgeconfigure {tkiconpane_minorEdgeConfig}
  $ip_priv(mega)$pathName minoradd \
    edgecreate {tkiconpane_minorEdgeCreate}
  $ip_priv(mega)$pathName minoradd \
    edgedelete {tkiconpane_minorEdgeDelete}
  $ip_priv(mega)$pathName minoradd \
    edgeinfo {tkiconpane_minorEdgeInfo}
  $ip_priv(mega)$pathName minoradd \
    iconconf {tkiconpane_minorIconConfig}
  $ip_priv(mega)$pathName minoradd \
    iconconfig {tkiconpane_minorIconConfig}
  $ip_priv(mega)$pathName minoradd \
    iconconfigure {tkiconpane_minorIconConfig}
  $ip_priv(mega)$pathName minoradd \
    iconcreate {tkiconpane_minorIconCreate}
  $ip_priv(mega)$pathName minoradd \
    icondelete {tkiconpane_minorIconDelete}
  $ip_priv(mega)$pathName minoradd \
    iconinfo {tkiconpane_minorIconInfo}
  $ip_priv(mega)$pathName minoradd \
    layout {tkiconpane_minorLayout}
  $ip_priv(mega)$pathName minoradd \
    postscript {tkiconpane_minorPostscript}
  $ip_priv(mega)$pathName minoradd \
    save {tkiconpane_minorSave}
  $ip_priv(mega)$pathName minoradd \
    status {tkiconpane_minorStatus}
  $ip_priv(mega)$pathName minoradd \
    internal {tkiconpane_minorInternal}
  $ip_priv(mega)$pathName minoradd \
    canvas {tkiconpane_minorCanvas}

  # create the widget structure
  frame $pathName.xfcanvas \
    -borderwidth 2 \
    -relief groove

  frame $pathName.xfcanvas.xfcanvas \
    -borderwidth 0

  frame $pathName.xfcanvas.xfcanvas.xfscrolly \
    -borderwidth 0

  frame $pathName.xfcanvas.xfcanvas.xfscrolly.xfoffset \
    -borderwidth 0 \
    -geometry 17x17

  scrollbar $pathName.xfcanvas.xfcanvas.xfscrolly.xfscrolly \
    -borderwidth 1 \
    -command "$pathName.xfcanvas.xfcanvas.xfcanvas yview" \
    -relief sunken \
    -width 15

  scrollbar $pathName.xfcanvas.xfcanvas.xfscrollx \
    -borderwidth 1 \
    -command "$pathName.xfcanvas.xfcanvas.xfcanvas xview" \
    -orient horizontal \
    -relief sunken \
    -width 15

  canvas $pathName.xfcanvas.xfcanvas.xfcanvas \
    -borderwidth 1 \
    -confine {true} \
    -height 2 \
    -relief sunken \
    -scrollregion {0c 0c 100c 100c} \
    -width 2 \
    -xscrollcommand "$pathName.xfcanvas.xfcanvas.xfscrollx set" \
    -yscrollcommand "$pathName.xfcanvas.xfcanvas.xfscrolly.xfscrolly set"

  pack $pathName.xfcanvas.xfcanvas.xfscrolly.xfscrolly \
    -side top \
    -fill both \
    -expand 1
  pack $pathName.xfcanvas.xfcanvas.xfscrolly \
    -side right \
    -fill both
  pack $pathName.xfcanvas.xfcanvas.xfcanvas \
    -side top \
    -fill both \
    -expand 1
  pack $pathName.xfcanvas.xfcanvas \
    -side top \
    -fill both \
    -padx 2 \
    -pady 2 \
    -expand 1
  pack $pathName.xfcanvas \
    -side top \
    -fill both \
    -expand 1

  # bindings
  set canvasPath $pathName.xfcanvas.xfcanvas.xfcanvas
  bind $pathName <Map> "# xf ignore me 8
    $pathName internal bind_map"

  bind $canvasPath <Configure> "# xf ignore me 8
    $pathName internal bind_configure"
  bind $canvasPath <Button-1> "# xf ignore me 8
    $pathName internal bind_item_select 0 %W %x %y %X %Y"
  bind $canvasPath <Shift-Button-1> "# xf ignore me 8
    $pathName internal bind_item_select 1 %W %x %y %X %Y"
  bind $canvasPath <Control-Button-1> "# xf ignore me 8
    $pathName internal bind_item_select 1 %W %x %y %X %Y"
  bind $canvasPath <Any-B1-Motion> "# xf ignore me 8
    $pathName internal bind_item_select 10 %W %x %y %X %Y"
  bind $canvasPath <Any-ButtonRelease-1> "# xf ignore me 8
    $pathName internal bind_item_select 11 %W %x %y %X %Y"
  bind $canvasPath <Button-2> "# xf ignore me 8
    $pathName internal bind_item_select 3 %W %x %y %X %Y"
  bind $canvasPath <Control-Button-2> "# xf ignore me 8
    $pathName internal bind_item_select 4 %W %x %y %X %Y"
  bind $canvasPath <Any-B2-Motion> "# xf ignore me 8
    $pathName internal bind_item_select 10 %W %x %y %X %Y"
  bind $canvasPath <Any-ButtonRelease-2> "# xf ignore me 8
    $pathName internal bind_item_select 11 %W %x %y %X %Y"
  bind $canvasPath <Button-3> "# xf ignore me 8
    $pathName internal bind_menu_post %x %y %X %Y 1"
  bind $canvasPath <Meta-Button-3> "# xf ignore me 8
    $pathName internal bind_menu_post %x %y %X %Y 2"
  bind $canvasPath <Control-Button-3> "# xf ignore me 8
    $pathName internal bind_menu_post %x %y %X %Y 3"

  $canvasPath bind all <Any-Enter> "# xf ignore me 8
    $pathName internal bind_item_enter current"
  $canvasPath bind all <Any-Leave> "# xf ignore me 8
    $pathName internal bind_item_enter"

  # initialize the data
  $ip_priv(mega)$pathName interpset \
    ip_priv(currentPane) $pathName
  $ip_priv(mega)$pathName config \
    -canvaspath $canvasPath

  if {![string compare "mega" $ip_priv(mega)]} {
    # make some shortcuts for often used commands.
    proc $pathName args "catch \{eval $ip_priv(mega)$pathName interpeval $pathName \$args\} result; return \$result"
    proc $pathName.xfcanvas.xfcanvas.xfcanvas args "catch \{eval $ip_priv(mega)$pathName interpeval $pathName.xfcanvas.xfcanvas.xfcanvas \$args\} result; return \$result"
  }
}

proc tkiconpane_minorCanvas {pathName args} {# xf ignore me 8
  global ip_priv

  if {"$args" == ""} {
    return $pathName.xfcanvas.xfcanvas.xfcanvas
  } {
    eval $pathName.xfcanvas.xfcanvas.xfcanvas $args
  }
}

proc tkiconpane_minorEdgeConfig {pathName args} {# xf ignore me 8
  global ip_priv

  set result ""
  set canvasPath $pathName.xfcanvas.xfcanvas.xfcanvas
  if {[llength $args] == 2} {
    if {![string compare [lindex [$canvasPath itemconfig [lindex $args 1] -graphname] 4] [lindex $args 0]]} {
      return [$canvasPath itemconfig [lindex $args 1]]
    }
  } {
    if {[llength $args] == 3} {
      if {[string match "-*" [lindex $args 1]]} {
        foreach counter [$canvasPath find all] {
          if {![string compare "edge" [$canvasPath type $counter]] &&
              ![string compare [lindex [$canvasPath itemconfig $counter -graphname] 4] [lindex $args 0]]} {
            $canvasPath itemconfig $counter [lindex $args 1] [lindex $args 2]
          }
        }
      } {
        if {![string compare [lindex [$canvasPath itemconfig [lindex $args 1] -graphname] 4] [lindex $args 0]]} {
          return [$canvasPath itemconfig [lindex $args 1] [lindex $args 2]]
        }
      }
    } {
      if {[llength $args] > 0} {
        if {![string compare [lindex [$canvasPath itemconfig [lindex $args 1] -graphname] 4] [lindex $args 0]]} {
          $canvasPath itemconfig [lindex $args 1] [lindex $args 2] [lindex $args 3]
        }
      }
    }
  }
  return ""
}

proc tkiconpane_minorEdgeCreate {pathName args} {# xf ignore me 8
  global ip_priv

  set result ""
  set canvasPath $pathName.xfcanvas.xfcanvas.xfcanvas
  set graphName [lindex $args 0]
  foreach edgeElement [lrange $args 1 end] {
    set from [lindex $edgeElement 0]
    set to [lindex $edgeElement 1]
    if {[catch "$canvasPath itemconfig $from -name"] ||
        [catch "$canvasPath itemconfig $to -name"]} {
      error "No -from and -to specified"
    }
    switch [lindex $edgeElement 2] {
      {1} {
        set arrowStyle last
      }
      {2} {
        set arrowStyle both
      }
      {3} {
        set arrowStyle first
      }
      {default} {
        set arrowStyle none
      }
    }
    if {[catch "$canvasPath create edge -10 -10 -10 -10 \
          -graphname \{$graphName\} -arrow $arrowStyle \
          -from \{$from\} -to \{$to\} \
          -font \{[$ip_priv(mega)$pathName confhidden -edgefont]\} \
          [lrange $edgeElement 3 end]" edge]} {
      error $edge
    }
    if {[$ip_priv(mega)$pathName confhidden -initialized]} {
      if {[catch "$canvasPath layout item -idlist $edge -edgeorder [$ip_priv(mega)$pathName confvalue -edgeorder] -graphorder [$ip_priv(mega)$pathName confvalue -graphorder]" result]} {
        error $result
      }
    }
    $canvasPath lower $edge
    set currentEdges [lindex [$canvasPath itemconfig $from -edges] 4]
    lappend currentEdges [list $from $to $edge]
    $canvasPath itemconfig $from -edges $currentEdges
    set currentEdges [lindex [$canvasPath itemconfig $to -edges] 4]
    lappend currentEdges [list $from $to $edge]
    $canvasPath itemconfig $to -edges $currentEdges
    lappend result $edge
  }
  return $result
}

proc tkiconpane_minorEdgeDelete {pathName args} {# xf ignore me 8
  global ip_priv

  set canvasPath $pathName.xfcanvas.xfcanvas.xfcanvas
  if {[llength $args] == 0} {
    foreach counter [$canvasPath find all] {
      if {![string compare "edge" [$canvasPath type $counter]]} {
        $canvasPath delete $counter
      }
      if {![string compare "icon" [$canvasPath type $counter]]} {
        $canvasPath itemconfig $counter -edges {}
      }
    }
  } {
    set from ""
    set to ""
    set graphName [lindex $args 0]
    if {[llength $args] == 2} {
      set from [lindex [$canvasPath itemconfig [lindex $args 1] -from] 4]
      set to [lindex [$canvasPath itemconfig [lindex $args 1] -to] 4]
    } {
      if {[llength $args] == 3} {
        set from [lindex $args 1]
        set to [lindex $args 2]
      }
    }
    if {![string compare "" $from] && ![string compare "" $to]} {
      foreach counter [$canvasPath find all] {
        if {![string compare "edge" [$canvasPath type $counter]] &&
            ![string compare $graphName [lindex [$canvasPath itemconfig $counter -graphname] 4]]} {
          set from [lindex [$canvasPath itemconfig $counter -from] 4]
          set to [lindex [$canvasPath itemconfig $counter -to] 4]
          set fromEdges [lindex [$canvasPath itemconfig $from -edges] 4]
          set newFromEdges ""
          set toEdges [lindex [$canvasPath itemconfig $to -edges] 4]
          set newToEdges ""
          foreach edge $fromEdges {
            if {([lindex $edge 0] == $from && [lindex $edge 1] == $to) ||
                ([lindex $edge 0] == $to && [lindex $edge 1] == $from) &&
                ![string compare $graphName [lindex [$canvasPath itemconfig [lindex $edge 2] -graphname] 4]]} {
              catch "$canvasPath delete [lindex $edge 2]"
            } {
              lappend newFromEdges $edge
            }
          }
          $canvasPath itemconfig $from -edges $newFromEdges
          foreach edge $toEdges {
            if {([lindex $edge 0] == $from && [lindex $edge 1] == $to) ||
                ([lindex $edge 0] == $to && [lindex $edge 1] == $from) &&
                ![string compare $graphName [lindex [$canvasPath itemconfig [lindex $edge 2] -graphname] 4]]} {
              catch "$canvasPath delete [lindex $edge 2]"
            } {
              lappend newToEdges $edge
            }
          }
          $canvasPath itemconfig $to -edges $newToEdges
          $canvasPath delete $counter
        }
      }
    } {
      if {[string compare "" $from] && [string compare "" $to]} {
        set fromEdges [lindex [$canvasPath itemconfig $from -edges] 4]
        set newFromEdges ""
        set toEdges [lindex [$canvasPath itemconfig $to -edges] 4]
        set newToEdges ""
        foreach edge $fromEdges {
          if {([lindex $edge 0] == $from && [lindex $edge 1] == $to) ||
              ([lindex $edge 0] == $to && [lindex $edge 1] == $from) &&
              ![string compare $graphName [lindex [$canvasPath itemconfig [lindex $edge 2] -graphname] 4]]} {
            catch "$canvasPath delete [lindex $edge 2]"
          } {
            lappend newFromEdges $edge
          }
        }
        $canvasPath itemconfig $from -edges $newFromEdges
        foreach edge $toEdges {
          if {([lindex $edge 0] == $from && [lindex $edge 1] == $to) ||
              ([lindex $edge 0] == $to && [lindex $edge 1] == $from) &&
              ![string compare $graphName [lindex [$canvasPath itemconfig [lindex $edge 2] -graphName] 4]]} {
            catch "$canvasPath delete [lindex $edge 2]"
          } {
            lappend newToEdges $edge
          }
        }
        $canvasPath itemconfig $to -edges $newToEdges
      }
    }
  }
  return ""
}

proc tkiconpane_minorEdgeInfo {pathName args} {# xf ignore me 8
  global ip_priv

  set result ""
  set canvasPath $pathName.xfcanvas.xfcanvas.xfcanvas
  if {[llength $args] == 1} {
    set selectedEdge [$ip_priv(mega)$pathName confhidden -selectededge]
    if {![string compare "graphs" [lindex $args 0]] ||
        ![string compare "ids" [lindex $args 0]] ||
        ![string compare "names" [lindex $args 0]]} {
      return [$canvasPath edgeinfo [lindex $args 0]]
    } {
      if {![string compare "id" [lindex $args 0]]} {
        return $selectedEdge
      } {
        if {![string compare "name" [lindex $args 0]]} {
          lappend result [lindex [$canvasPath itemconfig $selectedEdge -name] 4]
          return $result
        } {
          if {![string compare "fromtoid" [lindex $args 0]]} {
            foreach counter [$canvasPath iconinfo ids] {
              foreach edge [lindex [$canvasPath itemconfig $counter -edges] 4] {
                if {![string compare $selectedEdge [lindex $edge 2]]} {
                  return [list [lindex $edge 0] [lindex $edge 1]]
                }
              }
            }
          } {
            if {![string compare "fromtoname" [lindex $args 0]]} {
              foreach counter [$canvasPath iconinfo ids] {
                foreach edge [lindex [$canvasPath itemconfig $counter -edges] 4] {
                  if {![string compare $selectedEdge [lindex $edge 2]]} {
                    return [list [lindex [$canvasPath itemconf [lindex $edge 0] -name] 4] [lindex [$canvasPath itemconf [lindex $edge 1] -name] 4]]
                  }
                }
              }
            } {
              if {![string compare "fromtoids" [lindex $args 0]]} {
                foreach counter [$canvasPath find all] {
                  if {![string compare "icon" [$canvasPath type $counter]]} {
                    foreach edge [lindex [$canvasPath itemconfig $counter -edges] 4] {
                      if {[lsearch $result [list [lindex $edge 0] [lindex $edge 1]]] == -1} {
                        lappend result [list [lindex $edge 0] [lindex $edge 1]]
                      }
                    }
                  }
                }
                return $result
              } {
                if {![string compare "fromtonames" [lindex $args 0]]} {
                  foreach counter [$canvasPath find all] {
                    if {![string compare "icon" [$canvasPath type $counter]]} {
                      foreach edge [lindex [$canvasPath itemconfig $counter -edges] 4] {
                        if {[lsearch $result [list [lindex [$canvasPath itemconf [lindex $edge 0] -name] 4] [lindex [$canvasPath itemconf [lindex $edge 1] -name] 4]]] == -1} {
                          lappend result [list [lindex [$canvasPath itemconf [lindex $edge 0] -name] 4] [lindex [$canvasPath itemconf [lindex $edge 1] -name] 4]]
                        }
                      }
                    }
                  }
                  return $result
                }
              }
            }
          }
        }
      }
    }
  } {
    if {[llength $args] == 2} {
      set selectedEdge [$ip_priv(mega)$pathName confhidden -selectededge]
      if {![string compare "ids" [lindex $args 0]] ||
          ![string compare "names" [lindex $args 0]]} {
        return [$canvasPath edgeinfo [lindex $args 0] [lindex $args 1]]
      } {
        if {![string compare "id" [lindex $args 0]]} {
          if {![string compare [lindex [$canvasPath itemconfig $selectedEdge -graphname] 4] [lindex $args 1]]} {
            return $selectedEdge
          }
        } {
          if {![string compare "name" [lindex $args 0]]} {
            if {![string compare [lindex [$canvasPath itemconfig $selectedEdge -graphname] 4] [lindex $args 1]]} {
              lappend result [lindex [$canvasPath itemconfig $selectedEdge -name] 4]
              return $result
            }
          } {
            if {![string compare "fromtoid" [lindex $args 0]]} {
              foreach counter [$canvasPath iconinfo ids] {
                foreach edge [lindex [$canvasPath itemconfig $counter -edges] 4] {
                  if {![string compare [lindex [$canvasPath itemconfig $selectedEdge -graphname] 4] [lindex $args 1]]} {
                    if {![string compare $selectedEdge [lindex $edge 2]]} {
                      return [list [lindex $edge 0] [lindex $edge 1]]
                    }
                  }
                }
              }
            } {
              if {![string compare "fromtoname" [lindex $args 0]]} {
                foreach counter [$canvasPath iconinfo ids] {
                  foreach edge [lindex [$canvasPath itemconfig $counter -edges] 4] {
                    if {![string compare [lindex [$canvasPath itemconfig $selectedEdge -graphname] 4] [lindex $args 1]]} {
                      if {![string compare $selectedEdge [lindex $edge 2]]} {
                        return [list [lindex [$canvasPath itemconf [lindex $edge 0] -name] 4] [lindex [$canvasPath itemconf [lindex $edge 1] -name] 4]]
                      }
                    }
                  }
                }
              } {
                if {![string compare "fromtoids" [lindex $args 0]]} {
                  foreach counter [$canvasPath find all] {
                    if {![string compare "icon" [$canvasPath type $counter]]} {
                      foreach edge [lindex [$canvasPath itemconfig $counter -edges] 4] {
                        if {![string compare [lindex [$canvasPath itemconfig [lindex $edge 2] -graphname] 4] [lindex $args 1]]} {
                          if {[lsearch $result [list [lindex $edge 0] [lindex $edge 1]]] == -1} {
                            lappend result [list [lindex $edge 0] [lindex $edge 1]]
                          }
                        }
                      }
                    }
                  }
                  return $result
                } {
                  if {![string compare "fromtonames" [lindex $args 0]]} {
                    foreach counter [$canvasPath find all] {
                      if {![string compare "icon" [$canvasPath type $counter]]} {
                        foreach edge [lindex [$canvasPath itemconfig $counter -edges] 4] {
                          if {![string compare [lindex [$canvasPath itemconfig [lindex $edge 2] -graphname] 4] [lindex $args 1]]} {
                            if {[lsearch $result [list [lindex [$canvasPath itemconf [lindex $edge 0] -name] 4] [lindex [$canvasPath itemconf [lindex $edge 1] -name] 4]]] == -1} {
                              lappend result [list [lindex [$canvasPath itemconf [lindex $edge 0] -name] 4] [lindex [$canvasPath itemconf [lindex $edge 1] -name] 4]]
                            }
                          }
                        }
                      }
                    }
                    return $result
                  }
                }
              }
            }
          }
        }
      }
    } {
      if {[llength $args] == 3} {
        if {![string compare "id" [lindex $args 0]]} {
          return [$canvasPath edgeinfo [lindex $args 0] [lindex $args 1] [lindex $args 2]]
        } {
          if {![string compare "name" [lindex $args 0]]} {
            if {![string compare [lindex [$canvasPath itemconfig [lindex $args 2] -graphname] 4] [lindex $args 1]]} {
              lappend result [lindex [$canvasPath itemconfig [lindex $args 2] -name] 4]
              return $result
            }
          } {
            if {![string compare "fromtoid" [lindex $args 0]]} {
              foreach counter [$canvasPath iconinfo ids] {
                foreach edge [lindex [$canvasPath itemconfig $counter -edges] 4] {
                  if {![string compare [lindex [$canvasPath itemconfig [lindex $args 2] -graphname] 4] [lindex $args 1]]} {
                    if {![string compare [lindex $args 2] [lindex $edge 2]]} {
                      return [list [lindex $edge 0] [lindex $edge 1]]
                    }
                  }
                }
              }
            } {
              if {![string compare "fromtoname" [lindex $args 0]]} {
                foreach counter [$canvasPath iconinfo ids] {
                  foreach edge [lindex [$canvasPath itemconfig $counter -edges] 4] {
                    if {![string compare [lindex [$canvasPath itemconfig [lindex $args 2] -graphname] 4] [lindex $args 1]]} {
                      if {![string compare [lindex $args 2] [lindex $edge 2]]} {
                        return [list [lindex [$canvasPath itemconf [lindex $edge 0] -name] 4] [lindex [$canvasPath itemconf [lindex $edge 1] -name] 4]]
                      }
                    }
                  }
                }
              }
            }
          }
        }
      } {
        if {[llength $args] == 4} {
          if {![string compare "id" [lindex $args 0]]} {
            return [$canvasPath edgeinfo [lindex $args 0] [lindex $args 1] [lindex $args 2] [lindex $args 3]]
          }
        }
      }
    }
  }
  return ""
}

proc tkiconpane_minorIconConfig {pathName args} {# xf ignore me 8
  global ip_priv

  set result ""
  set canvasPath $pathName.xfcanvas.xfcanvas.xfcanvas
  if {[llength $args] == 1} {
    if {[$ip_priv(mega)$pathName confvalue -compressiconconf]} {
      set tmpResult ""
      lappend tmpResult [$canvasPath itemconfig [lindex $args 0] -name]
      lappend tmpResult [$canvasPath itemconfig [lindex $args 0] -status]
      lappend result $tmpResult
    } {
      lappend result [$canvasPath itemconfig [lindex $args 0]]
    }
    return $result
  } {
    if {[llength $args] == 2} {
      return [$canvasPath itemconfig [lindex $args 0] [lindex $args 1]]
    } {
      if {[llength $args] > 0} {
        eval $canvasPath itemconfig $args
      }
    }
  }
  return ""
}

proc tkiconpane_minorIconCreate {pathName args} {# xf ignore me 8
  global ip_priv

  set icon ""
  if {[llength $args] > 0} {
    set canvasPath $pathName.xfcanvas.xfcanvas.xfcanvas
    set iconName [lindex $args 0]
    if {[llength $args] > 1} {
      set iconParams [lrange $args 1 end]
    } {
      set iconParams ""
    }
    if {[catch "$canvasPath create icon 10 10 -font \{[$ip_priv(mega)$pathName confhidden -iconfont]\} -name \{$iconName\} $iconParams" icon]} {
      error $icon
    }
    if {[$ip_priv(mega)$pathName confhidden -initialized]} {
      tkiconpane_minorLayout $pathName -force 0
    }
  }
  return $icon
}

proc tkiconpane_minorIconDelete {pathName args} {# xf ignore me 8
  global ip_priv

  set canvasPath $pathName.xfcanvas.xfcanvas.xfcanvas
  set iconList [lindex $args 0]
  if {![string compare "" $iconList]} {
    foreach icon [$canvasPath find all] {
      if {![string compare "icon" [$canvasPath type $icon]] ||
          ![string compare "edge" [$canvasPath type $icon]]} {
        $canvasPath delete $icon
      }
    }
  } {
    foreach icon $iconList {
      foreach edge [lindex [$canvasPath itemconfig $icon -edges] 4] {
        $canvasPath delete [lindex $edge 2]
        set result ""
        if {![string compare $icon [lindex $edge 0]]} {
          foreach otherSide [lindex [$canvasPath itemconfig [lindex $edge 1] -edges] 4] {
            if {[string compare $icon [lindex $otherSide 0]] &&
                [string compare $icon [lindex $otherSide 1]]} {
              lappend result $otherSide
            }
          }
          $canvasPath itemconfig [lindex $edge 1] -edges $result
        } {
          if {![string compare $icon [lindex $edge 1]]} {
            foreach otherSide [lindex [$canvasPath itemconfig [lindex $edge 0] -edges] 4] {
              if {[string compare $icon [lindex $otherSide 0]] &&
                  [string compare $icon [lindex $otherSide 1]]} {
                lappend result $otherSide
              }
            }
            $canvasPath itemconfig [lindex $edge 0] -edges $result
          }
        }
      }
      $canvasPath delete $icon
    }
  }
  return ""
}

proc tkiconpane_minorIconInfo {pathName args} {# xf ignore me 8
  global ip_priv

  set result ""
  set canvasPath $pathName.xfcanvas.xfcanvas.xfcanvas
  if {[llength $args] == 1} {
    set selectedIcon [$ip_priv(mega)$pathName confhidden -selectedicon]
    set selectedIconList [$ip_priv(mega)$pathName confhidden -selectediconlist]
    if {![string compare "ids" [lindex $args 0]] ||
        ![string compare "names" [lindex $args 0]]} {
      return [$canvasPath iconinfo [lindex $args 0]]
    } {
      if {![string compare "id" [lindex $args 0]]} {
        return $selectedIcon
      } {
        if {![string compare "name" [lindex $args 0]]} {
          lappend result [lindex [$canvasPath itemconf $selectedIcon -name] 4]
          return $result
        } {
          if {![string compare "state" [lindex $args 0]]} {
            lappend result [lindex [$canvasPath itemconf $selectedIcon -state] 4]
            return $result
          } {
            if {![string compare "status" [lindex $args 0]]} {
              lappend result [lindex [$canvasPath itemconf $selectedIcon -status] 4]
              return $result
            } {
              if {![string compare "tags" [lindex $args 0]]} {
                lappend result [lindex [$canvasPath itemconf $selectedIcon -tags] 4]
                return $result
              } {
                if {![string compare "stateselect" [lindex $args 0]]} {
                  $canvasPath itemconfig $selectedIcon -state selected
                  set tmpList $selectedIconList
                  set tmpPosition [lsearch $tmpList $selectedIcon]
                  if {$tmpPosition == -1} {
                    lappend tmpList $selectedIcon
                    $ip_priv(mega)$pathName confhidden -selectediconlist $tmpList
                  }
                } {
                  if {![string compare "statedeselect" [lindex $args 0]]} {
                    $canvasPath itemconfig $selectedIcon -state normal
                    set tmpList $selectedIconList
                    set tmpPosition [lsearch $tmpList $selectedIcon]
                    if {$tmpPosition != -1} {
                      $ip_priv(mega)$pathName confhidden -selectediconlist [lreplace $tmpList $tmpPosition $tmpPosition]
                    }
                  } {
                    if {![string compare "statetoggle" [lindex $args 0]]} {
                      set tmpState [lindex [$canvasPath itemconfig $selectedIcon -state] 4]
                      set tmpList $selectedIconList
                      set tmpPosition [lsearch $tmpList $selectedIcon]
                      if {![string compare "selected" "$tmpState"]} {
                        $canvasPath itemconfig $selectedIcon -state normal
                        if {$tmpPosition != -1} {
                          $ip_priv(mega)$pathName confhidden -selectediconlist [lreplace $tmpList $tmpPosition $tmpPosition]
                        }
                      } {
                        $canvasPath itemconfig $selectedIcon -state selected
                        if {$tmpPosition == -1} {
                          lappend tmpList $selectedIcon
                          $ip_priv(mega)$pathName confhidden -selectediconlist $tmpList
                        }
                      }
                    } {
                      if {![string compare "selectedids" [lindex $args 0]]} {
                        set tmpIds ""
                        foreach counter $selectedIconList {
                          if {![catch "$canvasPath itemconfig $counter -name"]} {
                            lappend tmpIds $counter
                          }
                        }
                        return $tmpIds
                      } {
                        if {![string compare "selectednames" [lindex $args 0]]} {
                          set tmpNames ""
                          foreach counter $selectedIconList {
                            if {![catch "$canvasPath itemconfig $counter -name"]} {
                              lappend tmpNames [lindex [$canvasPath itemconf $counter -name] 4]
                            }
                          }
                          return $tmpNames
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  } {
    if {[llength $args] == 2} {
      if {![string compare "id" [lindex $args 0]]} {
        return [$canvasPath iconinfo id [lindex $args 1]]
      } {
        if {![string compare "name" [lindex $args 0]]} {
          lappend result [lindex [$canvasPath itemconf [lindex $args 1] -name] 4]
          return $result
        } {
          if {![string compare "state" [lindex $args 0]]} {
            lappend result [lindex [$canvasPath itemconf [lindex $args 1] -state] 4]
            return $result
          } {
            if {![string compare "status" [lindex $args 0]]} {
              lappend result [lindex [$canvasPath itemconf [lindex $args 1] -status] 4]
              return $result
            } {
              if {![string compare "tags" [lindex $args 0]]} {
                lappend result [lindex [$canvasPath itemconf [lindex $args 1] -tags] 4]
                return $result
              } {
                if {![string compare "stateselect" [lindex $args 0]]} {
                  $canvasPath itemconfig [lindex $args 1] -state selected
                  set tmpList [$ip_priv(mega)$pathName confhidden -selectediconlist]
                  set tmpPosition [lsearch $tmpList [$ip_priv(mega)$pathName confhidden -selectedicon]]
                  if {$tmpPosition == -1} {
                    lappend tmpList [lindex $args 1]
                    $ip_priv(mega)$pathName confhidden -selectediconlist $tmpList
                  }
                } {
                  if {![string compare "statedeselect" [lindex $args 0]]} {
                    $canvasPath itemconfig [lindex $args 1] -state normal
                    set tmpList [$ip_priv(mega)$pathName confhidden -selectediconlist]
                    set tmpPosition [lsearch $tmpList [$ip_priv(mega)$pathName confhidden -selectedicon]]
                    if {$tmpPosition != -1} {
                      $ip_priv(mega)$pathName confhidden -selectediconlist [lreplace $tmpList $tmpPosition $tmpPosition]
                    }
                  } {
                    if {![string compare "statetoggle" [lindex $args 0]]} {
                      set tmpState [lindex [$canvasPath itemconfig [lindex $args 1] -state] 4]
                      set tmpList [$ip_priv(mega)$pathName confhidden -selectediconlist]
                      set tmpPosition [lsearch $tmpList [lindex $args 1]]
                      if {"$tmpState" == "selected"} {
                        $canvasPath itemconfig [lindex $args 1] -state normal
                        if {$tmpPosition != -1} {
                          $ip_priv(mega)$pathName confhidden -selectediconlist [lreplace $tmpList $tmpPosition $tmpPosition]
                        }
                      } {
                        $canvasPath itemconfig [lindex $args 1] -state selected
                        if {$tmpPosition == -1} {
                          lappend tmpList [lindex $args 1]
                          $ip_priv(mega)$pathName confhidden -selectediconlist $tmpList
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  return ""
}

proc tkiconpane_minorLayout {pathName args} {# xf ignore me 8
  global ip_priv

  set forceLayout 1
  if {![string compare [lindex $args 0] -force]} {
    if {![string compare [lindex $args 1] 0]} {
      set forceLayout 0
    }
    set args [lrange $args 2 end]
  }
  set partialRelayout 0
  set completeRelayout 0
  set canvasPath $pathName.xfcanvas.xfcanvas.xfcanvas
  if {![string compare "edges" [lindex $args 0]] ||
      ![string compare "2" [lindex $args 0]]} {
    if {[lsearch $args "edges"] != -1} {
      set args [lreplace $args [lsearch $args "edges"] [lsearch $args "edges"]]
    }
    if {[$ip_priv(mega)$pathName confvalue -updateedges]} {
      eval $canvasPath layout edges -edgeorder [$ip_priv(mega)$pathName confvalue -edgeorder] -graphorder [$ip_priv(mega)$pathName confvalue -graphorder] $args
    }
    return
  }
  if {(![$ip_priv(mega)$pathName confhidden -initialized] && !$forceLayout) ||
      ([$ip_priv(mega)$pathName confhidden -iconsmoved] && !$forceLayout) ||
      (![$ip_priv(mega)$pathName confvalue -layout] && !$forceLayout) ||
       ![string compare "" [$ip_priv(mega)$pathName interpeval info commands $canvasPath]]} {
    return
  }
  $ip_priv(mega)$pathName confhidden -iconsmoved 0
  set layoutCommand [$ip_priv(mega)$pathName confvalue -layoutcommand]
  if {![string compare "nolayout" $layoutCommand]} {
    if {[$ip_priv(mega)$pathName confvalue -updateedges]} {
      eval $canvasPath layout edges -edgeorder [$ip_priv(mega)$pathName confvalue -edgeorder] -graphorder [$ip_priv(mega)$pathName confvalue -graphorder] $args
    }
    return
  } {
    set currentScale [$ip_priv(mega)$pathName confvalue -scale]
    $ip_priv(mega)$pathName config -scale 1
    if {![string compare "" [lindex $layoutCommand 0]]} {
      set layoutCommand matrix
    }
    if {![string compare "matrix" [lindex $layoutCommand 0]] ||
        ![string compare "isi" [lindex $layoutCommand 0]] ||
        ![string compare "random" [lindex $layoutCommand 0]] ||
        ![string compare "tree" [lindex $layoutCommand 0]]} {
      set iconwidth [$ip_priv(mega)$pathName confvalue -iconwidth]
      set iconheight [$ip_priv(mega)$pathName confvalue -iconheight]
      set iconspaceh [$ip_priv(mega)$pathName confvalue -iconspaceh]
      set iconspacev [$ip_priv(mega)$pathName confvalue -iconspacev]
      set sortcommand [$ip_priv(mega)$pathName confvalue -sortcommand]
      set computeiconsize [$ip_priv(mega)$pathName confvalue -computeiconsize]
      set canvasstatustag [$ip_priv(mega)$pathName confvalue -canvasstatustag]
      set canvasboxtag [$ip_priv(mega)$pathName confvalue -canvasboxtag]
      if {[string compare "" $canvasstatustag]} {
        $canvasPath delete $canvasstatustag
      }
      if {[string compare "" $canvasboxtag]} {
        $canvasPath delete $canvasboxtag
      }
      $ip_priv(mega)$pathName confinternal \
        -canvasstatustag "" \
        -canvasboxtag ""

      if {[string compare "" $sortcommand] &&
          [string compare "" [$ip_priv(mega)$pathName interpeval info commands $sortcommand]]} {
        eval $canvasPath layout [lindex $layoutCommand 0] \
          -iconwidth $iconwidth -iconheight $iconheight \
          -iconspaceh $iconspaceh -iconspacev $iconspacev \
          -computeiconsize $computeiconsize \
	  -sortcommand $sortcommand \
          -edgeorder [$ip_priv(mega)$pathName confvalue -edgeorder] \
          -graphorder [$ip_priv(mega)$pathName confvalue -graphorder] \
          [lrange $layoutCommand 1 end]
      } {
        eval $canvasPath layout [lindex $layoutCommand 0] \
	  -iconwidth $iconwidth -iconheight $iconheight \
          -iconspaceh $iconspaceh -iconspacev $iconspacev \
          -computeiconsize $computeiconsize \
          -edgeorder [$ip_priv(mega)$pathName confvalue -edgeorder] \
          -graphorder [$ip_priv(mega)$pathName confvalue -graphorder] \
          [lrange $layoutCommand 1 end]
      }
    } {
      eval $layoutCommand $canvasPath $args
    }
    $ip_priv(mega)$pathName config -scale $currentScale
  }
  return ""
}

proc tkiconpane_minorPostscript {pathName args} {# xf ignore me 8
  global ip_priv

  set result ""
  set canvasPath $pathName.xfcanvas.xfcanvas.xfcanvas
  eval $canvasPath postscript $args
}

proc tkiconpane_minorSave {pathName args} {# xf ignore me 8
  global ip_priv

  set result ""
  set canvasPath $pathName.xfcanvas.xfcanvas.xfcanvas
  eval $canvasPath save $args
}

proc tkiconpane_minorStatus {pathName args} {# xf ignore me 8
  global ip_priv

  set statusvariable [$ip_priv(mega)$pathName confvalue -statusvariable]
  if {[string compare "" $statusvariable]} {
    if {[llength $args] == 0} {
      return [$ip_priv(mega)$pathName interpset $statusvariable]
    } {
      $ip_priv(mega)$pathName interpset $statusvariable [lindex $args 0]
    }
  }
  return ""
}

proc tkiconpane_minorInternal {pathName subCommand args} {# xf ignore me 8

  eval tkiconpane_internal_$subCommand $pathName $args
}

proc tkiconpane_internal_bind_configure {pathName} {# xf ignore me 8
  global ip_priv

  if {[$ip_priv(mega)$pathName confhidden -initialized] &&
      [$ip_priv(mega)$pathName confvalue -layoutupdate]} {
    $pathName layout -force 0
  }
}

proc tkiconpane_internal_bind_item_enter {pathName {type ""}} {# xf ignore me 8
  global ip_priv

  set canvasPath $pathName.xfcanvas.xfcanvas.xfcanvas
  if {![string compare $type "current"]} {
    set tmpId [$canvasPath find withtag current]
    set tmpType [$canvasPath type $tmpId] 
    if {![string compare $tmpType "icon"] ||
        ![string compare $tmpType "edge"]} {
      $ip_priv(mega)$pathName confhidden \
        -currentid [$canvasPath find withtag current]
    }
  } {
    $ip_priv(mega)$pathName confhidden \
      -currentid ""
  }
}

proc tkiconpane_internal_bind_item_move_move {pathName canvasPath x y X Y} {# xf ignore me 8
  global ip_priv

  tkiconpane_internalItemSetSelected $pathName
  tkiconpane_internalItemMoveMove $pathName $canvasPath $x $y $X $Y
}

proc tkiconpane_internal_bind_item_move_start {pathName eventType canvasPath x y X Y} {# xf ignore me 8
  global ip_priv

  if {[$ip_priv(mega)$pathName confhidden -eventtype] != 3 &&
      [$ip_priv(mega)$pathName confhidden -eventtype] != 4} {
    $ip_priv(mega)$pathName confhidden -eventtype $eventType
    tkiconpane_internalItemSetSelected $pathName
    if {$eventType == 1} {
      tkiconpane_internalItemDeSelect $pathName 1
    }
    tkiconpane_internalItemMoveStart $pathName $canvasPath $x $y $X $Y
  }
}

proc tkiconpane_internal_bind_item_move_stop {pathName canvasPath x y X Y} {# xf ignore me 8
  global ip_priv

  $ip_priv(mega)$pathName confhidden -clickeval 0
  tkiconpane_internalItemSetSelected $pathName
  tkiconpane_internalItemMoveStop $pathName $canvasPath $x $y $X $Y
  $ip_priv(mega)$pathName confhidden -eventtype -1
}

proc tkiconpane_internal_bind_item_select {pathName eventType canvasPath x y X Y} {# xf ignore me 8
  global ip_priv

  if {![string compare "" [$ip_priv(mega)$pathName confhidden -currentid]]} {
    if {$eventType == 0} {
      $pathName internal bind_item_move_start 1 $canvasPath $x $y $X $Y
    } {
      if {$eventType == 1} {
        $pathName internal bind_item_move_start 2 $canvasPath $x $y $X $Y
      } {
        if {$eventType == 3} {
          $pathName internal bind_item_move_start 3 $canvasPath $x $y $X $Y
        } {
          if {$eventType == 4} {
            $pathName internal bind_item_move_start 4 $canvasPath $x $y $X $Y
          } {
            if {$eventType == 10} {
              $pathName internal bind_item_move_move $canvasPath $x $y $X $Y
            } {
              if {$eventType == 11} {
                $pathName internal bind_item_move_stop $canvasPath $x $y $X $Y
              }
            }
          }
        }
      }
    }
  } {
    if {$eventType == 0} {
      if {[$ip_priv(mega)$pathName confvalue -bindtype] == 1} {
        $ip_priv(mega)$pathName confhidden -clickeval 0
        $ip_priv(mega)$pathName interpset ip_priv(clickCounter) 2
        tkiconpane_internalItemActivate $pathName $x $y
      } {
        if {[$ip_priv(mega)$pathName interpset ip_priv(clickCounter)] == 1} {
          $ip_priv(mega)$pathName confhidden -clickeval 0
          $ip_priv(mega)$pathName interpset ip_priv(clickCounter) 2
          tkiconpane_internalItemActivate $pathName $x $y
        } {
          $ip_priv(mega)$pathName interpset ip_priv(clickCounter) 1
          $ip_priv(mega)$pathName confhidden -clickeval 1
          $ip_priv(mega)$pathName interpeval after \
            [$ip_priv(mega)$pathName confvalue -clickinterval] \
              "set ip_priv(clickCounter) 0"
          $ip_priv(mega)$pathName interpeval tkwait variable ip_priv(clickCounter)
          if {[$ip_priv(mega)$pathName interpset ip_priv(clickCounter)] == 0 && 
              [$ip_priv(mega)$pathName confhidden -clickeval]} {
            $ip_priv(mega)$pathName confhidden -eventtype -1
            tkiconpane_internalItemDeSelect $pathName
            tkiconpane_internalItemSetSelected $pathName
            tkiconpane_internalItemSelect $pathName $x $y
          }
        }
      }
    } {
      if {$eventType == 1} {
        if {[$ip_priv(mega)$pathName confvalue -bindtype] == 1} {
          $ip_priv(mega)$pathName confhidden -clickeval 0
          $ip_priv(mega)$pathName interpset ip_priv(clickCounter) 2
          tkiconpane_internalItemSetSelected $pathName
          tkiconpane_internalItemSelect $pathName $x $y 1
          tkiconpane_internalItemActivate $pathName $x $y
        } {
          if {[$ip_priv(mega)$pathName interpset ip_priv(clickCounter)] == 1} {
            $ip_priv(mega)$pathName confhidden -clickeval 0
            $ip_priv(mega)$pathName interpset ip_priv(clickCounter) 2
            tkiconpane_internalItemSetSelected $pathName
            tkiconpane_internalItemSelect $pathName $x $y 1
            tkiconpane_internalItemActivate $pathName $x $y
          } {
            $ip_priv(mega)$pathName interpset ip_priv(clickCounter) 1
            $ip_priv(mega)$pathName confhidden -clickeval 1
            $ip_priv(mega)$pathName interpeval after \
              [$ip_priv(mega)$pathName confvalue -clickinterval] \
                "set ip_priv(clickCounter) 0"
            $ip_priv(mega)$pathName interpeval tkwait variable ip_priv(clickCounter)
            if {[$ip_priv(mega)$pathName interpset ip_priv(clickCounter)] == 0 && 
                [$ip_priv(mega)$pathName confhidden -clickeval]} {
              $ip_priv(mega)$pathName confhidden -eventtype -1
              tkiconpane_internalItemSetSelected $pathName
              tkiconpane_internalItemSelect $pathName $x $y 1
            }
          }
        }
      } {
        if {$eventType == 3} {
          $ip_priv(mega)$pathName confhidden -eventtype 3
          tkiconpane_internalItemMoveStart $pathName $canvasPath $x $y $X $Y
        } {
          if {$eventType == 10} {
            tkiconpane_internalItemMoveMove $pathName $canvasPath $x $y $X $Y
          } {
            if {$eventType == 11} {
              tkiconpane_internalItemMoveStop $pathName $canvasPath $x $y $X $Y
              $ip_priv(mega)$pathName confhidden -eventtype -1
            }
          }
        }
      }
    }
  }
}

proc tkiconpane_internal_bind_map {pathName} {# xf ignore me 8
  global ip_priv

  if {[$ip_priv(mega)$pathName confhidden -initialized] ||
      "$pathName" == ""} {
    return
  }

  $ip_priv(mega)$pathName config \
    -changed 0
  $ip_priv(mega)$pathName confhidden \
    -initialized 1
}

proc tkiconpane_internal_bind_menu_move {pathName canvasPath X Y} {# xf ignore me 8
  global ip_priv

  tkiconpane_internalMenuMove $pathName $canvasPath $X $Y
}

proc tkiconpane_internal_bind_menu_post {pathName x y X Y menuType} {# xf ignore me 8
  global ip_priv

  tkiconpane_internalMenuPost $pathName $x $y $X $Y $menuType
}

proc tkiconpane_internal_bind_menu_unpost {pathName canvasPath} {# xf ignore me 8
  global ip_priv

  tkiconpane_internalMenuUnpost $pathName $canvasPath
}

proc tkiconpane_internal_drag_drop_receive_iconpane {args} {# xf ignore me 8

  eval tkiconpane_internalDragDropReceiveIconPane $args
}

proc tkiconpane_internal_drag_drop_receive_toolbar {args} {# xf ignore me 8

  eval tkiconpane_internalDragDropReceiveToolbar $args
}

proc tkiconpane_internal_drag_drop_send {pathName args} {# xf ignore me 8

  eval tkiconpane_internalDragDropSend $args
}

proc tkiconpane_internal_drag_drop_token {pathName args} {# xf ignore me 8

  eval tkiconpane_internalDragDropToken $pathName $args
}

proc tkiconpane_internal_setselected {pathName} {

  tkiconpane_internalItemSetSelected $pathName
}

proc tkiconpane_internal_showstatus {pathName name1 name2 op} {# xf ignore me 8
  global ip_priv

  set canvasPath $pathName.xfcanvas.xfcanvas.xfcanvas
  set tmpTag [$ip_priv(mega)$pathName confvalue -canvasstatustag]
  set tmpBoxTag [$ip_priv(mega)$pathName confvalue -canvasboxtag]
  set statusvariable [$ip_priv(mega)$pathName confvalue -statusvariable]
  set background [$ip_priv(mega)$pathName confvalue -background]
  set foreground [$ip_priv(mega)$pathName confvalue -foreground]
  set statusafter [$ip_priv(mega)$pathName confvalue -statusafter]

  if {![string compare "" $tmpTag]} {
    set tmpTag [$canvasPath create text 10 10 -anchor nw]
    $ip_priv(mega)$pathName config -canvasstatustag $tmpTag
    $canvasPath bind $tmpTag <Button-1> "$pathName status {}"
  }
  if {![string compare "" $tmpBoxTag]} {
    set tmpBoxTag [$canvasPath create rectangle 10 10 20 20]
    $ip_priv(mega)$pathName config -canvasboxtag $tmpBoxTag
    $canvasPath bind $tmpBoxTag <Button-1> "$pathName status {}"
  }

  set value [$ip_priv(mega)$pathName interpset $name1]
  if {[string compare "" [string trim $value]]} {
    catch "$canvasPath itemconfig $tmpTag \
      -fill \{$background\}"
    catch "$canvasPath itemconfig $tmpBoxTag \
      -fill \{$foreground\} -outline \{$foreground\} -width 5"
    $canvasPath raise $tmpBoxTag
    $canvasPath raise $tmpTag
  } {
    catch "$canvasPath itemconfig $tmpTag \
      -fill \{$background\}"
    catch "$canvasPath itemconfig $tmpBoxTag \
      -fill \{$background\} -outline \{$background\} -width 0"
    $canvasPath lower $tmpBoxTag
    $canvasPath lower $tmpTag
  }
  $canvasPath coords $tmpTag \
    [$canvasPath canvasx [expr [winfo x $canvasPath]+10]] \
    [$canvasPath canvasy [expr [winfo y $canvasPath]+10]]
  $canvasPath itemconfig $tmpTag \
    -text $value
  eval $canvasPath coords $tmpBoxTag [$canvasPath bbox $tmpTag]

  if {[string compare "" $value] && $statusafter > 0} {
    after $statusafter "$pathName status {}"
  }
}

proc tkiconpane_internalConf {pathName resource oldValue newValue} {# xf ignore me 8
  global ip_priv

  case $resource {
    {-activebackground -activeforeground -cursor -font} {
      $pathName recursiveconf $resource $newValue
      $pathName.xfcanvas.xfcanvas.xfscrolly.xfscrolly config -activeforeground [$ip_priv(mega)$pathName confvalue -scrollactiveforeground]
      $pathName.xfcanvas.xfcanvas.xfscrollx config -activeforeground [$ip_priv(mega)$pathName confvalue -scrollactiveforeground]
    }
    {-scrollactiveforeground} {
      $pathName.xfcanvas.xfcanvas.xfscrolly.xfscrolly config -activeforeground [$ip_priv(mega)$pathName confvalue -scrollactiveforeground]
      $pathName.xfcanvas.xfcanvas.xfscrollx config -activeforeground [$ip_priv(mega)$pathName confvalue -scrollactiveforeground]
    }
    {-scrollbackground} {
      $pathName.xfcanvas.xfcanvas.xfscrolly.xfscrolly config -background [$ip_priv(mega)$pathName confvalue -scrollbackground]
      $pathName.xfcanvas.xfcanvas.xfscrollx config -background [$ip_priv(mega)$pathName confvalue -scrollbackground]
    }
    {-scrollforeground} {
      $pathName.xfcanvas.xfcanvas.xfscrolly.xfscrolly config -foreground [$ip_priv(mega)$pathName confvalue -scrollforeground]
      $pathName.xfcanvas.xfcanvas.xfscrollx config -foreground [$ip_priv(mega)$pathName confvalue -scrollforeground]
    }
    {-background} {
      $pathName recursiveconf $resource $newValue
      if {[string compare "" [$ip_priv(mega)$pathName confvalue -canvasboxtag]]} {
        catch "$pathName.xfcanvas.xfcanvas.xfcanvas itemconfig \
          [$ip_priv(mega)$pathName confvalue -canvasboxtag] \
            -fill \{$newValue\} -outline \{$newValue\}"
      }
      if {[string compare "" [$ip_priv(mega)$pathName confvalue -canvasboxtag]]} {
        catch "$pathName.xfcanvas.xfcanvas.xfcanvas itemconfig \
          [$ip_priv(mega)$pathName confvalue -canvasboxtag] \
            -fill \{$newValue\}"
      }
      $pathName.xfcanvas.xfcanvas.xfscrolly.xfscrolly config -background [$ip_priv(mega)$pathName confvalue -scrollbackground]
      $pathName.xfcanvas.xfcanvas.xfscrollx config -background [$ip_priv(mega)$pathName confvalue -scrollbackground]
    }
    {-foreground} {
      $pathName recursiveconf $resource $newValue
      if {[string compare "" [$ip_priv(mega)$pathName confvalue -canvasboxtag]]} {
        catch "$pathName.xfcanvas.xfcanvas.xfcanvas itemconfig \
          [$ip_priv(mega)$pathName confvalue -canvasboxtag] \
            -fill \{$newValue\}"
      }
      $pathName.xfcanvas.xfcanvas.xfscrolly.xfscrolly config -foreground [$ip_priv(mega)$pathName confvalue -scrollforeground]
      $pathName.xfcanvas.xfcanvas.xfscrollx config -foreground [$ip_priv(mega)$pathName confvalue -scrollforeground]
    }
    {-geometry} {
      set width ""
      set height ""
      scan $newValue "%dx%d" width height
      if {"$width" != ""} {
        $pathName.xfcanvas.xfcanvas.xfcanvas config -width $width
      }
      if {"$height" != ""} {
        $pathName.xfcanvas.xfcanvas.xfcanvas config -height $height
      }
    }
    {-padx -pady} {
      if {[string compare "" [$ip_priv(mega)$pathName interpeval info commands $pathName.xfmenu]]} {
        pack $pathName.xfmenu.xfmenu.xffile \
          $resource $newValue
        pack $pathName.xfmenu.xfmenu.xfhelp \
          $resource $newValue
        pack $pathName.xfmenu.xficons.xfchange \
          $resource $newValue
      }
      pack $pathName.xfcanvas.xfcanvas \
        $resource $newValue
    }

    {-changed} {
      if {[string compare "" [$ip_priv(mega)$pathName interpeval info commands $pathName.xfmenu]]} {
        if {$newValue} {
          catch "$pathName.xfmenu.xficons.xfchange config \
             -activebackground \{[$ip_priv(mega)$pathName confvalue -activebackground]\}"
          catch "$pathName.xfmenu.xficons.xfchange config \
             -activeforeground \{[$ip_priv(mega)$pathName confvalue -activeforeground]\}"
          catch "$pathName.xfmenu.xficons.xfchange config \
             -foreground \{[$ip_priv(mega)$pathName confvalue -foreground]\}"
        } {
          catch "$pathName.xfmenu.xficons.xfchange config \
             -activebackground \{[$ip_priv(mega)$pathName confvalue -background]\}"
          catch "$pathName.xfmenu.xficons.xfchange config \
             -activeforeground \{[$ip_priv(mega)$pathName confvalue -background]\}"
          catch "$pathName.xfmenu.xficons.xfchange config \
             -foreground \{[$ip_priv(mega)$pathName confvalue -background]\}"
        }
      }
    }
    {-dragdrop} {
      catch "blt_drag&drop" result
      if {$newValue == 0 || ![string match "wrong # args:*" $result]} {
        $ip_priv(mega)$pathName confinternal $resource 0
      } {
        blt_drag&drop source $pathName.xfcanvas.xfcanvas.xfcanvas config \
          -button 0 \
          -selftarget true \
          -packagecmd "$pathName internal drag_drop_token" \
          -send all \
          -tokenanchor nw \
          -tokenborderwidth 0
        blt_drag&drop source $pathName.xfcanvas.xfcanvas.xfcanvas handler \
          icon "$pathName internal drag_drop_send"
        blt_drag&drop target $pathName.xfcanvas.xfcanvas.xfcanvas handler \
          icon "$pathName internal drag_drop_receive_iconpane"
      }
    }
    {-edgefont1 -edgefont2 -edgefont3 -edgefont4 -edgefont5} {
      set scale [$ip_priv(mega)$pathName confvalue -scale]
      if {$scale < 1} {
        if {$scale < 0.5} {
          $ip_priv(mega)$pathName confhidden -edgefont  [$ip_priv(mega)$pathName confvalue -edgefont1]
        } {
          $ip_priv(mega)$pathName confhidden -edgefont  [$ip_priv(mega)$pathName confvalue -edgefont2]
        }
      } {
        if {$scale < 2} {
          $ip_priv(mega)$pathName confhidden -edgefont  [$ip_priv(mega)$pathName confvalue -edgefont3]
        } {
          if {$scale > 2 && $scale < 3} {
            $ip_priv(mega)$pathName confhidden -edgefont  [$ip_priv(mega)$pathName confvalue -edgefont4]
          } {
            $ip_priv(mega)$pathName confhidden -edgefont  [$ip_priv(mega)$pathName confvalue -edgefont5]
          }
        }
      }
    }
    {-iconfont1 -iconfont2 -iconfont3 -iconfont4 -iconfont5} {
      set scale [$ip_priv(mega)$pathName confvalue -scale]
      if {$scale < 1} {
        if {$scale < 0.5} {
          $ip_priv(mega)$pathName confhidden -iconfont  [$ip_priv(mega)$pathName confvalue -iconfont1]
        } {
          $ip_priv(mega)$pathName confhidden -iconfont  [$ip_priv(mega)$pathName confvalue -iconfont2]
        }
      } {
        if {$scale < 2} {
          $ip_priv(mega)$pathName confhidden -iconfont  [$ip_priv(mega)$pathName confvalue -iconfont3]
        } {
          if {$scale > 2 && $scale < 3} {
            $ip_priv(mega)$pathName confhidden -iconfont  [$ip_priv(mega)$pathName confvalue -iconfont4]
          } {
            $ip_priv(mega)$pathName confhidden -iconfont  [$ip_priv(mega)$pathName confvalue -iconfont5]
          }
        }
      }
    }
    {-iconheight -iconspaceh -iconspacev -iconwidth} {
      if {[$ip_priv(mega)$pathName confhidden -initialized]} {
        tkiconpane_minorLayout $pathName -force 0
      }
    }
    {-layoutcommand} {
      if {[string compare "" $newValue]} {
        pack $pathName.xfcanvas.xfcanvas.xfscrollx \
          -side bottom \
          -fill both
        pack $pathName.xfcanvas.xfcanvas.xfscrolly.xfoffset \
          -side bottom
      } {
        catch "pack forget $pathName.xfcanvas.xfcanvas.xfscrollx"
        catch "pack forget $pathName.xfcanvas.xfcanvas.xfscrolly.xfoffset"
      }
    }
    {-menu?} {
      if {[string compare "" $newValue] &&
          [string compare "" [string index $newValue 0]] &&
          ![string compare "" [$ip_priv(mega)$pathName interpeval info commands .vmenu-$newValue]]} {
        foreach tmpElement [$ip_priv(mega)$pathName confvalue -menupath] {
          if {[file exists $tmpElement/$newValue.vmn]} {
            catch "source $tmpElement/$newValue.vmn"
            break
          }
        }
      }
    }
    {-menubar} {
      if {![string compare "" [$ip_priv(mega)$pathName interpeval info commands $pathName.xfcanvas]]} {
        return
      }
      if {[string compare "" [$ip_priv(mega)$pathName interpeval info commands $pathName.xfmenu]]} {
        foreach children [$ip_priv(mega)$pathName interpeval winfo children $pathName.xfmenu.xfmenu] {
          catch "destroy $children"
        }
      }
      if {[string compare "" $newValue]} {
        set menupath [$ip_priv(mega)$pathName conf -menupath]
        if {![string compare "" $menupath]} {
          return
        }
        set padx [$ip_priv(mega)$pathName confvalue -pady]
        set pady [$ip_priv(mega)$pathName confvalue -pady]
        if {![string compare "" [$ip_priv(mega)$pathName interpeval info commands $pathName.xfmenu]]} {
          frame $pathName.xfmenu \
            -borderwidth 0

          frame $pathName.xfmenu.xfmenu \
            -borderwidth 2 \
            -relief groove
  
          frame $pathName.xfmenu.xficons \
            -borderwidth 2 \
            -relief groove
  
          button $pathName.xfmenu.xficons.xfchange \
            -anchor c \
            -bitmap warning \
            -borderwidth 0 \
            -command "$pathName config -changed 0" \
            -height 19 \
            -width 19

          pack $pathName.xfmenu.xfmenu \
            -side left \
            -fill both \
            -expand 1
          pack $pathName.xfmenu.xficons.xfchange \
            -side left \
            -padx $padx \
            -pady $pady \
            -fill both
          pack $pathName.xfmenu.xficons \
            -side right \
            -fill both
        }
        set ip_priv(menuBar) $pathName.xfmenu.xfmenu
        foreach element $menupath {
          if {[file exists $element/$newValue.mbr]} {
            source $element/$newValue.mbr
            break
          }
        }
        set traversal "tk_menuBar $pathName.xfmenu.xfmenu "
        foreach children [winfo children $pathName.xfmenu.xfmenu] {
          append traversal "$children "
        }
        catch $traversal
        pack $pathName.xfmenu \
          -before $pathName.xfcanvas.xfcanvas \
          -side top \
          -fill both
      } {
        catch "pack forget $pathName.xfmenu"
      }
    }
    {-menupath} {
      $ip_priv(mega)$pathName conf \
        -menu1 [$ip_priv(mega)$pathName confvalue -menu1]
      $ip_priv(mega)$pathName conf \
        -menu2 [$ip_priv(mega)$pathName confvalue -menu2]
      $ip_priv(mega)$pathName conf \
        -menu3 [$ip_priv(mega)$pathName confvalue -menu3]
      $ip_priv(mega)$pathName conf \
        -menubar [$ip_priv(mega)$pathName confvalue -menubar]
      $ip_priv(mega)$pathName conf \
        -toolbarleft [$ip_priv(mega)$pathName confvalue -toolbarleft]
      $ip_priv(mega)$pathName conf \
        -toolbarright [$ip_priv(mega)$pathName confvalue -toolbarright]
      $ip_priv(mega)$pathName conf \
        -toolbartop [$ip_priv(mega)$pathName confvalue -toolbartop]
      $ip_priv(mega)$pathName conf \
        -toolbarbottom [$ip_priv(mega)$pathName confvalue -toolbarbottom]
    }
    {-scale} {
      if {"$oldValue" != "$newValue"} {
        tkiconpane_internalScale $pathName $oldValue
      }
    }
    {-scrollactiveforeground} {
      $pathName.xfcanvas.xfcanvas.xfscrolly.xfscrolly conf \
        -activeforeground $newValue
      $pathName.xfcanvas.xfcanvas.xfscrollx conf \
        -activeforeground $newValue
    }
    {-scrollside} {
      pack $pathName.xfcanvas.xfcanvas.xfscrolly \
        -side $newValue \
        -fill both
    }
    {-statusvariable} {
      if {[string compare "" $newValue]} {
        bind $pathName <Destroy> "# xf ignore me 9
          unset $newValue"
        catch "$ip_priv(mega)$pathName interpeval unset $oldValue"
        catch "$ip_priv(mega)$pathName interpset $newValue \"\""
        catch "$ip_priv(mega)$pathName interpeval trace vdelete $oldValue w \"$pathName internal showstatus \""
        catch "$ip_priv(mega)$pathName interpeval trace variable $newValue w \"$pathName internal showstatus\""
        catch "$ip_priv(mega)$pathName interpset $newValue \"\""
      }
    }
    {-title} {
      wm title [winfo toplevel $pathName] $newValue
    }
    {-tkiconlib} {
      catch "$ip_priv(mega)$pathName interpset tkicon_lib($pathName.xfcanvas.xfcanvas.xfcanvas) \{$newValue\}"
    }
    {-toolbar*} {
      if {![string compare "" [$ip_priv(mega)$pathName interpeval info commands $pathName.xfcanvas]]} {
        return
      }
      set side [string range $resource 8 end]
      if {[string compare "" [$ip_priv(mega)$pathName interpeval info commands $pathName.xfcanvas.xftoolbar$side]]} {
        foreach children [winfo children $pathName.xfcanvas.xftoolbar$side] {
          catch "destroy $children"
        }
      }
      if {[string compare "" $newValue]} {
        set menupath [$ip_priv(mega)$pathName confvalue -menupath]
        if {![string compare "" $menupath]} {
          return
        }
        set padx [$ip_priv(mega)$pathName confvalue -pady]
        set pady [$ip_priv(mega)$pathName confvalue -pady]
        if {"$side" == "left" || "$side" == "right"} {
          set buttonside top
          set revbuttonside button
        } {
          set buttonside left
          set revbuttonside right
        }
        if {![string compare "" [$ip_priv(mega)$pathName interpeval info commands $pathName.xfcanvas.xftoolbar$side]]} {
          frame $pathName.xfcanvas.xftoolbar$side \
            -borderwidth 2 \
            -relief groove
        }
        set ip_priv(toolBar) $pathName.xfcanvas.xftoolbar$side
        foreach element $menupath {
          if {[file exists $element/$newValue.tbr]} {
            source $element/$newValue.tbr
            break
          }
        }
        pack $pathName.xfcanvas.xftoolbar$side \
          -before $pathName.xfcanvas.xfcanvas \
          -side $side \
          -fill both
      } {
        catch "pack forget $pathName.xfcanvas.xftoolbar$side"
      }
    }
  }
  return ""
}

proc tkiconpane_internalDragDropReceiveIconPane {pathName} {# xf ignore me 8
  global ip_priv

  if {![$ip_priv(mega)$pathName confvalue -dragdrop]} {
    return
  }
  set canvasPath $pathName.xfcanvas.xfcanvas.xfcanvas
  set dropCommand ""
  set targetId ""
  set tmpPosition [$ip_priv(mega)$pathName interpeval blt_drag&drop location]
  set tmpX [$canvasPath canvasx [expr [lindex $tmpPosition 0]-[winfo rootx $canvasPath]]]
  set tmpY [$canvasPath canvasy [expr [lindex $tmpPosition 1]-[winfo rooty $canvasPath]]]
  set targetId [$canvasPath find closest $tmpX $tmpY]

  if {[string compare "" $targetId]} {
    set tmpBbox [$canvasPath bbox $targetId]
    if {$tmpX < [lindex $tmpBbox 0] || $tmpX > [lindex $tmpBbox 2] ||
        $tmpY < [lindex $tmpBbox 1] || $tmpY > [lindex $tmpBbox 3]} {
      set targetId ""
    }
  }
  if {[string compare "" $targetId]} {
    if {![string compare "icon" [$canvasPath type $targetId]]} {
      set dropCommand [lindex [$canvasPath itemconfig $targetId -dropcommand] 4]
    } {
      set targetId ""
    }
  } {
    set dropCommand [$ip_priv(mega)$pathName confvalue -dropcommand]
  }

  set DragDrop(iconInterpreter) [$ip_priv(mega)$pathName \
    interpset DragDrop(iconInterpreter)]
  set DragDrop(iconPath) [$ip_priv(mega)$pathName \
    interpset DragDrop(iconPath)]
  set DragDrop(iconDragMode) [$ip_priv(mega)$pathName \
    interpset DragDrop(iconDragMode)]
  set DragDrop(iconIds) [$ip_priv(mega)$pathName \
    interpset DragDrop(iconIds)]

  if {[string compare "" $dropCommand]} {
    if {[catch "$ip_priv(mega)$pathName interpeval $dropCommand \{$DragDrop(iconInterpreter)\} \{$DragDrop(iconPath)\} \{$DragDrop(iconIds)\} \{$DragDrop(iconDragMode)\} \{$pathName\} \{$targetId\}" result]} {
      error $result
    }
  } {
    if {![string compare $pathName $ip_priv(drag&dropPath)] &&
        ![string compare "" $targetId] &&
        [$ip_priv(mega)$pathName confvalue -placing]} {
      set tmpPos [tkiconpane_dropPosition $pathName]
      $ip_priv(mega)$pathName iconconfig $ip_priv(drag&dropIconId) \
        -x [lindex $tmpPos 0] \
        -y [lindex $tmpPos 1]
      if {[$ip_priv(mega)$pathName confvalue -updateedges]} {
        $canvasPath layout edges -edgeorder [$ip_priv(mega)$pathName confvalue -edgeorder] -graphorder [$ip_priv(mega)$pathName confvalue -graphorder]
      }
    }
  }
  return
}

proc tkiconpane_internalDragDropReceiveToolbar {pathName receivePath dropCommand} {# xf ignore me 8
  global ip_priv

  if {![$ip_priv(mega)$pathName confvalue -dragdrop]} {
    return
  }
  set canvasPath $pathName.xfcanvas.xfcanvas.xfcanvas

  set DragDrop(iconInterpreter) [$ip_priv(mega)$pathName \
    interpset DragDrop(iconInterpreter)]
  set DragDrop(iconPath) [$ip_priv(mega)$pathName \
    interpset DragDrop(iconPath)]
  set DragDrop(iconDragMode) [$ip_priv(mega)$pathName \
    interpset DragDrop(iconDragMode)]
  set DragDrop(iconIds) [$ip_priv(mega)$pathName \
    interpset DragDrop(iconIds)]

  if {[catch "$ip_priv(mega)$pathName interpeval $dropCommand \{$DragDrop(iconInterpreter)\} \{$DragDrop(iconPath)\} \{$DragDrop(iconIds)\} \{$DragDrop(iconDragMode)\} \{$receivePath\}" result]} {
    error $result
  }
  return
}

proc tkiconpane_internalDragDropSend {interp ddwin data} {# xf ignore me 8
  global ip_priv

  set path [lindex $data 0]
  set dragMode [lindex $data 1]
  set ids [lindex $data 2]
  send $interp "
    global DragDrop
    set DragDrop(iconInterpreter) \{[winfo name .]\}
    set DragDrop(iconPath) \{$path\}
    set DragDrop(iconDragMode) \{$dragMode\}
    set DragDrop(iconIds) \{$ids\}"
  send $interp "blt_drag&drop target $ddwin handle icon"
}

proc tkiconpane_internalDragDropToken {pathName dragPathName} {# xf ignore me 8
  global ip_priv

  set canvasPath $pathName.xfcanvas.xfcanvas.xfcanvas
  if {[string compare "" [$ip_priv(mega)$pathName confhidden -selectedicon]]} {
    set tmpIcon [$ip_priv(mega)$pathName confhidden -selectedicon]
  } {
    set tmpIcon [$ip_priv(mega)$pathName confhidden -currentid]
  }
  if {[string compare "" $tmpIcon]} {
    if {![string compare "" [$ip_priv(mega)$pathName interpeval info commands $dragPathName.canvas]]} {
      canvas $dragPathName.canvas
      foreach option [$canvasPath config] {
        if {[llength $option] == 5 &&
            [string compare "-confine" [lindex $option 0]] &&
            [string compare "-width" [lindex $option 0]] &&
            [string compare "-height" [lindex $option 0]] &&
            [string compare "-scrollregion" [lindex $option 0]] &&
            [string compare "-xscrollcommand" [lindex $option 0]] &&
            [string compare "-yscrollcommand" [lindex $option 0]] &&
            [string compare [lindex $option 3] [lindex $option 4]]} {
          $dragPathName.canvas config [lindex $option 0] [lindex $option 4]
        }
      }
      $dragPathName.canvas config -borderwidth 0
      pack append $dragPathName $dragPathName.canvas {top fill expand}

      $ip_priv(mega)$pathName confhidden -dragdropicon \
        [$dragPathName.canvas create icon 0 0]
    }
    foreach option [$canvasPath itemconfig $tmpIcon] {
      if {[llength $option] == 5 &&
          (![string compare "-background" [lindex $option 0]] ||
           ![string compare "-borderwidth" [lindex $option 0]] ||
           ![string compare "-bitmap" [lindex $option 0]] ||
           ![string compare "-mask" [lindex $option 0]] ||
           ![string compare "-font" [lindex $option 0]] ||
           ![string compare "-foreground" [lindex $option 0]] ||
           ![string compare "-foreground" [lindex $option 0]] ||
           ![string compare "-relief" [lindex $option 0]] ||
           ![string compare "-state" [lindex $option 0]] ||
           ![string compare "-status" [lindex $option 0]] ||
           ![string compare "-statusbitmap" [lindex $option 0]] ||
           ![string compare "-statusmask" [lindex $option 0]] ||
           ![string compare "-textanchor" [lindex $option 0]] ||
           ![string compare "-text" [lindex $option 0]] ||
           ![string compare "-width" [lindex $option 0]])} {
        $dragPathName.canvas itemconfig [$ip_priv(mega)$pathName confhidden -dragdropicon] \
          [lindex $option 0] [lindex $option 4]
      }
    }
    set bbox [$canvasPath bbox $tmpIcon]
    $dragPathName.canvas config \
      -height [expr [lindex $bbox 3]-[lindex $bbox 1]] \
      -width [expr [lindex $bbox 2]-[lindex $bbox 0]]
    return [list $pathName copy $tmpIcon]
  } {
    error "No icon"
  }
}

proc tkiconpane_internalItemActivate {pathName x y} {# xf ignore me 8
  global ip_priv

  set canvasPath $pathName.xfcanvas.xfcanvas.xfcanvas
  if {[string compare "" [$ip_priv(mega)$pathName confhidden -selectediconlist]] && [lsearch [$ip_priv(mega)$pathName confhidden -selectediconlist] [$ip_priv(mega)$pathName confhidden -currentid]] != -1} {
    foreach counter [$ip_priv(mega)$pathName confhidden -selectediconlist] {
      set tmpCommand [lindex [$canvasPath itemconfig $counter -command] 4]
      if {[string compare "" $tmpCommand]} {
        if {[catch "$tmpCommand $counter" result]} {
           puts stderr $result
        }
      }
    }
  } {
    set counter [$ip_priv(mega)$pathName confhidden -currentid]
    if {![string compare [$canvasPath type $counter] "icon"]} {
      set tmpCommand [lindex [$canvasPath itemconfig $counter -command] 4]
      if {[string compare "" $tmpCommand]} {
        if {[catch "$tmpCommand $counter" result]} {
          puts stderr $result
        }
      }      
    }
  }
}

proc tkiconpane_internalItemDeSelect {pathName {canvasDesel 0}} {# xf ignore me 8
  global ip_priv

  set canvasPath $pathName.xfcanvas.xfcanvas.xfcanvas
  if {!$canvasDesel ||
      ![string compare "" [$ip_priv(mega)$pathName confhidden -selectedid]]} {
    foreach counter [$ip_priv(mega)$pathName confhidden -selectediconlist] {
      $canvasPath itemconfig $counter -state normal
    }
    foreach counter [$ip_priv(mega)$pathName confhidden -selectededgelist] {
      $canvasPath itemconfig $counter -state normal
    }
    $ip_priv(mega)$pathName confhidden -selectediconlist ""
    $ip_priv(mega)$pathName confhidden -selectededgelist ""
  }
}

proc tkiconpane_internalItemMoveMove {pathName w x y X Y} {# xf ignore me 8
  global ip_priv

  set canvasPath $pathName.xfcanvas.xfcanvas.xfcanvas
  if {[string compare "" [$ip_priv(mega)$pathName confhidden -moveitems]] &&
      [$ip_priv(mega)$pathName confhidden -eventtype] == 3} {
    if {[$ip_priv(mega)$pathName confvalue -dragdrop]} {
      $ip_priv(mega)$pathName interpeval blt_drag&drop drag $w $X $Y
      return
    }
    if {[string compare "" [$ip_priv(mega)$pathName confhidden -moveitems]]} {
      foreach counter [$ip_priv(mega)$pathName confhidden -moveitems] {
        $canvasPath move $counter [expr [$canvasPath canvasx $x]-[$ip_priv(mega)$pathName confhidden -x]] [expr [$canvasPath canvasy $y]-[$ip_priv(mega)$pathName confhidden -y]]
        set newX [lindex [$canvasPath coords $counter] 0]
        if {$newX < 0} {
          set newX 0
        }
        set newY [lindex [$canvasPath coords $counter] 1]
        if {$newY < 0} {
          set newY 0
        }
        $canvasPath coords $counter $newX $newY
      }
    }
    $ip_priv(mega)$pathName confhidden \
      -x [$canvasPath canvasx $x]
    $ip_priv(mega)$pathName confhidden \
      -y [$canvasPath canvasy $y]
  } {
    if {([$ip_priv(mega)$pathName confhidden -eventtype] == 1 ||
         [$ip_priv(mega)$pathName confhidden -eventtype] == 2 ||
         [$ip_priv(mega)$pathName confhidden -eventtype] == 4)} {
      $ip_priv(mega)$pathName confhidden \
        -stretchx [$canvasPath canvasx $x]
      $ip_priv(mega)$pathName confhidden \
        -stretchy [$canvasPath canvasy $y]
      $canvasPath coords [$ip_priv(mega)$pathName confhidden -stretch] [$ip_priv(mega)$pathName confhidden -stretchxroot] [$ip_priv(mega)$pathName confhidden -stretchyroot] [$ip_priv(mega)$pathName confhidden -stretchx] [$ip_priv(mega)$pathName confhidden -stretchy]
    } {
      if {[$ip_priv(mega)$pathName confhidden -eventtype] == 3} {
        $canvasPath scan dragto $x $y
      }
    }
  }
}

proc tkiconpane_internalItemMoveStart {pathName w x y X Y} {# xf ignore me 8
  global ip_priv

  set canvasPath $pathName.xfcanvas.xfcanvas.xfcanvas
  if {[string compare "" [$ip_priv(mega)$pathName confhidden -currentid]]} {
    if {![string compare "icon" [$canvasPath type [$ip_priv(mega)$pathName confhidden -currentid]]] &&
        [$ip_priv(mega)$pathName confhidden -eventtype] == 3} {
      if {[string compare "" [$ip_priv(mega)$pathName confhidden -selectedicon]] && [lsearch [$ip_priv(mega)$pathName confhidden -selectedicon] [$ip_priv(mega)$pathName confhidden -currentid]] != -1} {
        set tmpIcon [$ip_priv(mega)$pathName confhidden -selectedicon]
      } {
        set tmpIcon [$ip_priv(mega)$pathName confhidden -currentid]
      }
      if {[$ip_priv(mega)$pathName confvalue -dragdrop]} {
        $ip_priv(mega)$pathName confhidden -dragdrophideicon [list $tmpIcon [lindex [$canvasPath itemconfig $tmpIcon -x] 4] [lindex [$canvasPath itemconfig $tmpIcon -y] 4]]
        $canvasPath itemconfig $tmpIcon -x -1000 -y -1000
        $ip_priv(mega)$pathName interpeval blt_drag&drop drag $w $X $Y
        $ip_priv(mega)$pathName confhidden \
          -moveitems $tmpIcon
        return
      }
      $ip_priv(mega)$pathName confhidden \
        -startx [$canvasPath canvasx $x]
      $ip_priv(mega)$pathName confhidden \
        -starty [$canvasPath canvasy $y]
      $ip_priv(mega)$pathName confhidden \
        -x [$canvasPath canvasx $x]
      $ip_priv(mega)$pathName confhidden \
        -y [$canvasPath canvasy $y]
      $ip_priv(mega)$pathName confhidden \
        -moveitems ""
      set tmpIds ""
      foreach counter [$ip_priv(mega)$pathName confhidden -selectediconlist] {
        if {![catch "$canvasPath itemconfig $counter -name"]} {
          $canvasPath raise $counter
          set tmpIds [$ip_priv(mega)$pathName confhidden -moveitems]
          lappend tmpIds $counter
          $ip_priv(mega)$pathName confhidden \
            -moveitems $tmpIds
        }
      }
      if {![string compare "" [$ip_priv(mega)$pathName confhidden -moveitems]] ||
          [lsearch $tmpIds [$ip_priv(mega)$pathName confhidden -currentid]] == -1} {
        $ip_priv(mega)$pathName confhidden -moveitems $tmpIcon
        $canvasPath raise $tmpIcon
      }
    }
  } {
    if {([$ip_priv(mega)$pathName confhidden -eventtype] == 1 ||
         [$ip_priv(mega)$pathName confhidden -eventtype] == 2 ||
         [$ip_priv(mega)$pathName confhidden -eventtype] == 4)} {
      if {[string compare "" [$ip_priv(mega)$pathName confhidden -stretch]]} {
        $canvasPath delete [$ip_priv(mega)$pathName confhidden -stretch]
      }
      $ip_priv(mega)$pathName confhidden \
        -stretchxroot [$canvasPath canvasx $x]
      $ip_priv(mega)$pathName confhidden \
        -stretchyroot [$canvasPath canvasy $y]
      $ip_priv(mega)$pathName confhidden \
        -stretchx [$canvasPath canvasx $x]
      $ip_priv(mega)$pathName confhidden \
        -stretchy [$canvasPath canvasy $y]
      $ip_priv(mega)$pathName confhidden \
        -stretch [$canvasPath create rectangle [$ip_priv(mega)$pathName confhidden -stretchxroot] [$ip_priv(mega)$pathName confhidden -stretchyroot] [$ip_priv(mega)$pathName confhidden -stretchx] [$ip_priv(mega)$pathName confhidden -stretchy]]
    } {
      if {[$ip_priv(mega)$pathName confhidden -eventtype] == 3} {
        $canvasPath scan mark $x $y
      }
    }
  }
}

proc tkiconpane_internalItemMoveStop {pathName w x y X Y} {# xf ignore me 8
  global ip_priv

  $ip_priv(mega)$pathName confhidden -iconsmoved 1
  set canvasPath $pathName.xfcanvas.xfcanvas.xfcanvas
  if {[string compare "" [$ip_priv(mega)$pathName confhidden -moveitems]] &&
      [$ip_priv(mega)$pathName confhidden -eventtype] == 3} {
    if {[$ip_priv(mega)$pathName confvalue -dragdrop]} {
      if {[string compare "" [$ip_priv(mega)$pathName confhidden -dragdrophideicon]]} {
        $canvasPath itemconfig [lindex [$ip_priv(mega)$pathName confhidden -dragdrophideicon] 0] -x [lindex [$ip_priv(mega)$pathName confhidden -dragdrophideicon] 1] -y [lindex [$ip_priv(mega)$pathName confhidden -dragdrophideicon] 2]
      }
      $ip_priv(mega)$pathName confhidden -dragdrophideicon ""
      $ip_priv(mega)$pathName interpeval blt_drag&drop drop $w $X $Y
      $ip_priv(mega)$pathName confhidden -moveitems ""
      return
    }
    if {![$ip_priv(mega)$pathName confvalue -placing]} {
      if {[string compare "" [$ip_priv(mega)$pathName confhidden -moveitems]]} {
        foreach counter [$ip_priv(mega)$pathName confhidden -moveitems] {
          $canvasPath move $counter [expr [$canvasPath canvasx [$ip_priv(mega)$pathName confhidden -startx]]-[$ip_priv(mega)$pathName confhidden -x]] [expr [$canvasPath canvasy [$ip_priv(mega)$pathName confhidden -starty]]-[$ip_priv(mega)$pathName confhidden -y]]
          set newX [lindex [$canvasPath coords $counter] 0]
          if {$newX < 0} {
            set newX 0
          }
          set newY [lindex [$canvasPath coords $counter] 1]
          if {$newY < 0} {
            set newY 0
          }
          $canvasPath coords $counter $newX $newY
        }
      }
    } {
      if {[string compare "" [$ip_priv(mega)$pathName confhidden -moveitems]]} {
        set fuzzy [$ip_priv(mega)$pathName confvalue -movefuzzy]
        if {$fuzzy > 0 &&
            [expr abs(([$ip_priv(mega)$pathName confhidden -x]) - \
                  abs([$ip_priv(mega)$pathName confhidden -startx]))] < $fuzzy &&
            [expr abs(abs([$ip_priv(mega)$pathName confhidden -y]) - \
                  abs([$ip_priv(mega)$pathName confhidden -starty]))] < $fuzzy} {
          foreach counter [$ip_priv(mega)$pathName confhidden -moveitems] {
            $canvasPath move $counter [expr [$canvasPath canvasx [$ip_priv(mega)$pathName confhidden -startx]]-[$ip_priv(mega)$pathName confhidden -x]] [expr [$canvasPath canvasy [$ip_priv(mega)$pathName confhidden -starty]]-[$ip_priv(mega)$pathName confhidden -y]]
            set newX [lindex [$canvasPath coords $counter] 0]
            if {$newX < 0} {
              set newX 0
            }
            set newY [lindex [$canvasPath coords $counter] 1]
            if {$newY < 0} {
              set newY 0
            }
            $canvasPath coords $counter $newX $newY
          }
        }
        foreach counter [$ip_priv(mega)$pathName confhidden -moveitems] {
          foreach edge [lindex [$canvasPath itemconfig $counter -edges] 4] {
            if {![string compare $counter [lindex $edge 0]] ||
                ![string compare $counter [lindex $edge 1]]} {
              $canvasPath layout item -idlist [lindex $edge 2] -edgeorder [$ip_priv(mega)$pathName confvalue -edgeorder] -graphorder [$ip_priv(mega)$pathName confvalue -graphorder]
            }
          }
        }
      }
    }
    $ip_priv(mega)$pathName confhidden -moveitems ""
  } {
    if {[string compare "" [$ip_priv(mega)$pathName confhidden -stretch]]} {
      if {[$ip_priv(mega)$pathName confhidden -eventtype] == 4} {
        set oldscale [$ip_priv(mega)$pathName confvalue -scale]
        set canvasstatustag [$ip_priv(mega)$pathName confvalue -canvasstatustag] 
        set canvasboxtag [$ip_priv(mega)$pathName confvalue -canvasboxtag]
        $ip_priv(mega)$pathName confinternal \
          -canvasstatustag "" \
          -canvasboxtag ""
        if {"$canvasstatustag" != ""} {
          $canvasPath delete $canvasstatustag
        }
        if {"$canvasboxtag" != ""} {
          $canvasPath delete $canvasboxtag
        }
        set bbox1 [$canvasPath bbox [$ip_priv(mega)$pathName confhidden -stretch]]
        set bbox2 [$canvasPath bbox all]
        set xscale [expr ([lindex $bbox2 2]-[lindex $bbox2 0].0)/ \
                         ([lindex $bbox1 2]-[lindex $bbox1 0].0)]
        set yscale [expr ([lindex $bbox2 3]-[lindex $bbox2 1].0)/ \
                         ([lindex $bbox1 3]-[lindex $bbox1 1].0)]
        if {$xscale > $yscale} {
          set scale $yscale
        } {
          set scale $xscale
        }
        if {$scale <= 0} {
          set scale 1
        }
        $ip_priv(mega)$pathName confinternal -scale $scale
        set originX [$ip_priv(mega)$pathName confhidden -stretchxroot]
        set originY [$ip_priv(mega)$pathName confhidden -stretchyroot]
        set closest [$canvasPath find closest $originX $originY]
        tkiconpane_internalScale $pathName $oldscale
        set bbox1 [$canvasPath bbox $closest]
        $canvasPath xview [expr ([lindex $bbox1 0]/10)]
        $canvasPath yview [expr ([lindex $bbox1 1]/10)]
      } {
        if {[$ip_priv(mega)$pathName confhidden -eventtype] == 1 ||
            [$ip_priv(mega)$pathName confhidden -eventtype] == 2} {
          foreach counter [$canvasPath find enclosed [$ip_priv(mega)$pathName confhidden -stretchxroot] [$ip_priv(mega)$pathName confhidden -stretchyroot] [$ip_priv(mega)$pathName confhidden -stretchx] [$ip_priv(mega)$pathName confhidden -stretchy]] {
            if {![string compare "icon" [$canvasPath type $counter]]} {
              $canvasPath itemconfig $counter -state selected
              set tmpList [$ip_priv(mega)$pathName confhidden -selectediconlist]
              set tmpPosition [lsearch $tmpList $counter]
              if {$tmpPosition == -1} {
                lappend tmpList $counter
                $ip_priv(mega)$pathName confhidden -selectediconlist $tmpList
              }
            }
          }
        }
      }
      $canvasPath delete [$ip_priv(mega)$pathName confhidden -stretch]
      $ip_priv(mega)$pathName confhidden -stretch ""
    }
  }
}

proc tkiconpane_internalItemSelect {pathName x y {keepSelection 0}} {# xf ignore me 8
  global ip_priv

  set canvasPath $pathName.xfcanvas.xfcanvas.xfcanvas
  if {[string compare "" [$ip_priv(mega)$pathName confhidden -selectedid]]} {
    set tmpState [lindex [$canvasPath itemconfig [$ip_priv(mega)$pathName confhidden -selectedid] -state] 4]
    if {![string compare "selected" $tmpState] && !$keepSelection} {
      $canvasPath itemconfig [$ip_priv(mega)$pathName confhidden -selectedid] -state normal
      if {![string compare "icon" [$canvasPath type [$ip_priv(mega)$pathName confhidden -selectedid]]]} {
        set tmpList [$ip_priv(mega)$pathName confhidden -selectediconlist]
        set tmpPosition [lsearch $tmpList [$ip_priv(mega)$pathName confhidden -selectedid]]
        if {$tmpPosition != -1} {
          $ip_priv(mega)$pathName confhidden -selectediconlist [lreplace $tmpList $tmpPosition $tmpPosition]
        }
      } {
        if {![string compare "edge" [$canvasPath type [$ip_priv(mega)$pathName confhidden -selectedid]]]} {
          set tmpList [$ip_priv(mega)$pathName confhidden -selectededgelist]
          set tmpPosition [lsearch $tmpList [$ip_priv(mega)$pathName confhidden -selectedid]]
          if {$tmpPosition != -1} {
            $ip_priv(mega)$pathName confhidden -selectededgelist [lreplace $tmpList $tmpPosition $tmpPosition]
          }
        }
      }
    } {
      if {![string compare "selected" [lindex [$canvasPath itemconfig [$ip_priv(mega)$pathName confhidden -selectedid] -state] 4]]} {
        $canvasPath itemconfig [$ip_priv(mega)$pathName confhidden -selectedid] -state normal
        if {![string compare "icon" [$canvasPath type [$ip_priv(mega)$pathName confhidden -selectedid]]]} {
          set tmpList [$ip_priv(mega)$pathName confhidden -selectediconlist]
          set tmpPosition [lsearch $tmpList [$ip_priv(mega)$pathName confhidden -selectedid]]
          if {$tmpPosition != -1} {
            $ip_priv(mega)$pathName confhidden -selectediconlist [lreplace $tmpList $tmpPosition $tmpPosition]
          }
        } {
          if {![string compare "edge" [$canvasPath type [$ip_priv(mega)$pathName confhidden -selectedid]]]} {
            set tmpList [$ip_priv(mega)$pathName confhidden -selectededgelist]
            set tmpPosition [lsearch $tmpList [$ip_priv(mega)$pathName confhidden -selectedid]]
            if {$tmpPosition != -1} {
              $ip_priv(mega)$pathName confhidden -selectededgelist [lreplace $tmpList $tmpPosition $tmpPosition]
            }
          }
        }
      } {
        $canvasPath itemconfig [$ip_priv(mega)$pathName confhidden -selectedid] -state selected
        if {![string compare "icon" [$canvasPath type [$ip_priv(mega)$pathName confhidden -selectedid]]]} {
          set tmpList [$ip_priv(mega)$pathName confhidden -selectediconlist]
          set tmpPosition [lsearch $tmpList [$ip_priv(mega)$pathName confhidden -selectedid]]
          if {$tmpPosition == -1} {
            lappend tmpList [$ip_priv(mega)$pathName confhidden -selectedid]
            $ip_priv(mega)$pathName confhidden -selectediconlist $tmpList
          }
        } {
          if {![string compare "edge" [$canvasPath type [$ip_priv(mega)$pathName confhidden -selectedid]]]} {
            set tmpList [$ip_priv(mega)$pathName confhidden -selectededgelist]
            set tmpPosition [lsearch $tmpList [$ip_priv(mega)$pathName confhidden -selectedid]]
            if {$tmpPosition == -1} {
              lappend tmpList [$ip_priv(mega)$pathName confhidden -selectedid]
              $ip_priv(mega)$pathName confhidden -selectededgelist $tmpList
            }
          }
        }
      }
    }
  } {
    tkiconpane_internalItemDeSelect $pathName
  }
  if {"[$ip_priv(mega)$pathName confvalue -selectcommand]" != ""} {
    eval [$ip_priv(mega)$pathName confvalue -selectcommand] \"[$ip_priv(mega)$pathName confhidden -selectedicon]\" \"[$ip_priv(mega)$pathName confhidden -selectededge]\"
  }
}

proc tkiconpane_internalItemSetSelected {pathName {itemId ""}} {# xf ignore me 8
  global ip_priv

  $ip_priv(mega)$pathName interpset ip_priv(currentPane) $pathName
  set canvasPath $pathName.xfcanvas.xfcanvas.xfcanvas
  if {![string compare "" $itemId]} {
    set itemId [$ip_priv(mega)$pathName confhidden -currentid]
  }
  if {[string compare "" $itemId] &&
      ![string compare "icon" [$canvasPath type $itemId]]} {
    $ip_priv(mega)$pathName confhidden -selectededge ""
    $ip_priv(mega)$pathName confhidden -selectedicon $itemId
    $ip_priv(mega)$pathName confhidden -selectedid $itemId
  } {
    if {[string compare "" $itemId] &&
        ![string compare "edge" [$canvasPath type $itemId]]} {
      $ip_priv(mega)$pathName confhidden -selectededge $itemId
      $ip_priv(mega)$pathName confhidden -selectedicon ""
      $ip_priv(mega)$pathName confhidden -selectedid $itemId
    } {
      $ip_priv(mega)$pathName confhidden -selectededge ""
      $ip_priv(mega)$pathName confhidden -selectedicon ""
      $ip_priv(mega)$pathName confhidden -selectedid ""
    }
  }
}

proc tkiconpane_internalMenuMove {pathName menu rootX rootY} {# xf ignore me 8
  global ip_priv

  if {[winfo exists $menu] && [winfo ismapped $menu] &&
      [string compare "" [$ip_priv(mega)$pathName confhidden -grab]]} {
    set popMinX [winfo rootx $menu]
    set popMaxX [expr $popMinX+[winfo width $menu]]
    if {$rootX >= $popMinX && $rootX <= $popMaxX} {
      catch "$menu activate @[expr $rootY-[winfo rooty $menu]]"
      if {![catch "$menu entryconfig @[expr $rootY-[winfo rooty $menu]] -menu" result]} {
        if {[string compare "" [lindex $result 4]]} {
          catch "[lindex $result 4] activate none"
          bind [lindex $result 4] <B3-Motion> "$pathName internal bind_menu_move %W %X %Y"
          bind [lindex $result 4] <ButtonRelease-3> "$pathName internal bind_menu_unpost %W"
          bind [lindex $result 4] <Meta-B3-Motion> "$pathName internal bind_menu_move %W %X %Y"
          bind [lindex $result 4] <Meta-ButtonRelease-3> "$pathName internal bind_menu_unpost %W"
        }
      }
    } {
      $menu activate none
    }
  }
}

proc tkiconpane_internalMenuPost {pathName x y rootX rootY {menuNumber ""}} {# xf ignore me 8
  global ip_priv

  set canvasPath $pathName.xfcanvas.xfcanvas.xfcanvas
  set canvasItem [$ip_priv(mega)$pathName confhidden -currentid]
  set menu ""
  if {[string compare "" [$ip_priv(mega)$pathName confhidden -grab]]} {
    return
  }
  if {![string compare "current" $canvasItem]} {
    tkiconpane_internalItemSetSelected $pathName \
      [$ip_priv(mega)$pathName confhidden -currentid]
  } {
    tkiconpane_internalItemSetSelected $pathName
  }
  if {[string compare "" [$ip_priv(mega)$pathName confhidden -selectedid]]} {
    set menu [lindex [$canvasPath itemconfig [$ip_priv(mega)$pathName confhidden -selectedid] -menu$menuNumber] 4]
    if {[string compare "" $menu]} {
      if {[string compare "" [string index $menu 0]]} {
        if {![string compare "icon" [$canvasPath type [$ip_priv(mega)$pathName confhidden -selectedid]]]} {
          set menu .imenu-$menu
        } {
          set menu .emenu-$menu
        }
      }
    }
  } {
    set menu [$ip_priv(mega)$pathName confvalue -menu$menuNumber]
    if {[string compare "" $menu]} {
      if {[string compare "." [string index $menu 0]]} {
        set menu .vmenu-$menu
      }
    }
  }

  if {[string compare "" $menu]} {
    catch "$menu activate none"
    if {[string compare "" [$ip_priv(mega)$pathName interpeval info commands $menu]]} {
      if {![string compare "" [$ip_priv(mega)$pathName confhidden -focus]]} {
        $ip_priv(mega)$pathName confhidden -focus [focus]
      }
      $ip_priv(mega)$pathName confhidden -grab $menu

      bind $menu <B3-Motion> "$pathName internal bind_menu_move %W %X %Y"
      bind $menu <ButtonRelease-3> "$pathName internal bind_menu_unpost %W"
      bind $menu <Meta-B3-Motion> "$pathName internal bind_menu_move %W %X %Y"
      bind $menu <Meta-ButtonRelease-3> "$pathName internal bind_menu_unpost %W"

      catch "$menu post $rootX $rootY"
      catch "focus $menu"
      catch "grab -global $menu"
    }
  }
}

proc tkiconpane_internalMenuUnpost {pathName menu} {# xf ignore me 8
  global errorInfo
  global ip_priv

  set result ""
  set localErrorCode 0
  if {[winfo exists $menu] && [winfo ismapped $menu] &&
      [string compare "" [$ip_priv(mega)$pathName confhidden -grab]]} {
    set localErrorCode 0
    set tmpMenu [$ip_priv(mega)$pathName confhidden -grab]
    set index [$menu index active]
    $menu activate none
    if {[string compare "none" $index]} {
      catch "$tmpMenu unpost"
      update idletask
      set localErrorCode [catch "$menu invoke $index" result]
    }
  }
  catch "grab release [$ip_priv(mega)$pathName confhidden -grab]"
  catch "focus [$ip_priv(mega)$pathName confhidden -focus]"
  $ip_priv(mega)$pathName confhidden -focus ""
  $ip_priv(mega)$pathName confhidden -grab ""
  catch "$menu unpost"
  catch "$tmpMenu unpost"
  if {$localErrorCode} {
    error "$result"
  }
}

proc tkiconpane_internalScale {pathName {oldscale ""}} {# xf ignore me 8
  global ip_priv

  set canvasPath $pathName.xfcanvas.xfcanvas.xfcanvas
  set scale [$ip_priv(mega)$pathName confvalue -scale]
  set currentscale $oldscale
  if {[string compare "" $oldscale]} {
    set oldscale [expr 1/$oldscale]
    if {$oldscale <= 0} {
      set oldscale 1
    }
  } {
    set oldscale 1
    set scale -1
  }
  $canvasPath scale all 0 0 $oldscale $oldscale
  if {$scale == -1} {
    set bbox [$canvasPath bbox all]
    if {"$bbox" == ""} {
      return
    }
    set tmpX [expr ([lindex $bbox 0]*-1)+20]
    set tmpY [expr ([lindex $bbox 1]*-1)+20]
    foreach item [$canvasPath find all] {
      if {"[$canvasPath type $item]" == "icon"} {
        $canvasPath move $item $tmpX $tmpY
      }
    }
    set width [expr [winfo width $canvasPath]-20.0]
    set height [expr [winfo height $canvasPath]-20.0]
    set xscale [expr $width/(([lindex $bbox 2]-[lindex $bbox 0])+20.0)]
    set yscale [expr $height/(([lindex $bbox 3]-[lindex $bbox 1])+20.0)]
    if {$xscale > $yscale} {
      set scale $yscale
    } {
      set scale $xscale
    }
    $ip_priv(mega)$pathName confinternal -scale $scale
  }
  if {$scale <= 0} {
    if {[string compare "" $currentscale]} {
      set scale $currentscale
      $ip_priv(mega)$pathName confinternal -scale $scale
    } {
      set scale 1
      $ip_priv(mega)$pathName confinternal -scale $scale
    }
  }
  $canvasPath scale all 0 0 $scale $scale
  if {$scale < 1} {
    if {$scale < 0.5} {
      $ip_priv(mega)$pathName confhidden -iconfont \
        [$ip_priv(mega)$pathName confvalue -iconfont1]
      $ip_priv(mega)$pathName confhidden -edgefont \
        [$ip_priv(mega)$pathName confvalue -edgefont1]
    } {
      $ip_priv(mega)$pathName confhidden -iconfont \
        [$ip_priv(mega)$pathName confvalue -iconfont2]
      $ip_priv(mega)$pathName confhidden -edgefont \
        [$ip_priv(mega)$pathName confvalue -edgefont2]
    }
  } {
    if {$scale < 2} {
      $ip_priv(mega)$pathName confhidden -iconfont \
        [$ip_priv(mega)$pathName confvalue -iconfont3]
      $ip_priv(mega)$pathName confhidden -edgefont \
        [$ip_priv(mega)$pathName confvalue -edgefont3]
    } {
      if {$scale > 2 && $scale < 3} {
        $ip_priv(mega)$pathName confhidden -iconfont \
          [$ip_priv(mega)$pathName confvalue -iconfont4]
        $ip_priv(mega)$pathName confhidden -edgefont \
          [$ip_priv(mega)$pathName confvalue -edgefont4]
      } {
        $ip_priv(mega)$pathName confhidden -iconfont \
          [$ip_priv(mega)$pathName confvalue -iconfont5]
        $ip_priv(mega)$pathName confhidden -edgefont \
          [$ip_priv(mega)$pathName confvalue -edgefont5]
      }
    }
  }
  foreach items [$canvasPath find all] {
    if {![string compare "icon" [$canvasPath type $items]]} {
      $canvasPath itemconfig $items \
        -font [$ip_priv(mega)$pathName confhidden -iconfont]
    } {
      if {![string compare "edge" [$canvasPath type $items]]} {
        $canvasPath itemconfig $items \
          -font [$ip_priv(mega)$pathName confhidden -edgefont]
      }
    }
  }
  if {[$ip_priv(mega)$pathName confvalue -updateedges]} {
    $canvasPath layout edges -edgeorder [$ip_priv(mega)$pathName confvalue -edgeorder] -graphorder [$ip_priv(mega)$pathName confvalue -graphorder]
  }
}

proc tkiconpane_createMenubutton {name args} {
  global ip_priv

  set pathName [winfo parent [winfo parent $ip_priv(menuBar)]]
  eval menubutton $ip_priv(menuBar).$name \
    -menu $ip_priv(menuBar).$name.m \
    $args
  menu $ip_priv(menuBar).$name.m \
    -postcommand "
      $pathName internal setselected
      tkiconpane_updateMenu $ip_priv(menuBar).$name.m"
}

proc tkiconpane_createToolbarButton {name args} {
  global ip_priv

  set result ""
  set pathName [winfo parent [winfo parent $ip_priv(toolBar)]]
  set tmpArgs ""
  set dropCommand ""
  for {set counter 0} {$counter < [llength $args]} {incr counter} {
    if {![string compare "-command" [lindex $args $counter]]} {
      lappend tmpArgs [lindex $args $counter]
      incr counter
      lappend tmpArgs "$pathName internal setselected; [lindex $args $counter]"
    } {
      if {![string compare "-dropcommand" [lindex $args $counter]]} {
        incr counter
        set dropCommand "$pathName internal setselected; [lindex $args $counter]"
      } {
        lappend tmpArgs [lindex $args $counter]
        incr counter
        lappend tmpArgs [lindex $args $counter]
      }
    }
  }
  if {[catch "button $ip_priv(toolBar).$name $tmpArgs" result]} {
    error $result
  }
  if {[$ip_priv(mega)$pathName confvalue -dragdrop] &&
      [string compare "" $dropCommand]} {
    blt_drag&drop target $ip_priv(toolBar).$name handler \
      icon "$pathName internal drag_drop_receive_toolbar $ip_priv(toolBar).$name \{$dropCommand\}"
  }
  return $result
}

proc tkiconpane_createViewMenu {name} {
  menu .vmenu-$name \
    -postcommand "tkiconpane_updateMenu .vmenu-$name"
}

}

# eof
