#!/usr/local/bin/icon-wish -f

global auto_path
set libraryPath ""
set layoutPath ""
set searchList ""
foreach dirName $auto_path {
  lappend searchList $dirName
}
lappend searchList "../library"
lappend searchList ".."
lappend searchList "."
foreach dirName $searchList {
  if {[file exists $dirName/tkIconPaneInt.tcl]} {
    set libraryPath $dirName
  } {
    if {[file exists $dirName/TkIcon/tkIconPaneInt.tcl]} {
      set libraryPath $dirName/TkIcon
    } {
      if {[file exists [file dirname $dirName]/TkIcon/tkIconPaneInt.tcl]} {
        set libraryPath [file dirname $dirName]/TkIcon
      }
    }
  }
  if {[file exists $dirName/tree.lay]} {
    set layoutPath $dirName
  } {
    if {[file exists $dirName/TkIcon/tree.lay]} {
      set layoutPath $dirName/TkIcon
    } {
      if {[file exists [file dirname $dirName]/TkIcon/tree.lay]} {
        set layoutPath [file dirname $dirName]/TkIcon
      }
    }
  }
}
lappend auto_path $libraryPath
source $libraryPath/tkIconPaneCmd.tcl

foreach fileName [glob -nocomplain $layoutPath/*.lay] {
  source $fileName
}

wm maxsize . 1000 1000
wm geometry . 400x400

menu .layouterMenu

foreach layouter [lsort [info commands LAYOUT_*]] {
  .layouterMenu add radiobutton \
    -command "
      .layouter config -layoutcommand $layouter
      .layouter layout
    " \
    -label [string range $layouter 7 end] \
    -variable layouter
}

set layouter matrix
set nodeCounter 0
set edgeCounter 0
set graphorder 0
set edgeorder 0
tkiconpane .layouter -toplevel 0 \
  -tkiconlib "$libraryPath/menus $libraryPath/icons $libraryPath/status" \
  -menu1 layouter \
  -menu2 .layouterMenu \
  -menubar layouter \
  -menupath "$libraryPath/viewMenus" \
  -layout 0 \
  -name layouter \
  -updateedges 0

pack .layouter -side top -fill both -expand 1

if {$argc > 0} {
  if {[file exists $argv]} {
    source [lindex $argv 0]
    .layouter config -layoutcommand LAYOUT_$layouter
    .layouter layout
  }
}

.layouter.xfcanvas.xfcanvas.xfcanvas itemconfig 2 -bitmap @icon1.xpm

proc SaveIcons {pathName} {
  global nodeCounter
  global edgeCounter
  global layouter

  set canvasPath $pathName.xfcanvas.xfcanvas.xfcanvas
  set fd [open layout.info w]

  puts $fd "global nodeCounter"
  puts $fd "global edgeCounter"
  puts $fd "global layouter"
  puts $fd "set nodeCounter [set nodeCounter]"
  puts $fd "set edgeCounter [set edgeCounter]"
  puts $fd "set layouter [set layouter]\n"

  foreach element [$pathName iconinfo ids] {
    puts $fd "$pathName iconcreate [lindex [$canvasPath itemconfig $element -name] 4] -menu1 layouter -status none -text [lindex [$canvasPath itemconfig $element -name] 4] -name [lindex [$canvasPath itemconfig $element -name] 4] -type standard"
  }
  foreach element [$pathName edgeinfo ids mygraph] {
    puts $fd "$pathName edgecreate mygraph \[list \[.layouter iconinfo id [lindex [$pathName edgeinfo fromtoname mygraph $element] 0]\] \[.layouter iconinfo id [lindex [$pathName edgeinfo fromtoname mygraph $element] 1]\] 1 -menu1 layouter -label [lindex [$canvasPath itemconfig $element -name] 4] -name [lindex [$canvasPath itemconfig $element -name] 4]\]"
  }

  close $fd
}

