#
# ConnectBox: ask which app to connect to.
#
proc ConnectBox {} {
    global ReplayData
    set w .replay.connect
    toplevel $w
    label $w.title -text "Click on an application to connect to" \
        -relief raised -bd 2
    frame $w.apps
    pack $w.apps -side top -fill both -expand yes
    scrollbar $w.apps.yscroll -orient vertical -relief sunken -bd 2 \
        -command "$w.apps.apps yview"
    pack $w.apps.yscroll -side left -fill y
    listbox $w.apps.apps -geometry 30x8 -yscroll "$w.apps.yscroll set"
    pack $w.apps.apps -side right -fill both -expand yes
    eval $w.apps.apps insert 0 [winfo interps]
    frame $w.buttons -relief groove -bd 3
    pack $w.buttons -side top -fill x
    button $w.buttons.connect -text "Connect to Selected Interpreter" \
        -command "GetAndConnect $w.apps.apps"
    pack $w.buttons.connect -side left
    button $w.buttons.cancel -text "Cancel" -command "destroy $w"
    pack $w.buttons.cancel -side left
}
#
# GetAndConnect: get the app name from the list bax and connect to the app.
#
proc GetAndConnect {listbox} {
    set sel [$listbox curselection]
    if {$sel == ""} {
        MakeComment -1 "No interpreter was selected"
        return
    }
    ConnectToApp [$listbox get $sel]
    destroy .replay.connect
}
#
# ConnectToApp: connect to the app.
#
proc ConnectToApp {target} {
    global targetApp ReplayData
    set ReplayData(AppIsSeparate) 1
    set targetApp $target
    set ReplayData(ConnectedToApp) 1
    set cbn RebindCallback
    set ReplayData(CallbackName) $cbn
    SendToApp [list proc $cbn {thisApp subscript percentFields args} {
            lappend percentFields [list Args "$args"]
            set cmd [format {ReplayCapture %s {%s}} $subscript $percentFields]
            send $thisApp $cmd
        }]
    MakeReplayClassBindings
}
#
# BindToThisApp: make bindings.
#
proc BindToThisApp {} {
    global ReplayData
    set ReplayData(AppIsSeparate) 0
    MakeReplayClassBindings
}
#
# SendToApp: send to the application (and get reply).
#
proc SendToApp {cmd} {
    global targetApp ReplayData
    if {$ReplayData(AppIsSeparate)} {
        return [send $targetApp $cmd]
    } else {
        return [eval $cmd]
    }
}
#
# MakeReplayWindow: creates the replay control window.
#
proc MakeReplayWindow {} {
    global ReplayData
    CreateHelpFile
    #
    # set up global replay data
    #
    set ReplayData(recordingOn)    0
    set ReplayData(playingOn)      0
    set ReplayData(ConnectedToApp) 0
    set ReplayData(script)         {}
    global thisApp
    set thisApp [winfo name .]
    #
    # initialize various option settings
    #
    set ReplayData(flashWidget)         0
    set ReplayData(pointWithArrow)      0
    set ReplayData(movePointer)         1
    set ReplayData(showEnterEvents)     1
    set ReplayData(showEventsRecording) 1
    set ReplayData(showEventsPlaying)   1
    #
    # create the replay control window
    #
    set w .replay
    toplevel $w
    wm minsize $w 10 10
    frame $w.topline -bd 3 -relief groove
    pack $w.topline -side top
    label $w.topline.title -text "Tk Record/Replay Facility"
    pack $w.topline.title -side left
    checkbutton $w.topline.recordon -text "Recording" \
        -variable ReplayData(recordingOn)
    pack $w.topline.recordon -side left
    #
    # create the replay buttons and menus
    #
    set width 8
    frame $w.menu -relief raised -borderwidth 1
    pack $w.menu -side top -fill x
    menubutton $w.menu.file -text "FILE" -menu $w.menu.file.m \
        -bd 2 -relief raised -width $width
    pack $w.menu.file -side left
    menu $w.menu.file.m
    $w.menu.file.m add command -label "Load..." \
        -command "RecordControl load"
    $w.menu.file.m add command -label "Save..." \
        -command "RecordControl save"
    $w.menu.file.m add separator
    $w.menu.file.m add command -label "Connect to remote app..." \
        -command "ConnectBox"
    $w.menu.file.m add separator
    $w.menu.file.m add command -label "Bind to this app" \
        -command "BindToThisApp"
    $w.menu.file.m add separator
    $w.menu.file.m add command -label "Replay Options..." \
        -command "OptionBox"
    $w.menu.file.m add separator
    $w.menu.file.m add command -label "Erase Events" \
        -command "RecordControl erase"
    $w.menu.file.m add command -label "Unbind All Widgets" \
        -command "UnbindAllWidgets"
    $w.menu.file.m add separator
    $w.menu.file.m add command -label "Quit Replay" \
        -command "exit"
    #
    # a spacer
    #
    frame $w.menu.spacer -height 1 -width 10
    pack $w.menu.spacer -side left
    #
    # a check button to show when recording is on.  Keep it disabled so
    # that you have to start and stop recording with the Record and
    # Stop buttons.
    #
    button $w.menu.start -text "Record" -command "RecordControl start" \
        -width $width
    pack $w.menu.start -side left
    button $w.menu.stop -text "Stop" -command "RecordControl stop" \
        -width $width
    pack $w.menu.stop -side left
    button $w.menu.replay -text "Play" -command "RecordControl replay" \
        -width $width
    pack $w.menu.replay -side left
    button $w.menu.replayFast -text "PlayFast" \
        -command "RecordControl replayFast" -width $width
    pack $w.menu.replayFast -side left
    button $w.menu.comment -text "Comment" -command "AddComment" \
        -width $width
    pack $w.menu.comment -side left
    button $w.menu.help -text "Help" -command "ShowHelp" -width $width
    pack $w.menu.help -side right
    #
    # a message box
    #
    message $w.message -relief ridge -bd 2 -width 600
    pack $w.message -side top -fill x
    #
    # some listboxes to display the events that are recorded
    #
    frame $w.events
    pack $w.events -side top -fill both -expand yes
    scrollbar $w.events.yscroll -orient vertical -relief sunken \
        -bd 2 -command "ScrollLists $w.events"
    pack $w.events.yscroll -side left -fill y
    listbox $w.events.times -geometry 3x5 -relief sunken \
        -borderwidth 2 -yscroll "$w.events.yscroll set" \
        -exportselection false
    pack $w.events.times -side left -fill both
    listbox $w.events.subs -geometry 33x5 -relief sunken \
        -borderwidth 2 -yscroll "$w.events.yscroll set" \
        -exportselection false
    pack $w.events.subs -side left -fill both -expand yes
    listbox $w.events.reps -geometry 50x5 -relief sunken \
        -borderwidth 2 -yscroll "$w.events.yscroll set" \
        -exportselection false
    pack $w.events.reps -side left -fill both -expand yes
}
#
# OptionBox: allow the user to set various replay options.
#
proc OptionBox {} {
    global ReplayData
    set w .replay.optionBox
    if [winfo exists $w] {
        wm deiconify $w
        raise $w
    } else {
        #
        # make the toplevel and the title
        #
        toplevel $w
        label $w.title -text "Replay Options"
        pack $w.title -side top -fill x
        #
        # make a frame to hold the replay pointer options
        #
        frame $w.flash -bd 4 -relief ridge
        pack $w.flash -side top -fill x
        checkbutton $w.flash.flash -anchor w \
            -text "Flash widgets as they are replayed" \
            -variable ReplayData(flashWidget)
        if $ReplayData(flashWidget) {
            $w.flash.flash select
        }
        pack $w.flash.flash -side top -fill x
        checkbutton $w.flash.arrow -anchor w \
            -text "Point red arrow window at widgets as they are replayed" \
            -variable ReplayData(pointWithArrow)
        if $ReplayData(pointWithArrow) {
            $w.flash.arrow select
        }
        pack $w.flash.arrow -side top -fill x
        checkbutton $w.flash.pointer -anchor w \
            -text "Move mouse pointer to widgets are they are replayed" \
            -variable ReplayData(movePointer)
        if $ReplayData(movePointer) {
            $w.flash.pointer select
        }
        pack $w.flash.pointer -side top -fill x
        #
        # make a frame to hold the display event options
        #
        frame $w.events -bd 4 -relief ridge
        pack $w.events -side top -fill x
        checkbutton $w.events.enters -anchor w \
            -text "Move mouse pointer to enter and leave events" \
            -variable ReplayData(showEnterEvents)
        if $ReplayData(showEventsRecording) {
            $w.events.enters select
        }
        pack $w.events.enters -side top -fill x
        checkbutton $w.events.onrecord -anchor w \
            -text "Show event text as they are being recorded" \
            -variable ReplayData(showEventsRecording) \
            -command ShowEventLists
        if $ReplayData(showEventsRecording) {
            $w.events.onrecord select
        }
        pack $w.events.onrecord -side top -fill x
        checkbutton $w.events.onreplay -anchor w \
            -text "Show event text as they are being replayed" \
            -variable ReplayData(showEventsPlaying) \
            -command ShowEventLists
        if $ReplayData(showEventsPlaying) {
            $w.events.onreplay select
        }
        pack $w.events.onreplay -side top -fill x
        #
        # make the dismiss button.  Keep the window around so it will
        # come up faster next time.
        #
        button $w.dismiss -text "Dismiss" -command "wm withdraw $w"
        pack $w.dismiss  -side top
    }
}
#
# ShowEventLists: decide whether to show the event lists.
#
proc ShowEventLists {} {
    global ReplayData
    if {!$ReplayData(showEventsRecording) && !$ReplayData(showEventsPlaying)} {
        pack forget .replay.events
    } else {
        pack .replay.events -side top -fill both -epxand yes
    }
}
#
# ScrollLists: the scroll callback procedure to scroll all three
#     lists at the same time.
#
proc ScrollLists {frame line} {
    if {$line < 4} {
        set line 0
    } else {
        incr line -4
    }
    foreach list {times subs reps} {
        $frame.$list yview $line
    }
}
#
# RebindCallback: This is used when we embed the replay mechanism with
# the program being replayed.
#
proc RebindCallback {thisApp subscript percentFields args} {
    lappend percentFields [list Args "$args"]
    ReplayCapture $subscript $percentFields
}



