#include <starlet.h>
#include <time.h>
#include <errno.h>
#include <tcl.h>

/*
    Not defined on VMS unless you include <socket.h>
*/
struct timeval {
    long	tv_sec;
    long	tv_usec;
};

#define	MAX_EVENT_FLAGS		31

/*
    Try and avoid using this event flag, we use it to set a timer.

    The X windows event flag has to be in the same cluster as this flag.
*/
#define	TIMER_EVENT_FLAG	1

static void CvtTimeval2Quad(struct timeval *, long *);

vmsSelect(int nDesc, int *rdsc, int *wdsc, int *edsc, struct timeval *timeOut)
{
    /*
	Emulate a select call

	0 is never used.
	1 is our timer event flag
	2-31 the rest
    */
    int nfds = 0;
    int status;
    int poll;
    int timerSet = 0;
    long quadTime[2];
    unsigned long mask, readMask, waitMask;
    unsigned long baseMask;

    poll = timeOut && timeOut->tv_sec == 0 && timeOut->tv_usec == 0;
	
    sys$setast(0);			/* Block interrupts */
    
    if (rdsc)
	readMask = *rdsc;		/* Unix mask is shifted over 1 */
    else
	readMask = 0;			/* Must be a wait call */

    waitMask = readMask;
    if (!poll && timeOut) {		/* Do we need to start a timer? */
	CvtTimeval2Quad(timeOut, quadTime);
	sys$setimr(TIMER_EVENT_FLAG, quadTime, 0, 1);
	waitMask |= (1 << TIMER_EVENT_FLAG);
	timerSet = 1;
    }
    
    sys$setast(1);			/* Re-enable interrupts */
    
    if (!poll) {
	sys$wflor(TIMER_EVENT_FLAG, waitMask);
	if (timerSet)
	    sys$cantim(1, 0);
    }
    sys$readef(TIMER_EVENT_FLAG, &mask);

    /*
	Count number of descriptors that are ready
    */
    mask &= readMask;			/* Only count those we care about */
    if (rdsc) {
	*rdsc = mask;
	for (nfds = 0; mask; mask >>= 1) {
	    if (mask & 1)
		nfds++;
	}
    }
    else
    	nfds = 0;

    /*
    	Don't do these on VMS
    */
    if (wdsc)
	*wdsc = 0;
    if (edsc)
	*edsc = 0;
    return(nfds);
}

#ifdef ct2q_1

#define MILLISECS_PER_DAY	(1000*60*60*24)
#define MILLISECS_PER_HOUR	(MILLISECS_PER_DAY/24)
#define MILLISECS_PER_MIN	(MILLISECS_PER_HOUR/60)
#define MILLISECS_PER_SECOND	(MILLISECS_PER_MIN/60)

static void
CvtTimeval2Quad(struct timeval *tv, long *quad)
{
    /*
    	Convert a Unix timeval interval to VMS binary quadtime
    */
    char binTime[80];
    int hours, minutes, days;
    int ms;
    float seconds;
    struct {
    	int	l;
    	char	*a;
    } desc;

    ms = tv->tv_sec * MILLISECS_PER_SECOND + (tv->tv_usec + 500) / 1000;
    days = ms/MILLISECS_PER_DAY;
    ms = ms - days*MILLISECS_PER_DAY;
    hours = ms/MILLISECS_PER_HOUR;
    ms = ms - hours*MILLISECS_PER_HOUR;
    minutes = ms/MILLISECS_PER_MIN;
    ms = ms - minutes*MILLISECS_PER_MIN;
    seconds = ms/1000.;
    sprintf(binTime, "%d %d:%d:%f", days, hours, minutes, seconds);
    desc.l = strlen(binTime);
    desc.a = binTime;
    sys$bintim(&desc, quad);
}

#endif /*ct2q_1*/

#ifdef ct2q_2

static void
CvtTimeval2Quad(struct timeval *tv, long *quad)
{
  int multiplier = - 10*1000*1000;
  int addend = - tv->tv_usec * 10;
  lib$emul (&multiplier, &tv->tv_sec, &addend, quad);
}

#endif /*ct2q_2*/



char *
strdup(char *string)
{
    /*
    	Make a copy of a string
    */
    char *newS = ckalloc(strlen(string) + 1);

    strcpy(newS, string);
    return newS;
}
