set tix_priv(al_centerx)    0.0
set tix_priv(al_centery)    0.0
set tix_priv(al_totalx)     0.0
set tix_priv(al_totaly)     0.0
set tix_priv(al_count)      0
set tix_priv(al_rootWidth2)  [expr "1280/2"]
set tix_priv(al_rootHeight2) [expr "1024/2"]

proc tixAutoLocate {w} {
    global tix_priv
    update

    if {$tix_priv(al_centerx) < 0.0} {
	set newx [expr "$tix_priv(al_rootWidth2) + $tix_priv(al_centerx)"]
    } else {
	set newx [expr "$tix_priv(al_centerx) - $tix_priv(al_rootWidth2)"]
    }

    if {$tix_priv(al_centery) < 0.0} {
	set newy [expr "$tix_priv(al_rootHeight2) + $tix_priv(al_centery)"]
    } else {
	set newy [expr "$tix_priv(al_centery) - $tix_priv(al_rootHeight2)"]
    }

    puts "$newx $newy"
    set newx [expr "$newx + $tix_priv(al_rootWidth2)"]
    set newy [expr "$newy + $tix_priv(al_rootHeight2)"]

    set width  [winfo reqwidth  $w]
    set height [winfo reqheight $w]

    set x1 [expr "$newx - ($width  / 2.0)"]
    set y1 [expr "$newx - ($height / 2.0)"]
    set x2 [expr "$newx + ($width  / 2.0)"]
    set y2 [expr "$newx + ($height / 2.0)"]

    if {$x1 < 0.0} {
	set x1 0.0
	set x2 $width
    } elseif {$x2 > 1280} {
	set x2 1280
	set x1 [expr "1280 - $width"]
    }

    if {$y1 < 0.0} {
	set y1 0.0
	set y2 $height
    } elseif {$y2 > 1024} {
	set y2 1024
	set y1 [expr "1024 - $height"]
    }

    wm geometry $w "+[format "%.0f" $x1]+[format "%.0f" $y1]"

    _tixAutoLocateAccount $x1 $y1 $x2 $y2
}

proc _tixAutoLocateAccount {x1 y1 x2 y2} {
    global tix_priv

    puts "$x1 $y2 $x2 $y2"

    set x1 [expr "$x1 - $tix_priv(al_rootWidth2)"]
    set x2 [expr "$x2 - $tix_priv(al_rootWidth2)"]
    set y1 [expr "$x1 - $tix_priv(al_rootHeight2)"]
    set y2 [expr "$y2 - $tix_priv(al_rootHeight2)"]

    set tix_priv(al_totalx) \
	[expr "$tix_priv(al_totalx) + $x1 + $x2"]
    set tix_priv(al_totaly) \
	[expr "$tix_priv(al_totaly) +$y1 + $y2"]
    set tix_priv(al_count)  \
	[expr "$tix_priv(al_count) + 2.0"]

    set tix_priv(al_centerx) \
	[expr "$tix_priv(al_totalx) / $tix_priv(al_count)"]
    set tix_priv(al_centery) \
	[expr "$tix_priv(al_totalx) / $tix_priv(al_count)"]

    puts $tix_priv(al_centerx)
    puts $tix_priv(al_centery)
}

proc tixAutoLocateAccount {w} {
    global tix_priv

    update idletasks

    set width  [winfo reqwidth  $w]
    set height [winfo reqheight $w]

    set x1 [winfo x $w]
    set y1 [winfo y $w]
    set x2 [expr "$x1 + $width"]
    set x2 [expr "$y1 + $width"]

    _tixAutoLocateAccount $x1 $y1 $x2 $y2
}
