#----------------------------------------------------------------------
#
#                     M A I N   W I N D O W 
#
#----------------------------------------------------------------------
proc CreateMainWindow {w} {
    wm withdraw .
    toplevel $w
    wm minsize $w 100 100
    wm protocol $w WM_DELETE_WINDOW {exit}

    set frame1 [CreateMainMenu  $w]
    set frame2 [CreateMainFrame $w]
    pack append $w \
	$frame1 {top fillx}\
	$frame2 {top fill expand }
}

proc CreateMainMenu {top} {
    set w [frame $top.menu -bd 2 -relief raised]

    menubutton $w.demo -text "Demos" -menu $w.demo.m
    pack append $w $w.demo left
    menu $w.demo.m

    $w.demo.m add command -label "Dialog Buttons" -command DialogButtonTest
    $w.demo.m add command -label "File Dialog" -command FileDialogTest
    $w.demo.m add command -label "ComboBox"    -command ComboBoxTest
    $w.demo.m add command -label "LabelFrame"  -command LabelFrameTest
    $w.demo.m add sep
    $w.demo.m add command -label "Exit       " -command {exit}


    return $w
}

proc CreateMainFrame {w} {
    frame $w.frame -borderwidth 1 -relief raised
    frame $w.f1 
    frame $w.f2 
    frame $w.f3 

    message $w.msg -font -Adobe-times-medium-r-normal--*-180*\
	-relief flat -borderwidth 0 -width 600 \
	-text "
Welcome to Tix : Tk Ioi's Extension
                 Release 3.3"

    #----------------------
    # The file selction box
    #----------------------
    set labfm [tixLabelFrame $w.labfm1 -label " File Selection Box "\
	       -bd 15 -padx 10 -pady 10]
    message $labfm.msg -font -*-times-*-r-*-*-14-*-*-*-*-*-*-*\
	-relief flat -borderwidth 10 -width 220 \
	-text [MainMsg_FSB]

    tixFileSelectBox $labfm.fsb -bd 2
    pack append $labfm\
	$labfm.msg {top fill expand}\
	$labfm.fsb {top fill expand}
 
    #----------------------
    # The Scrolled List
    #----------------------
    set labfm [tixLabelFrame $w.labfm2 -label " Scrolled List "\
	       -bd 15 -padx 10 -pady 10]
    message $labfm.msg -font -*-times-*-r-*-*-14-*-*-*-*-*-*-*\
	-relief flat -borderwidth 10 -width 180 \
	-text [concat \
	       "This is a scrolled list box. The ends of the" \
	       "scroll bars are aligned. Does it look better" \
	       "than the typical Tk arrangement?"]

    tixScrolledListBox $labfm.list -geom 10x5

    pack append $labfm\
	$labfm.msg {top fill expand}\
	$labfm.list {fill expand}

    #----------------------
    # The Group Buttons
    #----------------------
    set labfm [tixLabelFrame $w.labfm3 -label " Group Buttons "\
	       -bd 15 -padx 10 -pady 10]
    message $labfm.msg -font -*-times-*-r-*-*-14-*-*-*-*-*-*-*\
	-relief flat -borderwidth 10 -width 180 \
	-text [concat \
	       "The Label Frame can be used to logically group the"\
	       "related buttons together."]

    set labfm1 [tixLabelFrame $labfm.lfm -label " Fonts " \
		-bd 0]

    radiobutton $labfm1.b1 -text "Courier"   -variable test_color -relief flat
    radiobutton $labfm1.b2 -text "Helvetica" -variable test_color -relief flat
    radiobutton $labfm1.b3 -text "Lucida"    -variable test_color -relief flat
    radiobutton $labfm1.b4 -text "Palatino"  -variable test_color -relief flat

    pack append $labfm1 \
	$labfm1.b1 {top fillx} \
	$labfm1.b2 {top fillx} \
	$labfm1.b3 {top fillx} \
	$labfm1.b4 {top fillx}

    pack append $labfm\
	$labfm.msg {top expand}\
	$labfm.lfm {top fill expand}


    #----------------------
    # The Label Frame
    #----------------------
    set labfm [tixLabelFrame $w.labfm4 -label " Label Frame "\
	       -bd 15 -padx 10 -pady 10]
    message $labfm.msg -font -*-times-*-r-*-*-14-*-*-*-*-*-*-*\
	-relief flat -borderwidth 10 -width 250 \
	-text "The Label Frame is what surrounds this text. Isn't it nice?"
    pack append $labfm\
	$labfm.msg {top fill expand}

    #----------------------
    # The Combo Box
    #----------------------
    set labfm [tixLabelFrame $w.labfm5 -label " Combo Box "\
	       -bd 15 -padx 10 -pady 10]
    message $labfm.msg -font -*-times-*-r-*-*-14-*-*-*-*-*-*-*\
	-relief flat -borderwidth 10 -width 250 \
	-text [MainMsg_Combo]
    pack append $labfm\
	$labfm.msg {top fill expand}

    tixComboBox $labfm.cbx -type history -width 15
    pack append $labfm\
	$labfm.cbx {fill expand}

    #----------------------
    # The Dialog Buttons
    #----------------------
    set labfm [tixLabelFrame $w.labfm6 -label " Standard Dialog Buttons "\
	       -bd 15 -padx 10 -pady 10]
    message $labfm.msg -font -*-times-*-r-*-*-14-*-*-*-*-*-*-*\
	-relief flat -borderwidth 10 -width 250 \
	-text [concat \
	       "This is a standard set of buttons that should appear at" \
	       "the bottom of a dialog box. Please refer to the Motif "  \
	       "Style Guide for more details"]

    tixStdDlgButtons $labfm.btns -bd 2

    pack append $labfm\
	$labfm.msg {top fill expand}\
	$labfm.btns {fill expand}

    #----------------
    # Pack everything
    #----------------
    pack append $w.f1\
	$w.labfm1 {top fill expand}

    pack append $w.f2\
	$w.labfm2 {top fillx} \
	$w.labfm3 {bottom fillx}

    pack append $w.f3\
	$w.labfm4 {top fillx} \
	$w.labfm5 {top fillx} \
	$w.labfm6 {bottom fillx}
	
    pack append $w.frame \
	$w.msg {top}\
	$w.f1 {left expand filly}\
	$w.f2 {left expand filly}\
	$w.f3 {left expand filly}

    return $w.frame
}


proc MainMsg_FSB {} {
    return 	[concat \
		 "The File Selection Box is a standard user interface element"\
		     "for selecting files. It stores the previous selections "\
		     "in Combo Boxes so that they can be retrived quickly."]
}

proc MainMsg_Combo {} {
    return [concat \
	    "The Combo Box is a great space saver when you find your" \
		"interface is too cluttered. Also, for the naive users, " \
		"a Combo Box looks much less imposing that a List Box "]
}

# end of file
