#
# Try and guess the architecture
#
##ARCH != @arch
# Define one or the other:
#OPENVMS = alpha
VAXVMS = vax

.IFDEF OPENVMS
#
# For Alpha/OpenVMS
#
X11_LIB_SWITCHES =	$1$dkb0:[tcl.itcl.src]x11opt-alpha/opt
.ENDIF
.IFDEF VAXVMS
#
# For Vax/VMS
#
X11_LIB_SWITCHES =	$1$dkb0:[tcl.itcl.src]x11opt-vax/opt
.ENDIF

SRC_DIR =	$1$dkb0:[tcl.itcl.src]
TCL_DIR =	[--.tcl73]
TK_DIR =	[--.tk36]

# Libraries to use when linking:  must include at least Tk, Tcl, Xlib,
# and the math library (in that order).  The "" part will be
# replaced (or has already been replaced) with relevant libraries as
# determined by the configure script.
LIBS =	libitcl.olb/libr, $(X11_LIB_SWITCHES)

# To change the compiler switches, for example to change from -O
# to -g, change the following line:

.IFDEF OPENVMS
#
# For Alpha/OpenVMS
#
#CC_SWITCHES = /debug/prefix=all/stand=vaxc/noopt
#OPT_FILE = x11opt-alpha/opt
.ENDIF
.IFDEF VAXVMS
#
# For Vax/VMS
#
CC_SWITCHES = /debug
OPT_FILE = x11opt-vax/opt
.ENDIF
OBJS =  itcl_class.obj, itcl_methods.obj, itcl_util.obj, itcl_core.obj, \
	itcl_objects.obj, itcl_vars.obj

CC =		cc
CFLAGS =	$(CC_SWITCHES) /inc=($(SRC_DIR), $(TCL_DIR), $(TK_DIR)) \
$(AC_FLAGS) $(PROTO_FLAGS) $(SECURITY_FLAGS) $(MEM_DEBUG_FLAGS) \
/def=("NO_FD_SET")

.IFDEF OPENVMS
.c.obj
	def/user compat [-.tcl73.compat]
	def/user decc$user_include compat
	def/user x11 decw$include:
	$(CC) $(CFLAGS) $<
	@ write sys$output ""
.ENDIF

iwish.exe : tkappinit.obj libitcl.olb
	link/exe=$@ tkappinit.obj, $(LIBS)


libitcl.olb :	$(OBJS)
	library/create $@ $(OBJS)

