/*
 *	$Source: /home/nlfm/Working/Frink/RCS/frink.h,v $
 *	$Date: 1995/02/23 11:18:53 $
 *	$Revision: 1.2.1.7 $
 *
 *------------------------------------------------------------------------
 *   AUTHOR:  Lindsay Marshall <lindsay.marshall@newcastle.ac.uk>
 *------------------------------------------------------------------------
 *    Copyright 1994 The University of Newcastle upon Tyne (see COPYRIGHT)
 *========================================================================
 *
 */

extern int lineNumber;
extern int lmargin;
extern int switchIn;
extern int width;
extern int addSpaces;
extern int indent;
extern int contdent;
extern int nocomments;
extern int obfuscate;
extern int tabsOn;
extern int putElse;
extern int putThen;
extern int tabStops;
extern int minimise;
extern int xf;
extern int oneliner;
extern int doBind;
extern int debrace;
extern int trace;
extern int varbrace;
extern int noblanks;
extern int embrace;
extern int procnls;
extern char *style;
extern char *pstyle;
extern char *contString;

typedef struct input_s
{
    char *position;
    int	 remaining;
    int  pushed;
    char back[2];
    char *text;
    FILE *stream;
    int tcall;
    int lineNumber;
} Input;

typedef enum token_e {
    ENDF, ENDLINE, ENDC, LIST, STRING, CONC, CALL, VAR, CPART, SPART,
    CONST, ARRAY, NL, SP, COMMENT, HEAD, LBRACK, LBRACE, LPAREN, DOLLAR,
    VNAME, OSTART, START, XCONT, CONT, RBRACK, RBRACE, BLANK, DQSTART,
    DQEND, SEMI, EM, EN, ECONT, SLIST
} TokenType;

typedef struct token_s
{
    TokenType type;
    char *text;
    int length;
    struct token_s *sequence;
    struct token_s *next;
    char little[32];
    int lineNo;
} Token;

extern void freeToken(Token*);

extern Input *tokenise(char*, int);
extern void untokenise();

extern Token *collect(Input *);
extern Token *accumulate(Input *, int);
extern Token *getToken(Input *);
extern void lprocess(Token*, int);
extern void makeCall(Token*, Token*);
extern void body(Token *, int);

extern void putSeq(Token*, int);
extern void output(Token *, int);
extern void blank();
extern void warn(Token *, char *);
extern void fail(Token *, char *);
