/* 
 * Copyright (c) 1994 Sun Microsystems, Inc. - All Rights Reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL SUN MICROSYSTEMS INC. BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF SUN MICROSYSTEMS
 * INC. HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * SUN MICROSYSTEMS INC. SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND SUN MICROSYSTEMS INC. HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

#include "tcl_thread.h"
#include "tk.h"
#include <errno.h>
#include <sys/types.h>
#include <fcntl.h>

static void MessageReady( ClientData clientData, int mask);

int
Tk_thread_Init( Tcl_Interp * interp)
{
    if ( Tcl_thread_Init( interp) == TCL_ERROR)
	return TCL_ERROR;

    if ( thr_self() == 1)  {
	int fd[2];
	if ( pipe( fd) == -1)  {
	    Tcl_AppendResult( interp, "Tk threads could not init notifier; ",
		strerror( errno), NULL);
	    return TCL_ERROR;
	}
	fcntl( fd[0], F_SETFD, 1);	/* set close-on-exec bit */
	fcntl( fd[1], F_SETFD, 1);
	Tk_CreateFileHandler( fd[0], TK_READABLE, MessageReady, interp);
	MTtcl_MessageNotifierPipe( interp, "thread1", fd);
    }
    return TCL_OK;
}


void
MessageReady( ClientData clientData, int mask)
{
    Tcl_Interp *interp= (Tcl_Interp *) clientData;

    Tcl_Eval( interp, "eval [thread nextmsg]");
}
