'\" 
'\" Copyright (c) 1994 Sun Microsystems, Inc. - All Rights Reserved.
'\"
'\" Permission is hereby granted, without written agreement and without
'\" license or royalty fees, to use, copy, modify, and distribute this
'\" software and its documentation for any purpose, provided that the
'\" above copyright notice and the following two paragraphs appear in
'\" all copies of this software.
'\" 
'\" IN NO EVENT SHALL SUN MICROSYSTEMS INC. BE LIABLE TO ANY PARTY FOR
'\" DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
'\" OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF SUN MICROSYSTEMS
'\" INC. HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'\"
'\" SUN MICROSYSTEMS INC. SPECIFICALLY DISCLAIMS ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
'\" AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
'\" ON AN "AS IS" BASIS, AND SUN MICROSYSTEMS INC. HAS NO OBLIGATION TO
'\" PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
'\"
.so mttcl.macros
.HS share MTtcl
.BS
.SH NAME
share \- Share variables between Tcl threads
.SH SYNOPSIS
\fBshare \fR?\fB-global\fR? \fIvariable \fR?\fIvariable ...?\fR
.BE
 
.SH DESCRIPTION
.PP
The \fBshare\fR command allows variables to be shared between
Tcl threads.  The named variables are entered into the current
scope linked to a shared representation of the variable.  All
threads that share the same variable, share a common value for
the variable.
.LP
If \fB-global\fR is specified, the variable is entered into the
global scope as well as the current scope.
.LP
Use of shared variables is reference counted.  For each thread
and scope that shares a given variable, its reference count is
incremented.  When a scope exits or a thread terminates, the
reference count of variables shared therein are decremented.
When \fB-global\fR is used, the reference count is incremented
once for the entry in the current scope and once for the entry
in the global scope.  Care should be taken when using \fBshare\fR
in procedures.
.SH MT PROGRAMMING
Shared variables are not protected from simultaneous access
from multiple threads.  Use the synchronization facilities of
MTtcl to serialize access to critical variables.
.SH SEE ALSO
mutex(n), sema(n), cond(n), rwlock(n), thread(n)
.SH BUGS
Can't list the shared variables
.sp
The semantics of \fBshare\fR can be surprising
.sp
Sharing code is too difficult
