class TK_INTERPRETER
	-- a Tcl interpreter with tk capability.

inherit 
    TCL_INTERPRETER
	rename make as tcl_make
    end;

creation 
    make

feature

   -- constants for the dialog mode of `show' for this window:
    non_modal : INTEGER is 0;
    wait      : INTEGER is 1;
    grab      : INTEGER is 2;

    window_name :STRING;
	-- name of the main window of this tk interpreter.

    make (win_name : STRING) is
	-- create an interpreter given the name for its main window.
	local c_win_name : ANY;
	do
	    tcl_make;
	    window_name := clone(win_name);
	    c_win_name := win_name.to_c;
	    c_init_tk(interpreter, $c_win_name);
	ensure
	    got_interpreter : interpreter /= Void;
	end; -- make

    show (mode :INTEGER) is
	-- display main window of this tk_interpreter;
	-- semantic of `mode':
	--   non_modal: returns immediately.
	--   wait     : return after window is destructed
	--   grab     : as wait, but forbid input on other windows.
	require
		got_interpreter : interpreter /= Void;
	do
		c_tk_show(interpreter, mode);	
	end;

    close is
	do
	    c_close_win(interpreter);
	end; -- close

feature {TK_INTERPRETER}
   -- implementation:

    c_init_tk (interp : POINTER; win_name : ANY) is
	external "C"
	end; 
     	
    c_tk_show (interp :POINTER; modal_flag :INTEGER) is
	external "C"
	end;

    c_close_win (interp : POINTER) is
	external "C"
	end;
end -- class TK_INTERPRETER

