deferred class TCL_COMMAND
	-- Eiffel commands that can be installed in a tcl interpreter.


feature
    tcl_cmd_name : STRING;
	-- name under which command is known to tcl.

    install (interp : TCL_INTERPRETER; tcl_name : STRING) is
	-- make Current a tcl command of name `tcl_name'.
	require
	    only_one_interpreter : 
		(tcl = Void) or else (tcl = interp);
	local 
	    tcl_string : ANY;
	    interpreter : POINTER;
	do
	    tcl := interp;
	    tcl_string := tcl_name.to_c;
	    tcl_cmd_name := clone(tcl_name);
	    interpreter := tcl.interpreter;
	    c_create_tcl_command(Current, interpreter, 
				 $execute, $tcl_string,
				 $init_args, $set_arg);
	ensure
	    associated: not (tcl = Void);
	end; -- install

    execute is
	-- this is, where you define the action of this command.
	deferred
	end; -- execute

feature {TCL_COMMAND}
   -- data transfer:

    set_tcl_result (res : STRING) is
	-- Set the command result in the associated interpreter.
 	do
	    tcl.set_tcl_result(res);
	end; -- set_tcl_result;
		
    current_tcl_args : ARRAY [STRING];
	-- arguments passed from tcl to this command

    init_args (count : INTEGER) is
	-- callback to set up `current_tcl_args' for consecutive calls
	-- to `set_arg'.
	do
	    !!current_tcl_args.make(1, count);
	end ; -- init_args

    set_arg (arg : ANY; index : INTEGER) is
	-- callback to pass one argument from tcl to this command.
	local
	    str : STRING;
	do
	    !!str.make(0);
	    str.from_c(arg);
	    current_tcl_args.put(str, index);
 	end; -- set_arg

feature {TCL_COMMAND}
   -- implementation:

    tcl : TCL_INTERPRETER;
 
    c_create_tcl_command (cmd : TCL_COMMAND;
			  interp : POINTER;
			  callback :POINTER;
			  cmd_name :ANY;
			  init_args_proc,
			  set_arg_proc :POINTER) is
	external "C"
	end; -- c_create_tcl_command
	
end -- class TCL_COMMAND
