class DEFAULTS_CMD
	-- command to set variables of a TCL_OBJ to default values.

inherit 
    TCL_COMMAND;

creation
    make

feature
    model :TCL_OBJ;
	-- associated TCL_OBJ on which to execute this command.

    default1, default2 : STRING;

    make (a_model :TCL_OBJ; val1, val2 : STRING) is
	-- create and define default values for this instance.
	do
	    model := a_model;
	    default1 := clone(val1);
	    default2 := clone(val2);
	end;

    execute is
	do
	    model.set_vars(default1, default2);
	end; -- execute;

end -- class DEFAULTS_CMD
