#!/usr/local/bin/wish -f

# $Header: /cluster21/kennykb/src/tclTCP/RCS/swatch.tcl,v 1.1 1992/02/14 20:03:21 kennykb Exp kennykb $
# $Source: /cluster21/kennykb/src/tclTCP/RCS/swatch.tcl,v $
# $Log: swatch.tcl,v $
# Revision 1.1  1992/02/14  20:03:21  kennykb
# Initial revision
#

#  Copyright (C) 1992 General Electric. All rights reserved.

#  Permission to use, copy, modify, and distribute this
#  software and its documentation for any purpose and without
#  fee is hereby granted, provided that the above copyright
#  notice appear in all copies and that both that copyright
#  notice and this permission notice appear in supporting
#  documentation, and that the name of General Electric not be used in
#  advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#  General Electric makes no representations about the suitability of
#  this software for any purpose.  It is provided "as is"
#  without express or implied warranty.

#  This work was supported by the DARPA Initiative in Concurrent
#  Engineering (DICE) through DARPA Contract MDA972-88-C-0047.

# This is a client to the master color server.  It displays a view of the
# current color.

# Start a server so we can get updates

set s [tcp server]
$s start
set p [$s config -port]

# Connect to the master server

set c [tcp connect localhost 2324]

# Build the display

message .text -text "The frame to the right of this message shows the color being maintained by the ``master'' application."

frame .swatch
frame .swatch.vstrut -geometry 1x100
frame .swatch.hstrut -geometry 100x1
pack append .swatch .swatch.vstrut {left} .swatch.hstrut {top}

button .quit -text "Quit" -command "destroy ."

pack append . .text {left expand fill} \
	.swatch {left expand} \
	.quit {left expand filly}

# Define a local procedure to receive a new set of colors and update the
# swatch

proc newcolors {red green blue} {
	.swatch config -background \
		[format #%02x%02x%02x $red $green $blue]
}

# Get a name for this application in the master server

set myname [$c send gensym swatch]

# Define a procedure in the master server to update our colors

$c send eval [format {
    proc %s.update args {
	global red
	global green
	global blue
	global %s.connection
	${%s.connection} send newcolors $red $green $blue
    }} $myname \
	$myname\
	$myname]

# Remove traces when we exit

bind .swatch <Destroy> {
	$c send trace vdelete red w $myname.update
	$c send trace vdelete green w $myname.update
	$c send trace vdelete blue w $myname.update
	$c send rename $myname.update {}
	set action "\$\{$myname.connection\} close"
	$c send eval $action
}

# Make the master server open a connection to us

set action [format {
		set %s.connection [tcp connect localhost %d]
		%s.update
		${%s.connection} send after 10 startTracing
	} $myname $p \
	  $myname \
	  $myname \
	  $myname]
$c send after 10 $action

# Set up the traces in the master server

proc startTracing {} {
	global c
	global myname
	$c send trace variable red w $myname.update
	$c send trace variable green w $myname.update
	$c send trace variable blue w $myname.update
}


