'\"
'\" Copyright (c) 1993 by Sven Delmas
'\" All rights reserved.
'\" See the file COPYRIGHT for the copyright notes.
'\" 
'\" $Header: tkemacs.n[10.0] Sun Oct  2 11:53:35 1994 garfield@mydomain.de frozen $
'/" 
.\" The definitions below are for supplemental macros used in Sprite
.\" manual entries.
.\"
.\" .HS name section [date [version]]
.\"	Replacement for .TH in other man pages.  See below for valid
.\"	section names.
.\"
.\" .AP type name in/out [indent]
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS [type [name]]
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .VS
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
'\"	# Heading for Sprite man pages
.de HS
.if '\\$2'cmds'       .TH \\$1 1 \\$3 \\$4
.if '\\$2'lib'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tcl'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tk'         .TH \\$1 3 \\$3 \\$4
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp .5
..
.HS tkemacs cmds
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
tkemacs \- Create and manipulate tkemacs widgets
.SH SYNOPSIS
\fBtkemacs\fI \fIpathName \fR?\fIoptions\fR?
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBbackground\fR	\fBforeground\fR	\fBinsertWidth\fR	\fBselectBorderWidth\fR
\fBborderWidth\fR	\fBinsertBackground\fR	\fBpadX\fR	\fBselectForeground\fR
\fBcursor\fR	\fBinsertBorderWidth\fR	\fBpadY\fR	\fBsetGrid\fR
\fBexportSelection\fR	\fBinsertOffTime\fR	\fBrelief\fR	\fBxScrollCommand\fR
\fBfont\fR	\fBinsertOnTime\fR	\fBselectBackground\fR	\fByScrollCommand\fR
.fi
.LP
See the ``options'' manual entry for details on the standard options.
.SH "WIDGET-SPECIFIC OPTIONS"
.LP
.nf
Name:	\fBcommand\fR
Class:	\fBCommand\fR
Command-Line Switch:	\fB\-command\fR
.fi
.IP
Specifies the emacs executable that is called as background emacs.
The default name is \fBTkEmacs\fR.
.LP
.nf
Name:	\fBdebug\fR
Class:	\fBDebug\fR
Command-Line Switch:	\fB\-debug\fR
.fi
.IP
Turns on/off the debugging for the widget.
.LP
.nf
Name:	\fBendSource\fR
Class:	\fBEndSource\fR
Command-Line Switch:	\fB\-endsource\fR
.fi
.IP
Specifies lisp code that is sent to emacs right before the emacs is
terminated.
.LP
.nf
Name:	\fBerrorCallback\fR
Class:	\fBErrorCallback\fR
Command-Line Switch:	\fB\-errorcallback\fR
.fi
.IP
Specifies a tcl procedure that is called if an error is received
from emacs. The procedure gets two parameters. The first parameter
is the name of the tkemacs widget, and the second parameter is the
error message from emacs.
.LP
.nf
Name:	\fBfile\fR
Class:	\fBFile\fR
Command-Line Switch:	\fB\-file\fR
.fi
.IP
Specifies the file that is loaded in the emacs when the widget is
created. This file represents the text you want to edit.
.LP
.nf
Name:	\fBgeometry\fR
Class:	\fBGeometry\fR
Command-Line Switch:	\fB\-geometry\fR
.fi
.IP
This option is ignored.
.LP
.nf
Name:	\fBheight\fR
Class:	\fBHeight\fR
Command-Line Switch:	\fB\-height\fR
.fi
.IP
Specifies the desired height of the window in pixels.
.LP
.nf
Name:	\fBlispFile\fR
Class:	\fBLispFile\fR
Command-Line Switch:	\fB\-lispfile\fR
.fi
.IP
Specifies the lispfile that is loaded in the emacs when the widget
is created. This lisp code connects to the widget, and provides
the lisp functions that are necessary for the widget. The default
value is tkemacs.el.
.LP
.nf
Name:	\fBname\fR
Class:	\fBName\fR
Command-Line Switch:	\fB\-name\fR
.fi
.IP
Specifies the name of the window that will appear on the
screen. This name is used to select the window for
reparenting.
.LP
.nf
Name:	\fBreparent\fR
Class:	\fBReparent\fR
Command-Line Switch:	\fB\-reparent\fR
.fi
.IP
Specifies whether or not the emacs should be reparented to a
Tk widget. If this option is set to 0, the external emacs is
not reparented, but the emacs can be accessed like a normal
Tk widget.
.LP
.nf
Name:	\fBstartSource\fR
Class:	\fBStartSource\fR
Command-Line Switch:	\fB\-startsource\fR
.fi
.IP
Specifies the lisp code that is sent to emacs right after the emacs 
has been started.
.LP
.nf
Name:	\fBstate\fR
Class:	\fBState\fR
Command-Line Switch:	\fB\-state\fR
.fi
.IP
This option is ignored.
.LP
.nf
Name:	\fBtimeout\fR
Class:	\fBTimeout\fR
Command-Line Switch:	\fB\-timeout\fR
.fi
.IP
Specifies a timeout for the communication between emacs and the widget.
If a command has been sent and does not return a value after this
interval, the widget aborts this command (the timeout is
used in a while statement and is counted to zero).
.LP
.nf
Name:	\fBuseAdvise\fR
Class:	\fBUseAdvise\fR
Command-Line Switch:	\fB\-useadvise\fR
.fi
.IP
The update of the scrollbars is done by wrapping an update command
around most of the commands that could change the size and position
of the scrollbar. This will cause traffic between emacs and the
widget, which can be avoided by setting this option to false. In
this case, there are no wrappers.
.LP
.nf
Name:	\fBwidth\fR
Class:	\fBWidth\fR
Command-Line Switch:	\fB\-width\fR
.fi
.IP
Specifies the desired width of the window in pixels.
.LP
.nf
Name:	\fBwrap\fR
Class:	\fBWrap\fR
Command-Line Switch:	\fB\-wrap\fR
.fi
.IP
This option is ignored.
.BE

.SH DESCRIPTION
.PP
The \fBtkemacs\fR command creates a new window (given by the
\fIpathName\fR argument) and makes it into a tkemacs widget.
Additional options, as described above, may be specified on the
command line or in the option database to configure aspects
of the tkemacs such as its default background color and relief.
The \fBtkemacs\fR command returns the path name of the new
window.
.PP
A tkemacs widget displays one or more lines of text and allows
this text to be edited. To display and edit the text, an
external emacs is used, the output of which is redirected to
the widget window.
.PP
The tkemacs widget tries to be as compatible to the text
widget as possible. At some points the widget is incompatible,
because some concepts of the text widget cannot be provided
with emacs (or it was too tough at this moment :-).

.SH INDICES
.PP
Many of the widget commands for tkemacs take one or more indices
as arguments. An index is a string used to indicate a particular
position within a text, such as a place to insert characters or an
endpoint of a range of characters to delete. Indices have the
syntax
.IP
\fIbase modifier\fR
.LP
where \fIbase\fR gives a starting point and the \fImodifier\fR
adjusts the index from the starting point (e.g. move forward or
backward one character).  Every index must contain a \fIbase\fR,
but the \fImodifier\fR is optional.
.LP
The \fIbase\fR for an index must have one of the following forms:
.TP 12
\fIline\fB.\fIchar\fR
Indicates \fIchar\fR'th character on line \fIline\fR.
Lines are numbered from 0, which is different from the numbering
in the text widget. Within a line, characters are numbered from 0.
.TP 12
\fIcharpos\fR
This references the \fIcharpos\fR'th character, where charpos is
calculated by counting all characters from the beginning of the
file.
.TP 12
\fBend\fR
Indicates the last character in the text.
.TP 12
\fImark\fR
Indicates the character just after the mark the name of which
is \fImark\fR.
.TP 12
\fBtop\fR
Indicates the first character in the text.
.LP
If a modifier follows the base index, it must have one of the forms
listed below. Keywords such as \fBchars\fR and \fBwordend\fR may
be abbreviated as long as the abbreviation is unambiguous.
.TP
\fB+ \fIcount\fB chars\fR
Adjusts the index forward by \fIcount\fR characters, moving to later
lines in the text if necessary.  If there are less than \fIcount\fR
characters in the text after the current index, set the index
to the last character in the text.
Spaces on either side of \fIcount\fR are optional.
.TP
\fB\- \fIcount\fB chars\fR
Adjusts the index backward by \fIcount\fR characters, moving to earlier
lines in the text if necessary.  If there are less than \fIcount\fR
characters in the text before the current index, set the index
to the first character in the text.
Spaces on either side of \fIcount\fR are optional.
.TP
\fB+ \fIcount\fB lines\fR
Adjusts the index forward by \fIcount\fR lines, retaining the same
character position within the line.  If there are less than \fIcount\fR
lines after the line containing the current index, set the index
to refer to the same character position in the last line of the text.
Then, if the line is not long enough to contain a character at the indicated
character position, adjust the character position to refer to the last
character of the line (the newline character).
Spaces on either side of \fIcount\fR are optional.
.TP
\fB\- \fIcount\fB lines\fR
Adjusts the index backward by \fIcount\fR lines, retaining the same
character position within the line.  If there are less than \fIcount\fR
lines before the line containing the current index, then set the index
to refer to the same character position on the first line of the text.
Then, if the line is not long enough to contain a character at the indicated
character position, adjust the character position to refer to the last
character of the line (the newline).
Spaces on either side of \fIcount\fR are optional.
.TP
\fBlinestart\fR
Adjusts the index to refer to the first character in the line.
.TP
\fBlineend\fR
Adjusts the index to refer to the last character in the line
(the newline character).
.TP
\fBwordstart\fR
Adjusts the index to refer to the first character of the word containing
the current index.  A word consists of a number of adjacent characters
that are letters, digits, or underscores, or a single character that
is not one of these.
.TP
\fBwordend\fR
Adjusts the index to refer to the character just after the last one of the
word containing the current index.  If the current index refers to the last
character of the text, it is not modified.
.LP

.SH TAGS
.PP
Tags are not implemented by the tkemacs widget.

.SH MARKS
.PP
Only the mark \fBinsert\fR is implemented. The mark may be
manipulated with the ``\fIpathName \fBmark\fR'' widget
command, and the current location may be determined by using
the mark name as an index in widget commands. The mark
\fBinsert\fR is associated with the insertion cursor, as
described under THE INSERTION CURSOR below.

.SH "THE SELECTION"
.PP
Tkemacs widgets support the standard X selection, what means
emacs handles X selections.

.SH "THE INSERTION CURSOR"
.PP
The mark named \fBinsert\fR has special significance in tkemacs
widgets. It is defined automatically when a tkemacs widget is
created and it may not be unset with the ``\fIpathName \fBmark
unset\fR'' widget command. The \fBinsert\fR mark represents the
position of the insertion cursor, and the insertion cursor will
automatically be drawn to this point whenever the tkemacs widget
has the input focus.

.SH "WIDGET COMMAND"
.PP
The \fBtkemacs\fR command creates a new Tcl command the name
of which is the same as the path name of the tkemacs's window.
This command may be used to invoke various operations on the
widget. It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIPathName\fR is the name of the command, which is the same as
the tkemacs widget's path name. \fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for tkemacs widgets:
.TP
\fIpathName \fBcompare\fR \fIindex1 op index2\fR
Compares the indices given by \fIindex1\fR and \fIindex2\fR according
to the relational operator given by \fIop\fR, and returns 1 if
the relationship is satisfied and 0 if it isn't.
\fIOp\fR must be one of the operators <, <=, ==, >=, >, or !=.
If \fIop\fR is ==, then 1 is returned if the two indices refer to
the same character, if \fIop\fR is <, then 1 is returned if \fIindex1\fR
refers to an earlier character in the text than \fIindex2\fR, and
so on.
.TP
\fIpathName \fBconfigure\fR ?\fIoption\fR? \fI?value option value ...\fR?
Queries or modifies the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named "option" (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case, the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBtkemacs\fR
command.
.TP
\fIpathName \fBdebug \fR?\fIboolean\fR?
If \fIboolean\fR is specified, it must have the value 0 or 1.
If the value is a 1, you will see some debugging information.
If \fIboolean\fR is a 0, the debugging checks will be turned off.
In either case the command returns an empty string.
If \fIboolean\fR is not specified, the command returns \fB1\fR
or \fB0\fR to indicate whether or not debugging is turned on.
.TP
\fIpathName \fBdelete \fIindex1 \fR?\fIindex2\fR?
Deletes a range of characters from the text.
If both \fIindex1\fR and \fIindex2\fR are specified, it deletes
all the characters starting with the one given by \fIindex1\fR
and stopping just before \fIindex2\fR (i.e. the character at
\fIindex2\fR is not deleted).
If \fIindex2\fR doesn't specify a position later in the text
than \fIindex1\fR then no characters are deleted.
If \fIindex2\fR isn't specified, the single character at
\fIindex1\fR is deleted.
The command returns the deleted text.
.TP
\fIpathName \fBget\fR ?\fIindex1\fR? ?\fIindex2\fR?
Returns a range of characters from the text.
The return value will be all the characters in the text starting
with the one the index of which is \fIindex1\fR and ending just
before the one with the index \fIindex2\fR (the character at
\fIindex2\fR will not be returned).
If no \fIindex2\fR is specified, the end is assumed for
\fIindex2\fR. If \fIindex1\fR and \fIindex2\fR are omitted,
the complete text is returned.
If there are no characters in the specified range (e.g. \fIindex1\fR
is past the end of the file or \fIindex2\fR is less than or equal
to \fIindex1\fR), an empty string is returned.
.TP
\fIpathName \fBindex \fIindex\fR
Returns the position corresponding to \fIindex\fR in the form
\fIcharpos\fR where \fIcharpos\fR is the position of the character
counted from the beginning of the file.
\fIIndex\fR may have any of the forms described under INDICES above.
.TP
\fIpathName \fBinsert \fIindex chars
Inserts \fIchars\fR into the text just before the character at
\fIindex\fR and returns an empty string.
.TP
\fIpathName \fBmark \fIoption \fR?\fIarg arg ...\fR?
This command is used to manipulate marks.  The exact behavior of
the command depends on the \fIoption\fR argument that follows
the \fBmark\fR argument.  The following forms of the command
are currently supported:
.RS
.TP
\fIpathName \fBmark names\fR
Not implemented.
.TP
\fIpathName \fBmark set \fImarkName index\fR
This is only implemented for the mark named \fBinsert\fP.
.TP
\fIpathName \fBmark unset \fImarkName \fR?\fImarkName markName ...\fR?
Not implemented.
.RE
.TP
\fIpathName \fBredisplay\fR
This command redisplays the widget.
.TP
\fIpathName \fBreparent ?windowid?\fR
This command reparents the given window id to the tkemacs
widget. If no window id is passed, the \fI-name\fR option is
used to wait for the appearance of a window with this name.
This method is most portable.
.TP
\fIpathName \fBreparent0 windowid\fR
This command reparents the given window id to the tkemacs
widget.
.TP
\fIpathName \fBreparent1 windowid\fR
This command reparents the parent of the given window id to
the tkemacs widget.
.TP
\fIpathName \fBreparent2 windowid\fR
This command reparents the parent of the parent of the given
window id to the tkemacs widget.
.TP
\fIpathName \fBreparent3 windowid\fR
This command reparents the parent of the parent of the parent
of the given window id to the tkemacs widget.
.TP
\fIpathName \fBreset\fR
This command resets the internal protocol handling. This command
is usually of no interest for the "standard" user.
.TP
\fIpathName \fBscan\fR \fIoption args\fR
Not implemented.
.TP
\fIpathName \fBsend\fR lisp-code
This command sends the given lisp-code to emacs. Emacs evaluates this
code and returns a value.
.TP
\fIpathName \fBsendnowait\fR lisp-code
This command sends the given lisp-code to emacs. Emacs evaluates this
code. The send command does not wait for a result.
.TP
\fIpathName \fBsetxscroll\fR totalUnits windowUnits firstUnit lastUnit
This command is called to set the x-scrollbar to the correct size
and position. Usually this command is only called by the emacs code.
.TP
\fIpathName \fBsetyscroll\fR totalUnits windowUnits firstUnit lastUnit
This command is called to set the y-scrollbar to the correct size
and position. Usually this command is only called by the emacs code.
.TP
\fIpathName \fBstopemacs\fR
This command stops the emacs that is linked with the emacs widget. This
is usually done automatically when the widget is destroyed.
.TP
\fIpathName \fBtag \fIoption \fR?\fIarg arg ...\fR?
Not implemented.
.TP
\fIpathName \fBxview \fR?\fB\-pickplace\fR? \fIwhat\fR
This command changes the view at the widget's window so that the column
given by \fIwhat\fR is visible in the window.
\fIWhat\fR may be an absolute column number which is used in the
commands issued by scrollbars to control the widget's view.
.TP
\fIpathName \fByview \fR?\fB\-pickplace\fR? \fIwhat\fR
This command changes the view at the widget's window so that the line
given by \fIwhat\fR is visible in the window.
\fIWhat\fR may be an absolute line number which is used in the
commands issued by scrollbars to control the widget's view.
.RE

.SH BINDINGS
.PP
The tkemacs widget does not allow Tk bindings. This is
because reparenting is used which means that the events are
passed directly to the child widget.

.SH COMPATIBILITY
.PP
The tkemacs widget tries to be as compatible to the text widget
as possible. The following features are not implemented:
.IP "" 15
tags,
.IP "" 15
marks,
.IP "" 15
scan,
.IP "" 15
indices with multiple modifiers,
.IP "" 15
and some more I have forgotten to mention :-).
.LP

.PP
The following resources are not implemented:
.IP "" 15
-exportselection,
.IP "" 15
-insertborderwidth,
.IP "" 15
-insertofftime,
.IP "" 15
-insertontime,
.IP "" 15
-insertwidth,
.IP "" 15
-padx,
.IP "" 15
-pady,
.IP "" 15
-selectborderwidth,
.IP "" 15
-setgrid,
.IP "" 15
-state,
.IP "" 15
-wrap.

.SH IMPLEMENTATION
.PP
I tried to keep the changes to Tk as small as possible
(smaller than for the old version of TkEmacs). The changes
to Tk only add one new command to Tk (xaccess). If you don't
use the new command, you will not notice any changes
compared to the standard wish. Emacs requires no changes.
.PP
The basic concept of this widget is that the emacs lisp
code reparents the emacs main window into the window of the
tkemacs widget. Certain events passed to the Tk window are
passed to the emacs window.
.PP
Apart from these mechanisms for passing X11 events and
displaying the output of emacs in the widget window, the
communication between the widget and emacs is done via a tcp
connection. The communication follows a simple protocol.
.PP
Each line that is sent via the communication channel begins
with a special token. There are five types of tokens.
.IP "\fBCMD:\fR" 15
This token indicates that the following data is a command
that is to be evaluated by Tcl/Tk or emacs. A command
can consist of many lines, each beginning with this token.
The end of the command is represented by the token \fBEND:\fR.
The evaluation of a command produces a result string that
is returned with the token \fBRET:\fR.
.IP "\fBRET:\fR" 15
This token indicates that the following data is a result
of a command execution. This returned data can also be
a number of lines terminated with a final \fBEND:\fR.
.IP "\fBERR:\fR" 15
This token indicates that the following data is an error
message. An error message is only one line, and is not
terminated with \fBEND:\fR.
.IP "\fBRST:\fR" 15
This token resets the communication channel.
.IP "\fBEND:\fR" 15
As already explained, the tokens \fBCMD:\fR and \fBRET:\fR
are terminated with this token. This token follows in the
following line.

.SH "PERFORMANCE ISSUES"
.PP
Performance is a critical point with the tkemacs widget.
Each created widget has a complete emacs process. This means
that you should be careful with the number of widgets. The
handling of the scrollbars leads to a relatively high
traffic between emacs and the widget. On slow machines, this
will make scrolling a pain. On these machines, it is probably
a better solution to switch off the permanent updating with
the option -useadvice.

.SH BUGS
.PP
.\"
.IP "\(bu"
The byte compiled version of cl.el that is distributed
with emacs 18.59 seems to make problems. To get a working
TkEmacs remove, the file cl.elc and/or recompile cl.el.
.\"
.IP "\(bu"
If the Emacs Lisp function "y-or-n-p" is called from a
process filter, i.e. from the tkemacs widget, it cannot be
interrupted with C-g due to an already known bug in Emacs
18.58. On some machines, this will result in the abort of
Emacs (possibly with a core dump), on others in an endless
loop with Emacs emitting an (also) endless loop of beeps.
In this case it may be difficult to kill the process because
the X server is busy beeping. In Emacs 18.59 this problem
seems to be solved for some OS versions.
.\"
.IP "\(bu"
The connection between the tkemacs widget and emacs is
relatively loose. That means that especially the scrollbar
handling may not always be correct.
.\"
.IP "\(bu"
If event processing in wish is blocked for a long time,
it can happen that the polling of the scrollbar destroys
a previous result from emacs (at least that is the
explanation I found :-).
.IP "\(bu"
On my System V Release 4 (Esix) I had massive problems with
tclRawTCP. This was fixed by inserting an fprintf (I hate
this kind of fixing). This fix is by default activated
with the define MY_SYSVR4_FIX in the file ./tcl/tclRawTCP.c.
.IP "\(bu"
On my System V Release 4 (Esix) I had massive problems with
tcl-DP. The connection does simply not work (maybe it's
time to change the OS :-).
.\"
.IP "\(bu"
Surely, there are many bugs.

.SH KEYWORDS
emacs, widget, xaccess
