#-----------------------------------------------------------------------------
# MODULE mkQuit
#
# This module is a part of the Visual Ising Machine
#-----------------------------------------------------------------------------

#-----------------------------------------------------------------------------
# mkQuit w
#
# Build a dialogbox that asks the user whether to quit or not. This
# procedure is invoked on every DELETE_WINDOW event in VIM.
#
# Arguments:
#	w -	window
#-----------------------------------------------------------------------------
proc mkQuit {{w .quitdlg}} {
	catch {destroy $w}
	toplevel $w

	wm title $w "VIM\[Quit\]"
	wm protocol $w WM_DELETE_WINDOW "set dummy 1"

	set msgF [mkQtMessage $w]
	set btnsF [mkQtButtons $w]

	pack $msgF -side top -fill both -expand yes
	pack $btnsF -fill both -expand yes
}

#-----------------------------------------------------------------------------
# mkQtMessage top
#
# Build a frame that holds a message
#
# Arguments:
# 	top -	toplevel window
#-----------------------------------------------------------------------------
proc mkQtMessage {top} {
	set w [frame $top.msgF -relief raised -bd 1]
	
	message $w.msg 	-font -*-helvetica-bold-r-normal-*-17-*-*-*-*-*-*-* \
			-relief sunken -bd 1 -padx 20 -width 400 \
			-text {

You are about to exit VIM...

}
	pack $w.msg -expand yes -fill both -padx 10 -pady 10
	
	return $w
}

#-----------------------------------------------------------------------------
# mkQtButtons top
#
# Build a frame that holds two dialog buttons
#
# Arguments:
# 	top -	toplevel window
#-----------------------------------------------------------------------------
proc mkQtButtons {top} {
	set w [tixDlgBtns $top.btnsF]
	$w add ok -text Ok -command "quitVIM" -width 7
	$w add cancel -text Cancel -command "destroy $top" -width 7

	return $w
}
