 #########################################################################
 #                                                                       #
 # Copyright (C) 1993 by General Electric company.  All rights reserved. #
 #                                                                       #
 # Permission to use, copy, modify, and distribute this                  #
 # software and its documentation for any purpose and without            #
 # fee is hereby granted, provided that the above copyright              #
 # notice appear in all copies and that both that copyright              #
 # notice and this permission notice appear in supporting                #
 # documentation, and that the name of General Electric not be used in   #
 # advertising or publicity pertaining to distribution of the            #
 # software without specific, written prior permission.                  #
 #                                                                       #
 # General Electric makes no representations about the suitability of    #
 # this software for any purpose.  It is provided ``as is''              #
 # without express or implied warranty.                                  #
 #                                                                       #
 # This work was supported in part by the DARPA Initiative in Concurrent #
 # Engineering (DICE) through DARPA Contracts MDA972-88-C-0047 and       #
 # MDA972-92-C-0027.                                                     #
 #                                                                       #
 # This work was supported in part by the Tri-Services Microwave and     #
 # Millimeter-Wave Advanced Computational Environment (MMACE) program    #
 # under Naval Research Laboratory contract N00014-92-C-2044.            #
 #                                                                       #
 #########################################################################


# File:	trace.tcl
#
# Description:
#	Procedures to facilitate tracing operations in Tcl

 # $Id: trace.tcl,v 1.10 1994/10/27 18:29:42 kennykb Exp $
 # $Source: /tmp_mnt/projects/cliff/iam/all/src/tkauxlib/RCS/trace.tcl,v $
 # $Log: trace.tcl,v $
 # Revision 1.10  1994/10/27  18:29:42  kennykb
 # Release 2.0 -- 10-27-94.  To be uploaded to archive sites.
 #
 # Revision 1.9  1993/11/01  18:20:46  kennykb
 # Beta release to be announced on comp.lang.tcl
 #
 # Revision 1.8  1993/10/27  15:52:49  kennykb
 # Package for alpha release to the Net, and for MMACE 931101 release.
 #
 # Revision 1.7  1993/10/20  19:10:47  kennykb
 # Alpha release #1 was thawed for bug fixes in tk 3.3.  Now frozen again at this
 # point.
 #
 # Revision 1.6  1993/10/20  19:06:24  kennykb
 # Repaired copyright notice so that it doesn't look like structured commentary.
 #
 # Revision 1.5  1993/10/14  18:15:42  kennykb
 # Cleaned up alignment of log messages, to avoid problems extracting
 # structured commentary.
 #
 # Revision 1.4  1993/10/14  18:06:59  kennykb
 # Added GE legal notice to head of file in preparation for release.
 #
 # Revision 1.3  1993/10/14  14:02:02  kennykb
 # Alpha release #1 frozen at this point.
 #
 # Revision 1.2  1993/07/21  19:44:36  kennykb
 # Finished cleaning up structured commentary.
 #
 # Revision 1.1  1993/06/03  15:33:10  kennykb
 # Initial revision
 #

# Procedure:	trace_action
#
# Synopsis:
#	Standard function body for trace procedures.
#
# Usage:
#c	trace_action v1 v2 op { Tcl commands }
#
# Parameters:
#c	v1, v2, op
#		The three arguments to a procedure invoked in response to
#		a `trace' event.
#c	Tcl commands
#		A set of Tcl commands to execute
#
# Description:
#	The `trace_action' procedure both simplifies the process of tracing
#	variables and makes it more robust.  Given the arguments of a trace
#	handler, it executes a set of Tcl commands with the following variables
#	set.
#
#c	$name
#		Name of the variable that caused the trace
#c	$value
#		Value of the variable that caused the trace.
#
#	If an error occurs, in addition to causing the trace to deny access to
#	the variable, it causes the error to be resignalled as a background
#	error.  This allows more ready debugging of trace procedures that
#	do not enforce access to the variables.
#
# Example:
#c	trace variable foo w valueTrace
#
#c	proc valueTrace {v1 v2 op} {
#
#c		trace_action v1 v2 op {
#
#c			puts stderr "valueTrace: $name set to $value"
#
#c		}
#
#c	}

proc trace_action {n1 n2 op action} {
	uplevel 1 [list upvar 1 $n1 var]
	if {$n2 == ""} {
		uplevel 1 [list set name $n1]
		uplevel 1 [list set value [uplevel 1 set var]]
	} else {
		uplevel 1 [list set name ${n1}($n2)]
		uplevel 1 [list set value [uplevel 1 set var($n2)]]
	}
	set status [catch {uplevel 1 $action} result]
	if {$status != 0} {
		global errorInfo
		global errorCode
		set info $errorInfo
		for {set i [expr [info level]-1]} {$i > 0} {incr i -1} {
			append info "\n\
    invoked from within\n\
[info level $i]"
		}
		append info "\n\
    (invoked in response to trace on `[uplevel 1 set name]')"
		after 1 error [list $result] [list $info] [list $errorCode]
		error $result $errorInfo $errorCode
	}
}
