 #########################################################################
 #                                                                       #
 # Copyright (C) 1993 by General Electric company.  All rights reserved. #
 #                                                                       #
 # Permission to use, copy, modify, and distribute this                  #
 # software and its documentation for any purpose and without            #
 # fee is hereby granted, provided that the above copyright              #
 # notice appear in all copies and that both that copyright              #
 # notice and this permission notice appear in supporting                #
 # documentation, and that the name of General Electric not be used in   #
 # advertising or publicity pertaining to distribution of the            #
 # software without specific, written prior permission.                  #
 #                                                                       #
 # General Electric makes no representations about the suitability of    #
 # this software for any purpose.  It is provided ``as is''              #
 # without express or implied warranty.                                  #
 #                                                                       #
 # This work was supported in part by the DARPA Initiative in Concurrent #
 # Engineering (DICE) through DARPA Contracts MDA972-88-C-0047 and       #
 # MDA972-92-C-0027.                                                     #
 #                                                                       #
 # This work was supported in part by the Tri-Services Microwave and     #
 # Millimeter-Wave Advanced Computational Environment (MMACE) program    #
 # under Naval Research Laboratory contract N00014-92-C-2044.            #
 #                                                                       #
 #########################################################################


# File: scaleAux.tcl

# Description:
#	Procedures allowing keyboard traversal of scale widgets.

 # $Id: scaleAux.tcl,v 1.16 1994/10/27 18:29:42 kennykb Exp $
 # $Source: /tmp_mnt/projects/cliff/iam/all/src/tkauxlib/RCS/scaleAux.tcl,v $
 # $Log: scaleAux.tcl,v $
 # Revision 1.16  1994/10/27  18:29:42  kennykb
 # Release 2.0 -- 10-27-94.  To be uploaded to archive sites.
 #
 # Revision 1.15  1993/11/01  18:20:46  kennykb
 # Beta release to be announced on comp.lang.tcl
 #
 # Revision 1.14  1993/10/27  15:52:49  kennykb
 # Package for alpha release to the Net, and for MMACE 931101 release.
 #
 # Revision 1.13  1993/10/20  19:10:47  kennykb
 # Alpha release #1 was thawed for bug fixes in tk 3.3.  Now frozen again at this
 # point.
 #
 # Revision 1.12  1993/10/20  19:04:11  kennykb
 # Repaired copyright notice so that it doesn't look like structured commentary.
 #
 # Revision 1.11  1993/10/14  18:15:42  kennykb
 # Cleaned up alignment of log messages, to avoid problems extracting
 # structured commentary.
 #
 # Revision 1.10  1993/10/14  18:06:59  kennykb
 # Added GE legal notice to head of file in preparation for release.
 #
 # Revision 1.9  1993/10/14  14:02:02  kennykb
 # Alpha release #1 frozen at this point.
 #
 # Revision 1.8  1993/09/02  18:43:29  kennykb
 # Repaired commentary that was messing up the structured-comment extractor.
 #
 # Revision 1.7  1993/08/03  13:42:39  kennykb
 # Commented out accelerated scale motion for now.  It seems nice with
 # TWICE, where the scales are 1000 units long, but it's awkward with short
 # ones.
 #
 # Revision 1.6  1993/08/02  22:22:09  kennykb
 # Corrected sdrawkcab action of arrow keys.
 #
 # Revision 1.5  1993/07/22  21:04:22  kennykb
 # Corrected bad binding for gainFocus and loseFocus in scale_bindForTraversal.
 #
 # Revision 1.4  1993/07/21  19:44:36  kennykb
 # Finished cleaning up structured commentary.
 #
 # Revision 1.3  1993/07/20  19:17:12  kennykb
 # Improved structured comments.
 # Changed modules through `g' in the alphabet to follow `:' and `_' naming
 # conventions.
 #
 # Revision 1.2  1993/07/16  15:58:00  kennykb
 # Renamed all commands that start with `wiget.' to either `widget_' or
 # `widget:'.  Added the code for creating composite widgets.
 #
 # Revision 1.1  1993/06/03  15:31:27  kennykb
 # Initial revision
 #

# Procedure:	scale:gainFocus
#
# Synopsis:
#	Internal procedure to handle keyboard focus directed to a scale widget.
#
# Usage:
#c	scale:gainFocus pathName
#
# Parameters:
#c	pathName
#		Path name of a scale widget.
#
# Return value:
#	None.
#
# Description:
#	scale:gainFocus handles directing keyboard focus to a scale widget.
#	It changes the `foreground' color of the scale to its `active
#	foreground'

proc scale:gainFocus w {
	global scale_priv
	set scale_priv(fg,$w) [lindex [$w config -foreground] 4]
	$w config -foreground [lindex [$w config -activeforeground] 4]
}

# Procedure:	scale:loseFocus
#
# Synopsis:
#	Internal procedure to handle keyboard focus directed away from a
#	scale widget.
#
# Usage:
#c	scale:loseFocus pathName
#
# Parameters:
#c	pathName
#		Path name of a scale widget.
#
# Return value:
#	None.
#
# Description:
#	scale:loseFocus handles directing keyboard focus away from a scale
#	widget. It changes the `foreground' color of the scale back to its
#	`normal foreground'

proc scale:loseFocus w {
	global scale_priv
	$w config -fg $scale_priv(fg,$w)
	unset scale_priv(fg,$w)
}

# Procedure:	scale:incr
#
# Synopsis:
#	Internal procedure to adjust the value in a scale widget.
#
# Usage:
#c	scale:incr pathName amount key
#
# Parameters:
#c	pathName
#		Path name of a scale widget.
#c	amount
#		Decimal integer giving the amount by which the scale is to
#		be adjusted.
#c	key
#		ASCII character corresponding to the key that was pressed.
#
# Return value:
#	None.
#
# Description:
#	scale:incr handles increasing and decreasing the value of a scale
#	in response to keyboard events.  The second argument is the amount
#	by which to adjust the scale.  The third is the key that requested
#	the adjustment; it is given because the arrow keys adjust in the
#	direction of the arrow (and the scale may be reversed!), while the
#	"+" and "-" keys adjust numerically.

proc scale:incr {w {amount 1} {key ""}} {
	set from [lindex [$w config -from] 4]
	set to [lindex [$w config -to] 4]
	if {$to < $from} {
		set min $to
		set max $from
	} else {
		set min $from
		set max $to
	}
	if {$to < $from && $key != "+" && $key != "-"} {
		set amount -amount
	} 
	set v [expr [$w get]+$amount]
	if {$v < $min} {
		set v $min
	}
	if {$v > $max} {
		set v $max
	}
	$w set $v
}

# Procedure:	scale_bindForTraversal
#
# Synopsis:
#	Establish keyboard bindings for scale widgets.
#
# Usage:
#c	scale_bindForTraversal pathOrClass...
#
# Parameters:
#c	pathOrClass
#		Either the path name of a widget, or the name of the Scale
#		class
#
# Return value:
#	None.
#
# Description:
#	scale_bindForTraversal establishes the default keyboard bindings for
#	either the specified set of widgets or for the Scale class.  It
#	includes the following:
#	- Color change to reflect the keyboard focus.
#	- <Left>, <Up>, <Right>, and <Down> arrows,
#	  and the <plus> and <minus> keys, increment and decrement
#	  the value of the scale as appropriate.
#	- Repeated presses of the keys above increment and decrement
#	  by successively larger amounts.
#	- <Tab> and <Shift-Tab> are bound to keyboard traversal
#	  of widgets.
#	- tk_bindForTraversal bindings are established.
#
# Notes:
#	This procedure is normally invoked from `init.tcl'; the user doesn't
#	generally have to call it unless building a customized set of
#	bindings.

proc scale_bindForTraversal args {
	foreach item $args {
		widget_bind $item GainFocus "scale:gainFocus"
		widget_bind $item LoseFocus "scale:loseFocus"
		bind $item <Any-Key-Left> "scale:incr %W -1 %A"
 #		bind $item <Any-Double-Key-Left> "scale:incr %W -5 %A"
 #		bind $item <Any-Triple-Key-Left> "scale:incr %W -25 %A"
		bind $item <Any-Key-Up> "scale:incr %W 1 %A"
 #		bind $item <Any-Double-Key-Up> "scale:incr %W 5 %A"
 #		bind $item <Any-Triple-Key-Up> "scale:incr %W 25 %A"
		bind $item <Any-Key-Right> "scale:incr %W 1 %A"
 #		bind $item <Any-Double-Key-Right> "scale:incr %W 5 %A"
 #		bind $item <Any-Triple-Key-Right> "scale:incr %W 25 %A"
		bind $item <Any-Key-Down> "scale:incr %W -1 %A"
 #		bind $item <Any-Double-Key-Down> "scale:incr %W -5 %A"
 #		bind $item <Any-Triple-Key-Down> "scale:incr %W -25 %A"
		bind $item <Any-Key-plus> "scale:incr %W 1 %A"
 #		bind $item <Any-Double-Key-plus> "scale:incr %W 5 %A"
 #		bind $item <Any-Triple-Key-plus> "scale:incr %W 25 %A"
		bind $item <Any-Key-minus> "scale:incr %W -1 %A"
 #		bind $item <Any-Double-Key-minus> "scale:incr %W -5 %A"
 #		bind $item <Any-Triple-Key-minus> "scale:incr %W -25 %A"
		focus_bindForTraversal $item
		tk_bindForTraversal $item
	}
}
