 #########################################################################
 #                                                                       #
 # Copyright (C) 1993 by General Electric company.  All rights reserved. #
 #                                                                       #
 # Permission to use, copy, modify, and distribute this                  #
 # software and its documentation for any purpose and without            #
 # fee is hereby granted, provided that the above copyright              #
 # notice appear in all copies and that both that copyright              #
 # notice and this permission notice appear in supporting                #
 # documentation, and that the name of General Electric not be used in   #
 # advertising or publicity pertaining to distribution of the            #
 # software without specific, written prior permission.                  #
 #                                                                       #
 # General Electric makes no representations about the suitability of    #
 # this software for any purpose.  It is provided ``as is''              #
 # without express or implied warranty.                                  #
 #                                                                       #
 # This work was supported in part by the DARPA Initiative in Concurrent #
 # Engineering (DICE) through DARPA Contracts MDA972-88-C-0047 and       #
 # MDA972-92-C-0027.                                                     #
 #                                                                       #
 # This work was supported in part by the Tri-Services Microwave and     #
 # Millimeter-Wave Advanced Computational Environment (MMACE) program    #
 # under Naval Research Laboratory contract N00014-92-C-2044.            #
 #                                                                       #
 #########################################################################


# File: labeledentry.tcl
#
# Description:
#	Widget that creates an entry box with labels.

 # $Id: labeledentry.tcl,v 1.11 1994/10/27 18:29:42 kennykb Exp $
 # $Source: /tmp_mnt/projects/cliff/iam/all/src/tkauxlib/RCS/labeledentry.tcl,v $
 # $Log: labeledentry.tcl,v $
 # Revision 1.11  1994/10/27  18:29:42  kennykb
 # Release 2.0 -- 10-27-94.  To be uploaded to archive sites.
 #
 # Revision 1.10  1993/11/01  18:20:46  kennykb
 # Beta release to be announced on comp.lang.tcl
 #
 # Revision 1.9  1993/10/27  15:52:49  kennykb
 # Package for alpha release to the Net, and for MMACE 931101 release.
 #
 # Revision 1.8  1993/10/20  19:10:47  kennykb
 # Alpha release #1 was thawed for bug fixes in tk 3.3.  Now frozen again at this
 # point.
 #
 # Revision 1.7  1993/10/20  18:47:15  kennykb
 # Fixed copyright notice so that it doesn't look like structured commentary.
 #
 # Revision 1.6  1993/10/14  18:15:42  kennykb
 # Cleaned up alignment of log messages, to avoid problems extracting
 # structured commentary.
 #
 # Revision 1.5  1993/10/14  18:06:59  kennykb
 # Added GE legal notice to head of file in preparation for release.
 #
 # Revision 1.4  1993/10/14  14:02:02  kennykb
 # Alpha release #1 frozen at this point.
 #
 # Revision 1.3  1993/07/21  19:44:36  kennykb
 # Finished cleaning up structured commentary.
 #
 # Revision 1.2  1993/07/16  15:58:00  kennykb
 # Renamed all commands that start with `wiget.' to either `widget_' or
 # `widget:'.  Added the code for creating composite widgets.
 #
 # Revision 1.1  1993/06/03  15:30:23  kennykb
 # Initial revision
 #

# Procedure:	labeledentry
#
# Synopsis:
#	Widget that creates an entry box with associated labels.
#
# Usage:
#c	labeledentry pathName ?-option value?...
#
# Parameters:
#c	pathName
#		Path name of the widget
#
# Options:
#	Name:			head
#	Class:			Head
#	Command-line switch:	-head
#	Default:		Null string.
#		Text to place before the entry box.
#	Name:			tail
#	Class:			Tail
#	Command-lins switch:	-tail
#	Default:		Null string
#		Text to place after the entry box.
#	Name:			validate
#	Class:			Validate
#	Command-line switch:	-validate
#	Default:		Null string
#		Procedure to run when focus leaves the entry, to validate
#		its contents.
#
# Return value:
#	Path name of the created widget.
#
# Description:
#	labeledentry creates an entry widget with optional labels to its left
#	and right.  It may also have a validateion procedure supplied, that
#	checks entry contents for validity when focus leaves the entry.
#	(checkInteger and checkReal are two commonly used procedures)
#
# Example:
#
#	The following example creates a box for entering a frequency,
#	specified in MHz, that must be a real number.
#
#c	labeledentry $w.freq -head "Frequency" -tail "MHz" \
#
#c		-validate checkReal
#
# Bugs:
#	The labeled entry is not a first class widget.  It ought to respond
#	to at least the `config' widget command.

	# Default look and feel:

option add *Labeledentry.entry.relief sunken widgetDefault
option add *Labeledentry.entry.borderWidth 2 widgetDefault
option add *Labeledentry.entry.font \
		-*-courier-medium-r-normal--*-120-* \
		widgetDefault
option add *Labeledentry.head.font \
		-*-helvetica-bold-r-normal--*-120-* \
		widgetDefault
option add *Labeledentry.tail.font \
		-*-helvetica-bold-r-normal--*-120-* \
		widgetDefault
option add *Labeledentry.Head {} widgetDefault
option add *Labeledentry.Tail {} widgetDefault
option add *Labeledentry.Validate {} widgetDefault

proc labeledentry {w args} {

	# Make the window

	frame $w -class Labeledentry

	# Defaults

	set head [option get $w head Head]
	set tail [option get $w tail Tail]
	set validate [option get $w validate Validate]
	set entryargs {}

	# Parse command line

	while {[llength $args] > 0} {
		set string [lindex $args 0]
		set args [lrange $args 1 end]
		case $string in {
			-head {
				set head [lindex $args 0]
				set args [lrange $args 1 end]
			}
			-tail {
				set tail [lindex $args 0]
				set args [lrange $args 1 end]
			}
			-validate {
				set validate [lindex $args 0]
				set args [lrange $args 1 end]
			}
			default {
				lappend entryargs $string
				lappend entryargs [lindex $args 0]
				set args [lrange $args 1 end]
			}
		}
	}

	# Create subwindows

	if {$head != ""} {
		pack append $w [label $w.head -text $head] {left}
	}
	pack append $w [eval "entry $w.entry $entryargs"] {left expand fillx}
	if {$tail != ""} {
		pack append $w [label $w.tail -text $tail] {left}
	}

	if {$validate != ""} {
		widget_bind $w.entry Validate "$validate $w.entry"
	}

	return $w
}
