 #########################################################################
 #                                                                       #
 # Copyright (C) 1993 by General Electric company.  All rights reserved. #
 #                                                                       #
 # Permission to use, copy, modify, and distribute this                  #
 # software and its documentation for any purpose and without            #
 # fee is hereby granted, provided that the above copyright              #
 # notice appear in all copies and that both that copyright              #
 # notice and this permission notice appear in supporting                #
 # documentation, and that the name of General Electric not be used in   #
 # advertising or publicity pertaining to distribution of the            #
 # software without specific, written prior permission.                  #
 #                                                                       #
 # General Electric makes no representations about the suitability of    #
 # this software for any purpose.  It is provided ``as is''              #
 # without express or implied warranty.                                  #
 #                                                                       #
 # This work was supported in part by the DARPA Initiative in Concurrent #
 # Engineering (DICE) through DARPA Contracts MDA972-88-C-0047 and       #
 # MDA972-92-C-0027.                                                     #
 #                                                                       #
 # This work was supported in part by the Tri-Services Microwave and     #
 # Millimeter-Wave Advanced Computational Environment (MMACE) program    #
 # under Naval Research Laboratory contract N00014-92-C-2044.            #
 #                                                                       #
 #########################################################################


# File:	icon.tcl
#
# Description:
#	Tcl procedures to implement an `icon' widget, which is
# 	just a label containing a bitmap that is searched on the auto_path.

 # $Id: icon.tcl,v 1.12 1994/10/27 18:29:42 kennykb Exp $
 # $Source: /tmp_mnt/projects/cliff/iam/all/src/tkauxlib/RCS/icon.tcl,v $
 # $Log: icon.tcl,v $
 # Revision 1.12  1994/10/27  18:29:42  kennykb
 # Release 2.0 -- 10-27-94.  To be uploaded to archive sites.
 #
 # Revision 1.11  1993/11/01  18:20:46  kennykb
 # Beta release to be announced on comp.lang.tcl
 #
 # Revision 1.10  1993/10/27  15:52:49  kennykb
 # Package for alpha release to the Net, and for MMACE 931101 release.
 #
 # Revision 1.9  1993/10/20  19:10:47  kennykb
 # Alpha release #1 was thawed for bug fixes in tk 3.3.  Now frozen again at this
 # point.
 #
 # Revision 1.8  1993/10/20  18:46:26  kennykb
 # Repaired copyright notice so that it doesn't look like structured commentary.
 #
 # Revision 1.7  1993/10/14  18:15:42  kennykb
 # Cleaned up alignment of log messages, to avoid problems extracting
 # structured commentary.
 #
 # Revision 1.6  1993/10/14  18:06:59  kennykb
 # Added GE legal notice to head of file in preparation for release.
 #
 # Revision 1.5  1993/10/14  14:02:02  kennykb
 # Alpha release #1 frozen at this point.
 #
 # Revision 1.4  1993/07/21  19:44:36  kennykb
 # Finished cleaning up structured commentary.
 #
 # Revision 1.3  1993/07/16  18:27:26  kennykb
 # Replaced close-brace inadvertently deleted (owing to missing newline at
 # end of file)
 #
 # Revision 1.2  1993/07/16  15:58:00  kennykb
 # Renamed all commands that start with `wiget.' to either `widget_' or
 # `widget:'.  Added the code for creating composite widgets.
 #
 # Revision 1.1  1993/06/03  15:29:30  kennykb
 # Initial revision
 #

# Procedure:	icon
#
# Synopsis:
#	Widget that displays an auto-loaded bitmap.
#
# Usage:
#c	icon pathName ?-option value ...?
#
# Parameters:
#c	pathName
#		Path name of the icon widget to create
#
# Options:
#	Name:	icon
#	Class:	icon
#	Command-line string:	-icon
#	Default:	{}
#		Supplies the name of the bitmap to appear as the icon.
#
#	Other options are as for `label.'
#
# Result:
#	Path name of the icon widget.
#
# Description:
#	The `icon' command creates an `icon widget'.  The icon widget is just
#	a label containing a bitmap.  The bitmap's name is specified by the
#	-icon option; the directories on auto_path are searched for a file
#
#c		name.xbm
#
#	where `name' is the name supplied with `-icon'.
#
# Bugs:
#	- The `-icon' option cannot be specified as an X default
#
#	- `icon' is not a first class widget.  It ought to accept the `config'
#	  widget command.

proc icon {w args} {

	set icon {}
	set fargs {}
	while {[llength $args] >= 2} {
		set option [lindex $args 0]
		set value [lindex $args 1]
		set args [lrange $args 2 end]
		case $option in {
			-icon { set icon $value }
			default {
				lappend fargs $option $value
			}
		}
	}
		if {$args != ""} {
		error "icon: extraneous argument $args"
	}

	if {$icon == ""} {
		error "icon: -icon argument missing"
	}

	set fileName [icon_find $icon]

	eval label $w [list -bitmap $fileName] $fargs

	return $w
}

# Procedure:	icon_find
#
# Synopsis:
#	Search the auto-load path for a bitmap
#
# Usage:
#c	icon_find iconName
#
# Parameters:
#c	iconName
#		Name of an icon whose bitmap is on the load path.
#
# Return value:
#	Bitmap (to use in a -bitmap option) of the icon.
#
# Description:
#	The `icon_find' command searches the load path for a named bitmap, 
#	and returns an appropriate bitmap name.  The file name is expected
#	to be
#
#c		iconName.xbm
#
#	where iconName is the name of the icon.
#
# Example:
#c	label .bomb -bitmap [icon_find bomb]
#		Creates a label with a picture of a bomb in it.

proc icon_find icon {
	global auto_path
	global icon_priv
	if {![info exists icon_priv(bitmap,$icon)]} {
		set fileName ""
		foreach dir $auto_path {
			if [file readable $dir/$icon.xbm] {
				set fileName $dir/$icon.xbm
				break
			}
		}
		set icon_priv(bitmap,$icon) $fileName
	} else {
		set fileName $icon_priv(bitmap,$icon)
	}
	if {$fileName == ""} {
		error "icon: icon `$icon' not found."
	}
	 
	return @$fileName
}
