 #########################################################################
 #                                                                       #
 # Copyright (C) 1993 by General Electric company.  All rights reserved. #
 #                                                                       #
 # Permission to use, copy, modify, and distribute this                  #
 # software and its documentation for any purpose and without            #
 # fee is hereby granted, provided that the above copyright              #
 # notice appear in all copies and that both that copyright              #
 # notice and this permission notice appear in supporting                #
 # documentation, and that the name of General Electric not be used in   #
 # advertising or publicity pertaining to distribution of the            #
 # software without specific, written prior permission.                  #
 #                                                                       #
 # General Electric makes no representations about the suitability of    #
 # this software for any purpose.  It is provided ``as is''              #
 # without express or implied warranty.                                  #
 #                                                                       #
 # This work was supported in part by the DARPA Initiative in Concurrent #
 # Engineering (DICE) through DARPA Contracts MDA972-88-C-0047 and       #
 # MDA972-92-C-0027.                                                     #
 #                                                                       #
 # This work was supported in part by the Tri-Services Microwave and     #
 # Millimeter-Wave Advanced Computational Environment (MMACE) program    #
 # under Naval Research Laboratory contract N00014-92-C-2044.            #
 #                                                                       #
 #########################################################################


# File: canvasAux.tcl

# Description:
#	The canvasAux.tcl file contains auxiliary procedures that handle the
#	bindings for canvas widgets.
#
#	At present, the only procedures that are supplied are the ones that
#	transfer the keyboard focus among text items in response to <Tab>
#	and <Shift-Tab> events.

 # $Id: canvasAux.tcl,v 1.14 1994/10/27 18:29:42 kennykb Exp $
 # $Source: /tmp_mnt/projects/cliff/iam/all/src/tkauxlib/RCS/canvasAux.tcl,v $
 # $Log: canvasAux.tcl,v $
 # Revision 1.14  1994/10/27  18:29:42  kennykb
 # Release 2.0 -- 10-27-94.  To be uploaded to archive sites.
 #
 # Revision 1.13  1993/11/01  18:20:46  kennykb
 # Beta release to be announced on comp.lang.tcl
 #
 # Revision 1.12  1993/10/27  15:52:49  kennykb
 # Package for alpha release to the Net, and for MMACE 931101 release.
 #
 # Revision 1.11  1993/10/21  21:32:48  kennykb
 # Made changes to allow for KP_Tab as well as Tab, since it appears that
 # certain X displays have two Tab keys.
 #
 # Revision 1.10  1993/10/20  19:10:47  kennykb
 # Alpha release #1 was thawed for bug fixes in tk 3.3.  Now frozen again at this
 # point.
 #
 # Revision 1.9  1993/10/20  18:39:01  kennykb
 # Repaired copyright notice so that it doesn't look like structured commentary.
 #
 # Revision 1.8  1993/10/14  18:15:42  kennykb
 # Cleaned up alignment of log messages, to avoid problems extracting
 # structured commentary.
 #
 # Revision 1.7  1993/10/14  18:06:59  kennykb
 # Added GE legal notice to head of file in preparation for release.
 #
 # Revision 1.6  1993/10/14  14:02:02  kennykb
 # Alpha release #1 frozen at this point.
 #
 # Revision 1.5  1993/07/20  19:17:12  kennykb
 # Improved structured comments.
 # Changed modules through `g' in the alphabet to follow `:' and `_' naming
 # conventions.
 #
 # Revision 1.4  1993/07/20  13:12:03  kennykb
 # Made `choicebox', `collapsible', and `debug' conform with naming and
 # commentary conventions
 #
 # Revision 1.3  1993/07/19  19:45:41  kennykb
 # Renamed `canvas.' procedures to `canvas:' or `canvas_' to conform
 # with new module naming conventions
 #
 # Revision 1.2  1993/07/19  18:49:24  kennykb
 # Renamed all button_ commands to either button. or button:, in
 # conformance with new module naming conventions.
 #
 # Revision 1.1  1993/06/03  15:25:00  kennykb
 # Initial revision
 #

# Procedure:	canvas_bindForTraversal
#
# Synopsis:
#	Keyboard traversal for canvas widgets.
#
# Usage:
#c	canvas_bindForTraversal pathName tagOrId ?-controlonly?
#
# Parameters:
#c	pathName
#		Name of a canvas widget.
#c	tagOrId
#		Item tag or identifier that identifies a set of items in
#		the canvas.
#c	-controlonly
#		Flag indicating that only Control Tab and Control Shift Tab
#		are to be bound.
#
# Return value:
#	None.
#
# Description:
#	The canvas_bindForTraversal function is used to establish traversal
#	key bindings for canvas items.  It should be called whenever keyboard
#	traversal is desired on a canvas item that accepts the focus.
#
#	The bindings that are established are-
#
#	- <Control-Tab> (and <Tab> if -controlonly is not specified) 
#	transfers keyboard focus to the next item in the application.
#
#	- <Control-Shift-Tab> (and <Shift-Tab> if -controlonly is not
#	specified) transfers keyboard focus to the previous item in
#	the application.
#
#	- <F10> and the <Alt-> keys are bound in the same way as
#	tk_bindForTraversal.
#
#	- The <Control-Return>, <Control-Enter>, and <Control-LineFeed> keys
#	(and their non-<Control-> counterparts if -controlonly is
#	not specified) invoke the current default action.

proc canvas_bindForTraversal {w tagOrId {controlonly ""}} {
	$w bind $tagOrId <Control-Tab> "canvas_goToNextItem %W"
	$w bind $tagOrId <Control-Shift-Tab> "canvas.goToPrevItem %W"
	catch {$w bind $tagOrId <Control-KP_Tab> "canvas_goToNextItem %W"}
	catch {
		$w bind $tagOrId \
			<Control-Shift-KP_Tab> "canvas.goToPrevItem %W"
	}
	$w bind $tagOrId <Control-Key-j> {entry_invokeDefaultButton %W}
	$w bind $tagOrId <Control-Key-m> {entry_invokeDefaultButton %W}
	catch {
		$w bind $tagOrId <Control-Key-Linefeed> {
			button_invokeDefault %W
		}
	}
	catch {
		$w bind $tagOrId <Control-Key-Return> {
			button_invokeDefault %W
		}
	}
	catch {
		$w bind $tagOrId <Control-Key-KP_Enter> {
			button_invokeDefault %W
		}
	}
	catch {
		$w bind $tagOrId <Control-Key-Enter> {
			button_invokeDefault %W
		}
	}
	if {$controlonly != "-controlonly"} {
		$w bind $tagOrId <Tab> "canvas_goToNextItem %W"
		$w bind $tagOrId <Shift-Tab> "canvas_goToPrevItem %W"
		catch {
			$w bind $tagOrId <Key-Linefeed> {
				button_invokeDefault %W
			}
		}
		catch {
			$w bind $tagOrId <Key-Return> {
				button_invokeDefault %W
			}
		}
		catch {
			$w bind $tagOrId <Key-KP_Enter> {
				button_invokeDefault %W
			}
		}
		catch {
			$w bind $tagOrId <Key-Enter> {
				button_invokeDefault %W
			}
		}
	}
	$w bind $tagOrId <Alt-Key> {tk_traverseToMenu %W %A}
	$w bind $tagOrId <F10> {tk_firstMenu %W}
}

# Procedure: canvas_goToNextItem
#
# Synopsis:
#	Tab to next item in a canvas
#
# Usage:
#c	canvas_goToNextItem pathName
#
# Parameters:
#c	pathName
#		Path name of a canvas widget.
#
# Return value:
#	None.
#
# Description:
#	The canvas_goToNextItem procedure is invoked when the user
#	presses <Tab> or <Control-Tab> when keyboard focus is directed
#	to a canvas item.  It directs keyboard focus to the logical
#	`next item' within the canvas, or to the next item in the
#	application if the current focus is at the last item in the
#	canvas.

proc canvas_goToNextItem w {
	set id [$w focus]
	if {$id != ""} {
		focus_goToNext [list $w $id]
	} else {
		focus_goToNext $w
	}
}

# Procedure: canvas_goToPrevItem
#
# Synopsis:
#	Tab to previous item in a canvas
#
# Usage:
#c	canvas_goToPrevItem pathName
#
# Parameters:
#c	pathName
#		Path name of a canvas widget.
#
# Return value:
#	None.
#
# Description:
#	The canvas_goToPrevItem procedure is invoked when the user presses
#	Shift Tab or Control Shift Tab when keyboard focus is directed to
#	a canvas item.  It directs keyboard focus to the logical `next item'
#	within the canvas, or to the next item in the application if the
#	current focus is at the last item in the canvas.

proc canvas_goToPrevItem w {
	set id [$w focus]
	if {$id != ""} {
		focus_goToPrev [list $w $id]
	} else {
		focus_goToPrev $w
	}
}
