# ~/.tk/jeditrc.tcl - user customisation file for jedit
######################################################################

######################################################################
# more procedures:

# deletesig t - delete the signature if it exists (and is tagged so):

proc deletesig { t } {
  catch {
    $t delete sig.first end
  }
}

######################################################################
# additions to GUI:

proc jedit:userhook { window } {
  set t [jedit:top_to_text $window]	;# relevant text widget
  ######################################################################
  # window icon:
  
  if {[winfo class $window] == "Toplevel"} {
    catch {
      global jed_icons
      
      if ![info exists jed_icons] {
        set jed_icons 0
      } else {
        incr jed_icons
      }
      
      wm withdraw $window
      
      set icon [j:new_toplevel .icon]
      j:tk3 {$icon configure -geometry 48x48}
      j:tk4 {$icon configure -width 48 -height 48}
      wm withdraw $icon
      frame $icon.menu -borderwidth 1 -width 48 -height 6 -relief raised
      frame $icon.label -borderwidth 0 -width 48 -height 4 -relief flat
      text $icon.text \
        -background white -borderwidth 0 -relief flat -wrap none
      catch {$icon.text configure -font nil2}
      scrollbar $icon.sb -borderwidth 1 -width 6
      pack $icon.menu
      pack $icon.label
      pack [j:rule $icon -relief flat -bg bisque3 -height 1] -fill x
      pack $icon.sb -side right -fill y
      pack $icon.text -side left -fill both -expand y
      
      update idletasks
      
      wm iconwindow $window $icon
      wm geometry $icon 48x48
      
      # main window geometry (but this is really the window manager's job!)
      #
      set numjedits 0
      foreach interp [winfo interps] {
        if [string match {jedit*} $interp] {incr numjedits}
      }
      
      set xoffset [expr {50 + ( $numjedits * 60 ) + ( $jed_icons * 50 ) }]
      set yoffset [expr {25 + ( $numjedits * 35 ) + ( $jed_icons * 25 ) }]
      
      wm geometry $window +$xoffset+$yoffset
      
      foreach w [list $icon $icon.menu $icon.label $icon.text $icon.sb] {
        foreach button {1 2 3 4 5} {
          bind $w <Any-ButtonPress-$button> { }
          bind $w <Any-ButtonPress-$button> "wm deiconify $window"
        }
      }
    }
    update
    
    bind $t <Unmap> [format {
      %s.text delete 1.0 end
      %s.text insert end [%s get 1.0 40.0]
    } $icon $icon $t]
    
    bind $t <Destroy> "destroy $icon"
    
    wm deiconify $window
  }
}

proc jedit:mkmenu:user {menu t} {
  $t tag configure hilight -background gold
  $t tag raise hilight				;# ????
  
  menubutton $menu -text {User} -menu $menu.m
  
  menu $menu.m
  $menu.m add command -label {Hilight} -command "
    $t tag add hilight sel.first sel.last
  "
  $menu.m add command -label {Unhilight} -command "
    $t tag remove hilight sel.first sel.last
  "
  $menu.m add command -label {Clear All Hilights} -command "
    $t tag remove hilight 1.0 end
  "
  $menu.m add separator
  $menu.m add command -label {Gold on Red} -command "
    jedit:format:background $t red
    jedit:format:foreground $t gold
    $t tag remove sel 1.0 end
    jedit:format:background:clear $t
    jedit:format:foreground:clear $t
  "
  $menu.m add command -label {Plain Colours} -command "
    jedit:format:background:clear $t
    jedit:format:foreground:clear $t
  "
  $menu.m add separator
  $menu.m add command -label {Source . . .} -command {
    source [j:fs {} {File to source:}]
  }
  $menu.m add command -label "C\346sar Cipher" -command [format {
    jedit:pipe %s "tr \
      abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ \
      nopqrstuvwxyzabcdefghijklmNOPQRSTUVWXYZABCDEFGHIJKLM"
  } $t]
  $menu.m add command -label "Unquote" -command [format {
    jedit:pipe %s "sed {s/^>//}"
  } $t]
  $menu.m add command -label {Insert Date} -command [format {
    %s insert insert \
    [exec date | awk "\{print \$2\" \"\$3\", \"\$6\}"]
  } $t]
  $menu.m add command -label {Insert Colour Name} -command [format {
    %s insert insert \
    [j:prompt_colour_name]
  } $t]
  $menu.m add command -label {Insert Colour RGB} -command [format {
    %s insert insert \
    [j:prompt_colour_rgb]
  } $t]
  $menu.m add command -label {Insert Font Name} -command [format {
    %s insert insert \
    [j:prompt_font]
  } $t]
  $menu.m add separator
  $menu.m add command -label {New xterm} -command {
    exec xterm &
  }
  $menu.m add command -label {New jbrowser} -command {
    exec jbrowser &
  }
}
