# ~/.tk/edittkmodes/mail-mode.tcl - mode for composing mail
######################################################################

proc mode:mail:init { t } {
  global JEDIT_MODEPREFS
  
  j:read_prefs -array JEDIT_MODEPREFS -prefix mail \
    -directory ~/.tk/jeditmodes -file mail-defaults {
    {textfont default}
    {textwidth 80}
    {textheight 24}
    {textwrap char}
    {sabbrev 0}
    {dabbrev 0}
    {autobreak 1}
    {autoindent 0}
    {savestate 0}
    {buttonbar 1}
    {menu,editor 1}
    {menu,file 1}
    {menu,edit 1}
    {menu,prefs 0}
    {menu,abbrev 1}
    {menu,filter 1}
    {menu,format 0}
    {menu,display 0}
    {menu,mode1 1}
    {menu,mode2 1}
    {menu,user 1}
  }
}

######################################################################
# more procedures:

# delete the signature if it exists (and is tagged so):

proc mode:mail:delete_sig { t } {
  catch {
    $t delete sig.first end
  }
}

proc mode:mail:insert_sig { t } {
  global env
  mode:mail:delete_sig $t
  set end [$t index end]
  $t insert end "\n"
  $t insert end [exec cat $env(HOME)/.signature]
  $t insert end "\n"
  $t tag add sig $end end
  $t tag configure sig -font {-*-courier-bold-r-normal--10-100-*}
  $t tag lower sig
}

proc mode:mail:start_reply { t } {
  set reply [exec cat "@" | sed {1,/^$/d} | \
    sed {s/^>/  /} | sed {s/^/  /}]
  $t insert end $reply
}

proc mode:mail:whom { t } {
  jedit:cmd:save $t
  set filename [jedit:get_filename $t]
  j:more -height 10 -width 60 -title "Recipients" \
    -text [exec whom -check $filename]
}

proc mode:mail:to_body { t } {
  $t mark set insert {header.last + 1 lines}
}

# BUG - doesn't handle multi-line headers.

proc mode:mail:next_header { t } {
  if [$t compare header.last <= insert] {
    $t mark set insert 1.0
  }
  
  set headpart [$t get insert header.last]
  
  set regex [format {(^|%s)[A-Za-z-]*:[ %s]*} "\n" "\t"]
  if [regexp -indices -- $regex $headpart indices] {
    $t tag remove sel 1.0 end
    set valuestart [expr [lindex $indices 1] + 1]
    $t mark set hdrfrom "insert + $valuestart chars"
    $t tag add sel hdrfrom {hdrfrom lineend}
    $t mark set insert {hdrfrom lineend}
  } else {
    # assume we're in the last header field, so jump to body
    mode:mail:to_body $t
  }
}

######################################################################
# define the Mail menu:
######################################################################

proc mode:mail:mkmenu1 { menu t } {
  menubutton $menu -text {Mail} -menu $menu.m
  
  menu $menu.m
  $menu.m add command -label {Sign Email} -command "
    mode:mail:insert_sig $t
  "
  $menu.m add command -label {Done} -command "
    jedit:cmd:done $t
  "
}

######################################################################
# define the button bar:
######################################################################

proc mode:mail:mkbuttons { w t } {
  j:buttonbar $w -pady 2 -buttons [format {
    {done Done {jedit:cmd:done %s}}
    {sign Sign {mode:mail:insert_sig %s}}
  } $t $t]
  return $w
}

