# jedit_io.tcl - file access procedures for jedit, a tk-based editor
# 
# Copyright 1992-1994 by Jay Sekora.  All rights reserved, except 
# that this file may be freely redistributed in whole or in part 
# for non-profit, noncommercial use.

# TO DO
#   abbrev fixes:
#     maybe some heuristics for things like plurals
#     maybe a syntax for suffixes (e.g., commit;t -> commitment)
#   file_modes panel
#   documentation for keybindings (automatic documentation?)
#   problem with filename getting set when you cancel Save 
#     for the first time on a new unnamed file
#   improve find panel
#     have find wrap around (if last time didn't match)
#     regex search/replace
#     find all at once (mark) and cycle through with tag nextrange
#   gesture commands
#   autobreaking space a problem if you use two spaces betw sentences
#   word-end punctuation (and heuristics) sd be mode-specific
#
#   PROBLEM WITH CHANGING BINDINGS ON THE FLY!               (urgent)

# CHANGES:
#   lots of binding changes (jbind*.tcl consistency)
#     app-specific Emacs and vi bindings
#   house(s) the s won't expand
#   return key checkpoints!
#   improved mode handling (hooks)

######################################################################

######################################################################
# "Load..." with supplied filename
######################################################################

proc jedit:read { filename t } {
  global JEDIT_MODEPREFS
  set mode [jedit:get_mode $t]
  if {! [info exists JEDIT_MODEPREFS($mode,savestate)]} {
    set JEDIT_MODEPREFS($mode,savestate) 0
  }
  set mode [jedit:get_mode $t]

  if {[info procs mode:$mode:pre_read_hook] != {}} {
    mode:$mode:pre_read_hook $filename $t
  }
  if {[info procs mode:$mode:read] != {}} {
    mode:$mode:read $filename $t
  } else {
    if {! [file exists $filename]} then {
      jedit:cmd:save_checkpoint $t		;# in case you were editing sth
      j:text:delete $t 1.0 end
      j:text:move $t 1.0
      jedit:set_label [jedit:text_to_top $t] "$filename (new file)"
    } else {
      jedit:cmd:save_checkpoint $t		;# so you can undo a load
      # should do error checking
      j:text:delete $t 1.0 end
      $t insert end  [j:fileio:read $filename]
      j:text:move $t 1.0
      #
      if $JEDIT_MODEPREFS($mode,savestate) {
        jedit:read_annotation $filename $t
        jedit:yview_insert $t
      }
      jedit:cmd:save_checkpoint $t		;# alows undo to original state
    }
  }
  jedit:set_label [jedit:text_to_top $t]	;# display name over text field
  if {[info procs mode:$mode:post_read_hook] != {}} {
    mode:$mode:post_read_hook $filename $t
  }
}

######################################################################
# write out a file
######################################################################

proc jedit:write { filename t } {
  global JEDIT_MODEPREFS
  set mode [jedit:get_mode $t]
  if {! [info exists JEDIT_MODEPREFS($mode,savestate)]} {
    set JEDIT_MODEPREFS($mode,savestate) 0
  }
  set mode [jedit:get_mode $t]
  
  if {[info procs mode:$mode:pre_write_hook] != {}} {
    mode:$mode:pre_write_hook $filename $t
  }
  if {[info procs mode:$mode:write] != {}} {
    mode:$mode:write $filename $t
  } else {
    # should do error checking
    j:fileio:write $filename [$t get 1.0 end]
    jedit:set_label [jedit:text_to_top $t]
    #
    if $JEDIT_MODEPREFS($mode,savestate) {
      jedit:write_annotation $filename $t
    }   
  }
  if {[info procs mode:$mode:post_write_hook] != {}} {
    mode:$mode:post_write_hook $filename $t
  }
}

######################################################################
# write out non-text content of a file
######################################################################

proc jedit:write_annotation { filename t } {
  set dirname [file dirname $filename]
  set tail [file tail $filename]
  set filename "$dirname/.state.$tail"
  # should do error checking
  j:fileio:write $filename [j:tag:get_annotation $t]
}

######################################################################
# restore non-text content of a file
######################################################################

proc jedit:read_annotation { filename t } {
### NEEDS ERROR CHECKING!
  set dirname [file dirname $filename]
  set tail [file tail $filename]
  set filename "$dirname/.state.$tail"
  catch {
    set state [j:fileio:read $filename]
    j:tag:set_annotation $t $state
  }
}

